/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.support.annotation.WorkerThread;
import com.onesignal.OSInAppMessage;
import com.onesignal.OSInAppMessageDisplayStats;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

class OSInAppMessageRepository {
    private static final long OS_IAM_MAX_CACHE_TIME = 15552000L;
    private final OneSignalDbHelper dbHelper;

    OSInAppMessageRepository(OneSignalDbHelper dbHelper) {
        this.dbHelper = dbHelper;
    }

    @WorkerThread
    synchronized void deleteOldRedisplayedInAppMessages() {
        long sixMonthsAgo = System.currentTimeMillis() / 1000L - 15552000L;
        SQLiteDatabase writableDb = this.dbHelper.getWritableDbWithRetries();
        writableDb.delete("in_app_message", "last_display< ?", new String[]{String.valueOf(sixMonthsAgo)});
        writableDb.close();
    }

    @WorkerThread
    synchronized void saveInAppMessage(OSInAppMessage inAppMessage) {
        SQLiteDatabase writableDb = this.dbHelper.getWritableDbWithRetries();
        ContentValues values = new ContentValues();
        values.put("message_id", inAppMessage.messageId);
        values.put("display_quantity", Integer.valueOf(inAppMessage.getDisplayStats().getDisplayQuantity()));
        values.put("last_display", Long.valueOf(inAppMessage.getDisplayStats().getLastDisplayTime()));
        values.put("click_ids", inAppMessage.getClickedClickIds().toString());
        values.put("displayed_in_session", Boolean.valueOf(inAppMessage.isDisplayedInSession()));
        int rowsUpdated = writableDb.update("in_app_message", values, "message_id = ?", new String[]{inAppMessage.messageId});
        if (rowsUpdated == 0) {
            writableDb.insert("in_app_message", null, values);
        }
        writableDb.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    synchronized List<OSInAppMessage> getRedisplayedInAppMessages() {
        ArrayList<OSInAppMessage> iams = new ArrayList<OSInAppMessage>();
        Cursor cursor = null;
        try {
            SQLiteDatabase readableDb = this.dbHelper.getReadableDbWithRetries();
            cursor = readableDb.query("in_app_message", null, null, null, null, null, null);
            if (cursor.moveToFirst()) {
                do {
                    String messageId = cursor.getString(cursor.getColumnIndex("message_id"));
                    String clickIds = cursor.getString(cursor.getColumnIndex("click_ids"));
                    int displayQuantity = cursor.getInt(cursor.getColumnIndex("display_quantity"));
                    long lastDisplay = cursor.getLong(cursor.getColumnIndex("last_display"));
                    boolean displayed = cursor.getInt(cursor.getColumnIndex("displayed_in_session")) == 1;
                    JSONArray clickIdsArray = new JSONArray(clickIds);
                    HashSet<String> clickIdsSet = new HashSet<String>();
                    for (int i = 0; i < clickIdsArray.length(); ++i) {
                        clickIdsSet.add(clickIdsArray.getString(i));
                    }
                    OSInAppMessage inAppMessage = new OSInAppMessage(messageId, clickIdsSet, displayed, new OSInAppMessageDisplayStats(displayQuantity, lastDisplay));
                    iams.add(inAppMessage);
                } while (cursor.moveToNext());
            }
        }
        catch (JSONException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Generating JSONArray from iam click ids:JSON Failed.", e);
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return iams;
    }
}

