/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.support.annotation.NonNull;
import com.onesignal.OSTrigger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class OSInAppMessage {
    @NonNull
    public String messageId;
    @NonNull
    public HashMap<String, HashMap<String, String>> variants;
    @NonNull
    public ArrayList<ArrayList<OSTrigger>> triggers;
    private double displayDuration;
    private boolean actionTaken;
    boolean isPreview;

    OSInAppMessage(boolean isPreview) {
        this.isPreview = isPreview;
    }

    OSInAppMessage(JSONObject json) throws JSONException {
        this.messageId = json.getString("id");
        this.variants = OSInAppMessage.parseVariants(json.getJSONObject("variants"));
        this.triggers = this.parseTriggerJson(json.getJSONArray("triggers"));
    }

    private static HashMap<String, HashMap<String, String>> parseVariants(JSONObject json) throws JSONException {
        HashMap<String, HashMap<String, String>> variantTypes = new HashMap<String, HashMap<String, String>>();
        Iterator keyIterator = json.keys();
        while (keyIterator.hasNext()) {
            String variantType = (String)keyIterator.next();
            JSONObject variant = json.getJSONObject(variantType);
            HashMap<String, String> variantMap = new HashMap<String, String>();
            Iterator variantIterator = variant.keys();
            while (variantIterator.hasNext()) {
                String languageType = (String)variantIterator.next();
                variantMap.put(languageType, variant.getString(languageType));
            }
            variantTypes.put(variantType, variantMap);
        }
        return variantTypes;
    }

    ArrayList<ArrayList<OSTrigger>> parseTriggerJson(JSONArray triggersJson) throws JSONException {
        ArrayList<ArrayList<OSTrigger>> parsedTriggers = new ArrayList<ArrayList<OSTrigger>>();
        for (int i = 0; i < triggersJson.length(); ++i) {
            JSONArray ands = triggersJson.getJSONArray(i);
            ArrayList<OSTrigger> converted = new ArrayList<OSTrigger>();
            for (int j = 0; j < ands.length(); ++j) {
                converted.add(new OSTrigger(ands.getJSONObject(j)));
            }
            parsedTriggers.add(converted);
        }
        return parsedTriggers;
    }

    JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        try {
            json.put("id", (Object)this.messageId);
            JSONObject variants = new JSONObject();
            for (String key : this.variants.keySet()) {
                HashMap<String, String> variant = this.variants.get(key);
                JSONObject converted = new JSONObject();
                for (String variantKey : variant.keySet()) {
                    converted.put(variantKey, (Object)variant.get(variantKey));
                }
                variants.put(key, (Object)converted);
            }
            json.put("variants", (Object)variants);
            json.put("display_duration", this.displayDuration);
            JSONArray orConditions = new JSONArray();
            for (ArrayList<OSTrigger> andArray : this.triggers) {
                JSONArray andConditions = new JSONArray();
                for (OSTrigger trigger : andArray) {
                    andConditions.put((Object)trigger.toJSONObject());
                }
                orConditions.put((Object)andConditions);
            }
            json.put("triggers", (Object)orConditions);
        }
        catch (JSONException exception) {
            exception.printStackTrace();
        }
        return json;
    }

    boolean takeActionAsUnique() {
        if (this.actionTaken) {
            return false;
        }
        this.actionTaken = true;
        return true;
    }

    public double getDisplayDuration() {
        return this.displayDuration;
    }

    public void setDisplayDuration(double displayDuration) {
        this.displayDuration = displayDuration;
    }

    public String toString() {
        return "OSInAppMessage{messageId='" + this.messageId + '\'' + ", variants=" + this.variants + ", triggers=" + this.triggers + ", displayDuration=" + this.displayDuration + ", actionTaken=" + this.actionTaken + '}';
    }
}

