/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.OneSignalRestClient;
import com.onesignal.OutcomeEvent;
import com.onesignal.OutcomeEventsCache;
import com.onesignal.OutcomeEventsService;
import com.onesignal.OutcomeParams;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class OutcomeEventsRepository {
    private static final String APP_ID = "app_id";
    private static final String DEVICE_TYPE = "device_type";
    private static final String DIRECT = "direct";
    private static final String NOTIFICATION_IDS = "notification_ids";
    private static final String OUTCOME_ID = "id";
    private final OutcomeEventsService outcomeEventsService;
    private final OneSignalDbHelper dbHelper;

    OutcomeEventsRepository(OneSignalDbHelper dbHelper) {
        this.outcomeEventsService = new OutcomeEventsService();
        this.dbHelper = dbHelper;
    }

    OutcomeEventsRepository(OutcomeEventsService outcomeEventsService, OneSignalDbHelper dbHelper) {
        this.outcomeEventsService = outcomeEventsService;
        this.dbHelper = dbHelper;
    }

    List<OutcomeEvent> getSavedOutcomeEvents() {
        return OutcomeEventsCache.getAllEventsToSend(this.dbHelper);
    }

    void saveOutcomeEvent(OutcomeEvent event) {
        OutcomeEventsCache.saveOutcomeEvent(event, this.dbHelper);
    }

    void removeEvent(OutcomeEvent outcomeEvent) {
        OutcomeEventsCache.deleteOldOutcomeEvent(outcomeEvent, this.dbHelper);
    }

    void requestMeasureDirectOutcomeEvent(String appId, int deviceType, OutcomeEvent event, OneSignalRestClient.ResponseHandler responseHandler) {
        JSONObject jsonObject = event.toJSONObjectWithNotification();
        try {
            jsonObject.put(APP_ID, (Object)appId);
            jsonObject.put(DEVICE_TYPE, deviceType);
            jsonObject.put(DIRECT, true);
            this.outcomeEventsService.sendOutcomeEvent(jsonObject, responseHandler);
        }
        catch (JSONException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Generating direct outcome:JSON Failed.", e);
        }
    }

    void requestMeasureDirectOutcomeEvent(String outcomeId, OutcomeParams outcomeParams, String appId, JSONArray notificationIds, int deviceType, OneSignalRestClient.ResponseHandler responseHandler) {
        try {
            JSONObject jsonBody = new JSONObject().put(APP_ID, (Object)appId).put(DEVICE_TYPE, deviceType).put(DIRECT, true).put(OUTCOME_ID, (Object)outcomeId).put(NOTIFICATION_IDS, (Object)notificationIds);
            if (outcomeParams != null) {
                outcomeParams.addParamsToJson(jsonBody);
            }
            this.outcomeEventsService.sendOutcomeEvent(jsonBody, responseHandler);
        }
        catch (JSONException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Generating direct outcome:JSON Failed.", e);
        }
    }

    void requestMeasureIndirectOutcomeEvent(String appId, int deviceType, OutcomeEvent event, OneSignalRestClient.ResponseHandler responseHandler) {
        JSONObject jsonObject = event.toJSONObjectWithNotification();
        try {
            jsonObject.put(APP_ID, (Object)appId);
            jsonObject.put(DEVICE_TYPE, deviceType);
            jsonObject.put(DIRECT, false);
            this.outcomeEventsService.sendOutcomeEvent(jsonObject, responseHandler);
        }
        catch (JSONException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Generating indirect outcome:JSON Failed.", e);
        }
    }

    void requestMeasureIndirectOutcomeEvent(String outcomeId, OutcomeParams outcomeParams, String appId, JSONArray notificationIds, int deviceType, OneSignalRestClient.ResponseHandler responseHandler) {
        try {
            JSONObject jsonBody = new JSONObject().put(APP_ID, (Object)appId).put(DEVICE_TYPE, deviceType).put(DIRECT, false).put(OUTCOME_ID, (Object)outcomeId).put(NOTIFICATION_IDS, (Object)notificationIds);
            if (outcomeParams != null) {
                outcomeParams.addParamsToJson(jsonBody);
            }
            this.outcomeEventsService.sendOutcomeEvent(jsonBody, responseHandler);
        }
        catch (JSONException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Generating indirect outcome:JSON Failed.", e);
        }
    }

    void requestMeasureUnattributedOutcomeEvent(String appId, int deviceType, OutcomeEvent event, OneSignalRestClient.ResponseHandler responseHandler) {
        JSONObject jsonObject = event.toJSONObject();
        try {
            jsonObject.put(APP_ID, (Object)appId);
            jsonObject.put(DEVICE_TYPE, deviceType);
            this.outcomeEventsService.sendOutcomeEvent(jsonObject, responseHandler);
        }
        catch (JSONException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Generating unattributed outcome:JSON Failed.", e);
        }
    }

    void requestMeasureUnattributedOutcomeEvent(String outcomeId, OutcomeParams outcomeParams, String appId, int deviceType, OneSignalRestClient.ResponseHandler responseHandler) {
        try {
            JSONObject jsonBody = new JSONObject().put(APP_ID, (Object)appId).put(OUTCOME_ID, (Object)outcomeId).put(DEVICE_TYPE, deviceType);
            if (outcomeParams != null) {
                outcomeParams.addParamsToJson(jsonBody);
            }
            this.outcomeEventsService.sendOutcomeEvent(jsonBody, responseHandler);
        }
        catch (JSONException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Generating unattributed outcome:JSON Failed.", e);
        }
    }
}

