/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.onesignal.OSSessionManager;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.OneSignalPrefs;
import com.onesignal.OneSignalRestClient;
import com.onesignal.OutcomeEvent;
import com.onesignal.OutcomeEventsRepository;
import com.onesignal.OutcomeParams;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;

class OutcomeEventsController {
    private static final String OS_SAVE_OUTCOMES = "OS_SAVE_OUTCOMES";
    private Set<String> attributedUniqueOutcomeEventsSentSet;
    private Set<String> unattributedUniqueOutcomeEventsSentSet;
    @NonNull
    private final OutcomeEventsRepository outcomeEventsRepository;
    @NonNull
    private final OSSessionManager osSessionManager;
    @Nullable
    private OneSignal.OutcomeSettings outcomeSettings;

    public OutcomeEventsController(@NonNull OSSessionManager osSessionManager, @NonNull OutcomeEventsRepository outcomeEventsRepository) {
        this.osSessionManager = osSessionManager;
        this.outcomeEventsRepository = outcomeEventsRepository;
        this.initUniqueOutcomeEventsSentSets();
    }

    OutcomeEventsController(@NonNull OSSessionManager osSessionManager, @NonNull OneSignalDbHelper dbHelper, @Nullable OneSignal.OutcomeSettings outcomeSettings) {
        this.outcomeEventsRepository = new OutcomeEventsRepository(dbHelper);
        this.osSessionManager = osSessionManager;
        this.outcomeSettings = outcomeSettings;
        this.initUniqueOutcomeEventsSentSets();
    }

    private void initUniqueOutcomeEventsSentSets() {
        if (this.unattributedUniqueOutcomeEventsSentSet == null) {
            this.unattributedUniqueOutcomeEventsSentSet = OSUtils.newConcurrentSet();
        }
        this.attributedUniqueOutcomeEventsSentSet = OSUtils.newConcurrentSet();
        Set<String> tempAttributedUniqueOutcomeEventsSentSet = OneSignalPrefs.getStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_UNIQUE_OUTCOME_EVENTS_SENT", null);
        if (tempAttributedUniqueOutcomeEventsSentSet != null) {
            this.attributedUniqueOutcomeEventsSentSet.addAll(tempAttributedUniqueOutcomeEventsSentSet);
        }
    }

    void setOutcomeSettings(@Nullable OneSignal.OutcomeSettings outcomeSettings) {
        this.outcomeSettings = outcomeSettings;
    }

    void cleanOutcomes() {
        this.unattributedUniqueOutcomeEventsSentSet = OSUtils.newConcurrentSet();
    }

    void sendSavedOutcomes() {
        if (this.outcomeSettings != null && !this.outcomeSettings.isCacheActive()) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setPriority(10);
                List<OutcomeEvent> outcomeEvents = OutcomeEventsController.this.outcomeEventsRepository.getSavedOutcomeEvents();
                for (OutcomeEvent event : outcomeEvents) {
                    OutcomeEventsController.this.sendSavedOutcomeEvent(event);
                }
            }
        }, "OS_SEND_SAVED_OUTCOMES").start();
    }

    private void sendSavedOutcomeEvent(final @NonNull OutcomeEvent event) {
        OSSessionManager.Session session = event.getSession();
        int deviceType = new OSUtils().getDeviceType();
        String appId = OneSignal.appId;
        OneSignalRestClient.ResponseHandler responseHandler = new OneSignalRestClient.ResponseHandler(){

            @Override
            void onSuccess(String response) {
                super.onSuccess(response);
                OutcomeEventsController.this.outcomeEventsRepository.removeEvent(event);
            }
        };
        switch (session) {
            case DIRECT: {
                this.outcomeEventsRepository.requestMeasureDirectOutcomeEvent(appId, deviceType, event, responseHandler);
                break;
            }
            case INDIRECT: {
                this.outcomeEventsRepository.requestMeasureIndirectOutcomeEvent(appId, deviceType, event, responseHandler);
                break;
            }
            case UNATTRIBUTED: {
                this.outcomeEventsRepository.requestMeasureUnattributedOutcomeEvent(appId, deviceType, event, responseHandler);
            }
        }
    }

    void sendOutcomeEvent(@NonNull String name, @Nullable OneSignal.OutcomeCallback callback) {
        JSONArray notificationIds = this.osSessionManager.getSessionResult().notificationIds;
        this.sendOutcomeEvent(name, notificationIds, null, callback);
    }

    void sendUniqueOutcomeEvent(@NonNull String name, @Nullable OneSignal.OutcomeCallback callback) {
        JSONArray notificationIds = this.osSessionManager.getSessionResult().notificationIds;
        if (this.osSessionManager.getSession().isAttributed()) {
            JSONArray uniqueNotificationIds = this.getUniqueNotificationIds(name, notificationIds);
            if (uniqueNotificationIds == null) {
                OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Measure endpoint will not send because unique outcome already sent for: \nSession: " + this.osSessionManager.getSession().toString() + "\nOutcome name: " + name + "\nnotificationIds: " + notificationIds);
                return;
            }
            this.sendOutcomeEvent(name, uniqueNotificationIds, null, callback);
        } else if (this.osSessionManager.getSession().isUnattributed()) {
            if (this.unattributedUniqueOutcomeEventsSentSet.contains(name)) {
                OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Measure endpoint will not send because unique outcome already sent for: \nSession: " + this.osSessionManager.getSession().toString() + "\nOutcome name: " + name);
                return;
            }
            this.unattributedUniqueOutcomeEventsSentSet.add(name);
            this.sendOutcomeEvent(name, null, null, callback);
        }
    }

    void sendOutcomeEventWithValue(@NonNull String name, float value, @Nullable OneSignal.OutcomeCallback callback) {
        JSONArray notificationIds = this.osSessionManager.getSessionResult().notificationIds;
        OutcomeParams params = OutcomeParams.Builder.newInstance().setWeight(Float.valueOf(value)).build();
        this.sendOutcomeEvent(name, notificationIds, params, callback);
    }

    private void sendOutcomeEvent(final @NonNull String name, final @Nullable JSONArray notificationIds, final @Nullable OutcomeParams params, final @Nullable OneSignal.OutcomeCallback callback) {
        OSSessionManager.SessionResult sessionResult = this.osSessionManager.getSessionResult();
        final OSSessionManager.Session session = sessionResult.session;
        String appId = OneSignal.appId;
        final long timestampSeconds = System.currentTimeMillis() / 1000L;
        int deviceType = new OSUtils().getDeviceType();
        OneSignalRestClient.ResponseHandler responseHandler = new OneSignalRestClient.ResponseHandler(){

            @Override
            void onSuccess(String response) {
                super.onSuccess(response);
                OneSignalPrefs.saveStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_UNIQUE_OUTCOME_EVENTS_SENT", OutcomeEventsController.this.attributedUniqueOutcomeEventsSentSet);
                if (callback != null) {
                    callback.onOutcomeSuccess(name);
                }
            }

            @Override
            void onFailure(int statusCode, String response, Throwable throwable) {
                super.onFailure(statusCode, response, throwable);
                if (OutcomeEventsController.this.isCacheActive()) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Thread.currentThread().setPriority(10);
                            OutcomeEventsController.this.outcomeEventsRepository.saveOutcomeEvent(new OutcomeEvent(session, notificationIds, name, timestampSeconds, params));
                        }
                    }, OutcomeEventsController.OS_SAVE_OUTCOMES).start();
                }
                if (callback != null) {
                    callback.onOutcomeFail(statusCode, response);
                }
            }
        };
        switch (session) {
            case DIRECT: {
                this.outcomeEventsRepository.requestMeasureDirectOutcomeEvent(name, params, appId, notificationIds, deviceType, responseHandler);
                break;
            }
            case INDIRECT: {
                this.outcomeEventsRepository.requestMeasureIndirectOutcomeEvent(name, params, appId, notificationIds, deviceType, responseHandler);
                break;
            }
            case UNATTRIBUTED: {
                this.outcomeEventsRepository.requestMeasureUnattributedOutcomeEvent(name, params, appId, deviceType, responseHandler);
                break;
            }
            case DISABLED: {
                OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "Outcomes for current session are disabled");
            }
        }
    }

    private JSONArray getUniqueNotificationIds(String name, JSONArray notificationIds) {
        boolean hasNoUniqueNotificationIds = this.hasNoUniqueOutcomeNotificationIds(name, notificationIds);
        if (hasNoUniqueNotificationIds) {
            return null;
        }
        return this.getUniqueOutcomeNotificationIds(name, notificationIds);
    }

    private boolean hasNoUniqueOutcomeNotificationIds(String uniqueName, JSONArray notificationIds) {
        int uniqueIdCount = 0;
        try {
            for (int i = 0; i < notificationIds.length(); ++i) {
                String notificationId = notificationIds.getString(i);
                String uniqueOutcomeNotificationId = uniqueName + "_" + notificationId;
                if (!this.attributedUniqueOutcomeEventsSentSet.contains(uniqueOutcomeNotificationId)) continue;
                ++uniqueIdCount;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
        return uniqueIdCount == notificationIds.length();
    }

    private JSONArray getUniqueOutcomeNotificationIds(String uniqueName, @Nullable JSONArray notificationIds) {
        if (notificationIds == null) {
            return new JSONArray();
        }
        JSONArray uniqueNotificationIds = new JSONArray();
        try {
            for (int i = 0; i < notificationIds.length(); ++i) {
                String notificationId = notificationIds.getString(i);
                String uniqueOutcomeNotificationId = uniqueName + "_" + notificationId;
                if (this.attributedUniqueOutcomeEventsSentSet.contains(uniqueOutcomeNotificationId)) continue;
                this.attributedUniqueOutcomeEventsSentSet.add(uniqueOutcomeNotificationId);
                uniqueNotificationIds.put((Object)notificationId);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new JSONArray();
        }
        return uniqueNotificationIds;
    }

    boolean isCacheActive() {
        return this.outcomeSettings == null || this.outcomeSettings.isCacheActive();
    }

    static class OutcomeException
    extends Exception {
        OutcomeException(String message) {
            super(message);
        }
    }
}

