/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.onesignal.OSSessionManager;
import com.onesignal.OneSignal;
import com.onesignal.OutcomeParams;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OutcomeEvent {
    private static final String NOTIFICATION_IDs = "notification_ids";
    private static final String OUTCOME_ID = "id";
    private static final String TIMESTAMP = "timestamp";
    private OSSessionManager.Session session;
    private OutcomeParams params;
    private JSONArray notificationIds;
    private String name;
    private long timestamp;

    public OutcomeEvent(@NonNull OSSessionManager.Session session, @Nullable JSONArray notificationIds, @NonNull String name, long timestamp, @Nullable OutcomeParams params) {
        this.session = session;
        this.notificationIds = notificationIds;
        this.name = name;
        this.timestamp = timestamp;
        this.params = params;
    }

    public OSSessionManager.Session getSession() {
        return this.session;
    }

    public void setSession(OSSessionManager.Session session) {
        this.session = session;
    }

    public JSONArray getNotificationIds() {
        return this.notificationIds;
    }

    public void setNotificationIds(JSONArray notificationIds) {
        this.notificationIds = notificationIds;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getParams() {
        return this.params != null ? this.params.getAsJSONString() : null;
    }

    public JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        try {
            json.put(OUTCOME_ID, (Object)this.name);
            json.put(TIMESTAMP, this.timestamp);
            if (this.params != null) {
                this.params.addParamsToJson(json);
            }
        }
        catch (JSONException exception) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Generating OutcomeEvent toJSONObject ", exception);
        }
        return json;
    }

    JSONObject toJSONObjectWithNotification() {
        JSONObject json = this.toJSONObject();
        try {
            json.put(NOTIFICATION_IDs, (Object)this.notificationIds);
        }
        catch (JSONException exception) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Generating OutcomeEvent toJSONObject ", exception);
        }
        return json;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutcomeEvent event = (OutcomeEvent)o;
        return this.timestamp == event.timestamp && this.session == event.session && this.notificationIds.equals((Object)event.notificationIds) && this.name.equals(event.name);
    }

    public int hashCode() {
        Object[] a = new Object[]{this.session, this.notificationIds, this.name, this.timestamp};
        int result = 1;
        for (Object element : a) {
            result = 31 * result + (element == null ? 0 : element.hashCode());
        }
        return result;
    }

    public String toString() {
        return "OutcomeEvent{session=" + (Object)((Object)this.session) + ", params=" + this.params + ", notificationIds=" + this.notificationIds + ", name='" + this.name + '\'' + ", timestamp=" + this.timestamp + '}';
    }
}

