/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.support.annotation.NonNull;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalRestClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class OneSignalRemoteParams {
    private static int androidParamsRetries = 0;
    private static final int INCREASE_BETWEEN_RETRIES = 10000;
    private static final int MIN_WAIT_BETWEEN_RETRIES = 30000;
    private static final int MAX_WAIT_BETWEEN_RETRIES = 90000;

    OneSignalRemoteParams() {
    }

    static void makeAndroidParamsRequest(final @NonNull CallBack callBack) {
        OneSignalRestClient.ResponseHandler responseHandler = new OneSignalRestClient.ResponseHandler(){

            @Override
            void onFailure(int statusCode, String response, Throwable throwable) {
                if (statusCode == 403) {
                    OneSignal.Log(OneSignal.LOG_LEVEL.FATAL, "403 error getting OneSignal params, omitting further retries!");
                    return;
                }
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int sleepTime = 30000 + androidParamsRetries * 10000;
                        if (sleepTime > 90000) {
                            sleepTime = 90000;
                        }
                        OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "Failed to get Android parameters, trying again in " + sleepTime / 1000 + " seconds.");
                        OSUtils.sleep(sleepTime);
                        androidParamsRetries++;
                        OneSignalRemoteParams.makeAndroidParamsRequest(callBack);
                    }
                }, "OS_PARAMS_REQUEST").start();
            }

            @Override
            void onSuccess(String response) {
                OneSignalRemoteParams.processJson(response, callBack);
            }
        };
        String params_url = "apps/" + OneSignal.appId + "/android_params.js";
        String userId = OneSignal.getUserId();
        if (userId != null) {
            params_url = params_url + "?player_id=" + userId;
        }
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Starting request to get Android parameters.");
        OneSignalRestClient.get(params_url, responseHandler, "CACHE_KEY_REMOTE_PARAMS");
    }

    private static void processJson(String json, @NonNull CallBack callBack) {
        JSONObject responseJson;
        try {
            responseJson = new JSONObject(json);
        }
        catch (NullPointerException | JSONException t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.FATAL, "Error parsing android_params!: ", t);
            OneSignal.Log(OneSignal.LOG_LEVEL.FATAL, "Response that errored from android_params!: " + json);
            return;
        }
        Params params = new Params(){
            {
                this.enterprise = responseJson.optBoolean("enterp", false);
                this.useEmailAuth = responseJson.optBoolean("use_email_auth", false);
                this.notificationChannels = responseJson.optJSONArray("chnl_lst");
                this.firebaseAnalytics = responseJson.optBoolean("fba", false);
                this.restoreTTLFilter = responseJson.optBoolean("restore_ttl_filter", true);
                this.googleProjectNumber = responseJson.optString("android_sender_id", null);
            }
        };
        callBack.complete(params);
    }

    static interface CallBack {
        public void complete(Params var1);
    }

    static class Params {
        String googleProjectNumber;
        boolean enterprise;
        boolean useEmailAuth;
        JSONArray notificationChannels;
        boolean firebaseAnalytics;
        boolean restoreTTLFilter;

        Params() {
        }
    }
}

