/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.NotificationManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Build;
import android.os.Bundle;
import android.service.notification.StatusBarNotification;
import android.support.annotation.RequiresApi;
import com.onesignal.NotificationLimitManager;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbContract;
import com.onesignal.shortcutbadger.ShortcutBadger;

class BadgeCountUpdater {
    private static int badgesEnabled = -1;

    BadgeCountUpdater() {
    }

    private static boolean areBadgeSettingsEnabled(Context context) {
        if (badgesEnabled != -1) {
            return badgesEnabled == 1;
        }
        try {
            String defaultStr;
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            badgesEnabled = bundle != null ? ("DISABLE".equals(defaultStr = bundle.getString("com.onesignal.BadgeCount")) ? 0 : 1) : 1;
        }
        catch (Throwable t) {
            badgesEnabled = 0;
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error reading meta-data tag 'com.onesignal.BadgeCount'. Disabling badge setting.", t);
        }
        return badgesEnabled == 1;
    }

    private static boolean areBadgesEnabled(Context context) {
        return BadgeCountUpdater.areBadgeSettingsEnabled(context) && OSUtils.areNotificationsEnabled(context);
    }

    static void update(SQLiteDatabase readableDb, Context context) {
        if (!BadgeCountUpdater.areBadgesEnabled(context)) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            BadgeCountUpdater.updateStandard(context);
        } else {
            BadgeCountUpdater.updateFallback(readableDb, context);
        }
    }

    @RequiresApi(api=23)
    private static void updateStandard(Context context) {
        NotificationManager notifManager = (NotificationManager)context.getSystemService("notification");
        StatusBarNotification[] activeNotifs = notifManager.getActiveNotifications();
        int runningCount = 0;
        for (StatusBarNotification activeNotif : activeNotifs) {
            if (NotificationLimitManager.isGroupSummary(activeNotif)) continue;
            ++runningCount;
        }
        BadgeCountUpdater.updateCount(runningCount, context);
    }

    private static void updateFallback(SQLiteDatabase readableDb, Context context) {
        Cursor cursor = readableDb.query("notification", null, OneSignalDbContract.NotificationTable.recentUninteractedWithNotificationsWhere().toString(), null, null, null, null, NotificationLimitManager.MAX_NUMBER_OF_NOTIFICATIONS_STR);
        int notificationCount = cursor.getCount();
        cursor.close();
        BadgeCountUpdater.updateCount(notificationCount, context);
    }

    static void updateCount(int count, Context context) {
        if (!BadgeCountUpdater.areBadgeSettingsEnabled(context)) {
            return;
        }
        try {
            ShortcutBadger.applyCountOrThrow(context, count);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

