/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.support.annotation.Nullable;
import com.onesignal.ActivityLifecycleHandler;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalStateSynchronizer;

public class SyncService
extends Service {
    private void checkOnFocusSync() {
        long unsentTime = OneSignal.GetUnsentActiveTime();
        if (unsentTime < 60L) {
            return;
        }
        OneSignal.sendOnFocus(unsentTime, true);
    }

    public void onCreate() {
        if (OneSignal.startedSyncService) {
            return;
        }
        OneSignal.appContext = this.getApplicationContext();
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (OneSignal.getUserId() == null) {
                    SyncService.this.stopSelf();
                    return;
                }
                OneSignal.appId = OneSignal.getSavedAppId();
                OneSignalStateSynchronizer.initUserState(OneSignal.appContext);
                OneSignalStateSynchronizer.syncUserState(true);
                SyncService.this.checkOnFocusSync();
                SyncService.this.stopSelf();
            }
        }).start();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return OneSignal.startedSyncService ? 1 : 2;
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
        SyncService.onTaskRemoved();
    }

    static void onTaskRemoved() {
        ActivityLifecycleHandler.focusHandlerThread.stopScheduledRunnable();
        OneSignalStateSynchronizer.stopAndPersist();
        OneSignal.onAppLostFocus(true);
    }
}

