/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.onesignal.GcmIntentService;
import com.onesignal.NotificationBundleProcessor;
import com.onesignal.NotificationExtenderService;
import com.onesignal.OneSignalDbHelper;

class NotificationRestorer {
    public static boolean restored;

    NotificationRestorer() {
    }

    static void asyncRestore(final Context context) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NotificationRestorer.restore(context);
            }
        }).start();
    }

    public static void restore(Context context) {
        if (restored) {
            return;
        }
        restored = true;
        OneSignalDbHelper dbHelper = new OneSignalDbHelper(context);
        SQLiteDatabase writableDb = dbHelper.getWritableDatabase();
        NotificationBundleProcessor.deleteOldNotifications(writableDb);
        String[] retColumn = new String[]{"android_notification_id", "full_data"};
        Cursor cursor = writableDb.query("notification", retColumn, "created_time > " + (System.currentTimeMillis() / 1000L - 604800L) + " AND " + "dismissed" + " = 0 AND " + "opened" + " = 0 AND " + "is_summary" + " = 0", null, null, null, "_id ASC");
        if (cursor.moveToFirst()) {
            boolean useExtender = NotificationExtenderService.getIntent(context) != null;
            do {
                int existingId = cursor.getInt(cursor.getColumnIndex("android_notification_id"));
                String fullData = cursor.getString(cursor.getColumnIndex("full_data"));
                Intent serviceIntent = useExtender ? NotificationExtenderService.getIntent(context) : new Intent().setComponent(new ComponentName(context.getPackageName(), GcmIntentService.class.getName()));
                serviceIntent.putExtra("json_payload", fullData);
                serviceIntent.putExtra("android_notif_id", existingId);
                serviceIntent.putExtra("restoring", true);
                context.startService(serviceIntent);
            } while (cursor.moveToNext());
        }
        cursor.close();
        writableDb.close();
    }
}

