/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.R;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import com.onesignal.OneSignal;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class GenerateNotification {
    private static Context serviceContext = null;
    private static String packageName = null;
    private static Resources contextResources = null;
    private static Class<?> notificationOpenedActivityClass;

    GenerateNotification() {
    }

    public static void fromBundle(Context inServiceContext, Bundle bundle, Class<?> inNotificationOpenedActivityClass, boolean showAsAlert) {
        serviceContext = inServiceContext;
        packageName = serviceContext.getPackageName();
        contextResources = serviceContext.getResources();
        notificationOpenedActivityClass = inNotificationOpenedActivityClass;
        if (showAsAlert) {
            GenerateNotification.showNotificationAsAlert(bundle, (Context)OneSignal.appContext);
        } else {
            GenerateNotification.buildNotification(bundle);
        }
    }

    private static void showNotificationAsAlert(final Bundle gcmBundle, final Context context) {
        ((Activity)context).runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AlertDialog.Builder builder = new AlertDialog.Builder(context);
                builder.setTitle(GenerateNotification.getTitle(gcmBundle));
                builder.setMessage((CharSequence)gcmBundle.getString("alert"));
                ArrayList buttonsLabels = new ArrayList();
                ArrayList buttonIds = new ArrayList();
                GenerateNotification.addAlertButtons(gcmBundle, buttonsLabels, buttonIds);
                final ArrayList finalButtonIds = buttonIds;
                DialogInterface.OnClickListener buttonListener = new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        int index = which + 3;
                        if (finalButtonIds.size() > 1) {
                            try {
                                JSONObject customJson = new JSONObject(gcmBundle.getString("custom"));
                                JSONObject additionalDataJSON = customJson.getJSONObject("a");
                                additionalDataJSON.put("actionSelected", finalButtonIds.get(index));
                                Bundle bundle = new Bundle(gcmBundle);
                                bundle.putString("custom", customJson.toString());
                                OneSignal.handleNotificationOpened(context, bundle);
                            }
                            catch (Throwable t) {}
                        } else {
                            OneSignal.handleNotificationOpened(context, gcmBundle);
                        }
                    }
                };
                builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialogInterface) {
                        OneSignal.handleNotificationOpened(context, gcmBundle);
                    }
                });
                for (int i = 0; i < buttonsLabels.size(); ++i) {
                    if (i == 0) {
                        builder.setNeutralButton((CharSequence)buttonsLabels.get(i), buttonListener);
                        continue;
                    }
                    if (i == 1) {
                        builder.setNegativeButton((CharSequence)buttonsLabels.get(i), buttonListener);
                        continue;
                    }
                    if (i != 2) continue;
                    builder.setPositiveButton((CharSequence)buttonsLabels.get(i), buttonListener);
                }
                AlertDialog alertDialog = builder.create();
                alertDialog.setCanceledOnTouchOutside(false);
                alertDialog.show();
            }
        });
    }

    private static CharSequence getTitle(Bundle gcmBundle) {
        String title = gcmBundle.getString("title");
        if (title != null) {
            return title;
        }
        return serviceContext.getPackageManager().getApplicationLabel(serviceContext.getApplicationInfo());
    }

    private static Intent getNewBaseIntent() {
        return new Intent(serviceContext, notificationOpenedActivityClass).addFlags(0x24000000);
    }

    private static void buildNotification(Bundle gcmBundle) {
        Bitmap bigPictureIcon;
        Random random = new Random();
        int intentId = random.nextInt();
        int notificationId = random.nextInt();
        NotificationManager mNotificationManager = (NotificationManager)serviceContext.getSystemService("notification");
        PendingIntent contentIntent = PendingIntent.getActivity((Context)serviceContext, (int)intentId, (Intent)GenerateNotification.getNewBaseIntent().putExtra("data", gcmBundle), (int)0x8000000);
        int notificationIcon = GenerateNotification.getSmallIconId(gcmBundle);
        int notificationDefaults = 0;
        if (OneSignal.getVibrate(serviceContext)) {
            notificationDefaults = 2;
        }
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(serviceContext).setAutoCancel(true).setSmallIcon(notificationIcon).setContentTitle(GenerateNotification.getTitle(gcmBundle)).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)gcmBundle.getString("alert"))).setTicker((CharSequence)gcmBundle.getString("alert")).setContentText((CharSequence)gcmBundle.getString("alert"));
        if (gcmBundle.containsKey("bgac")) {
            try {
                mBuilder.setColor(new BigInteger(gcmBundle.getString("bgac"), 16).intValue());
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (gcmBundle.containsKey("ledc")) {
            try {
                mBuilder.setLights(new BigInteger(gcmBundle.getString("ledc"), 16).intValue(), 2000, 5000);
            }
            catch (Throwable t) {
                notificationDefaults |= 4;
            }
        } else {
            notificationDefaults |= 4;
        }
        try {
            int visibility = 1;
            if (gcmBundle.containsKey("vis")) {
                visibility = Integer.parseInt(gcmBundle.getString("vis"));
            }
            mBuilder.setVisibility(visibility);
        }
        catch (Throwable t) {
            // empty catch block
        }
        Bitmap largeIcon = GenerateNotification.getLargeIcon(gcmBundle);
        if (largeIcon != null) {
            mBuilder.setLargeIcon(largeIcon);
        }
        if ((bigPictureIcon = GenerateNotification.getBitmapIcon(gcmBundle, "bicon")) != null) {
            mBuilder.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(bigPictureIcon).setSummaryText((CharSequence)gcmBundle.getString("alert")));
        }
        if (OneSignal.getSoundEnabled(serviceContext)) {
            Uri soundUri = GenerateNotification.getCustomSound(gcmBundle);
            if (soundUri != null) {
                mBuilder.setSound(soundUri);
            } else {
                notificationDefaults |= 1;
            }
        }
        mBuilder.setDefaults(notificationDefaults);
        mBuilder.setContentIntent(contentIntent);
        GenerateNotification.addNotificationActionButtons(gcmBundle, mBuilder, notificationId);
        mNotificationManager.notify(notificationId, mBuilder.build());
    }

    private static boolean isValidResourceName(String name) {
        return name != null && !name.matches("^[0-9]");
    }

    private static Bitmap getLargeIcon(Bundle gcmBundle) {
        if (Build.VERSION.SDK_INT < 11) {
            return null;
        }
        Bitmap bitmap = GenerateNotification.getBitmapIcon(gcmBundle, "licon");
        if (bitmap == null) {
            bitmap = GenerateNotification.getBitmapFromAssetsOrResourceName("ic_onesignal_large_icon_default");
        }
        if (bitmap == null) {
            bitmap = GenerateNotification.getBitmapFromAssetsOrResourceName("ic_gamethrive_large_icon_default");
        }
        if (bitmap == null) {
            return null;
        }
        try {
            int systemLargeIconHeight = (int)contextResources.getDimension(17104902);
            int systemLargeIconWidth = (int)contextResources.getDimension(0x1050005);
            int bitmapHeight = bitmap.getHeight();
            int bitmapWidth = bitmap.getWidth();
            if (bitmapWidth > systemLargeIconWidth || bitmapHeight > systemLargeIconHeight) {
                int newWidth = systemLargeIconWidth;
                int newHeight = systemLargeIconHeight;
                if (bitmapHeight > bitmapWidth) {
                    float ratio = (float)bitmapWidth / (float)bitmapHeight;
                    newWidth = (int)((float)newHeight * ratio);
                } else if (bitmapWidth > bitmapHeight) {
                    float ratio = (float)bitmapHeight / (float)bitmapWidth;
                    newHeight = (int)((float)newWidth * ratio);
                }
                return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)newWidth, (int)newHeight, (boolean)true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bitmap;
    }

    private static Bitmap getBitmapFromAssetsOrResourceName(String bitmapStr) {
        try {
            Bitmap bitmap = null;
            try {
                bitmap = BitmapFactory.decodeStream((InputStream)serviceContext.getAssets().open(bitmapStr));
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (bitmap != null) {
                return bitmap;
            }
            List<String> image_extensions = Arrays.asList(".png", ".webp", ".jpg", ".gif", ".bmp");
            for (String extension : image_extensions) {
                try {
                    bitmap = BitmapFactory.decodeStream((InputStream)serviceContext.getAssets().open(bitmapStr + extension));
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (bitmap == null) continue;
                return bitmap;
            }
            int bitmapId = GenerateNotification.getResourceIcon(bitmapStr);
            if (bitmapId != 0) {
                return BitmapFactory.decodeResource((Resources)contextResources, (int)bitmapId);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static Bitmap getBitmapFromURL(String location) {
        try {
            return BitmapFactory.decodeStream((InputStream)new URL(location).openConnection().getInputStream());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Bitmap getBitmapIcon(Bundle gcmBundle, String key) {
        if (gcmBundle.containsKey(key)) {
            String bitmapStr = gcmBundle.getString(key);
            if (bitmapStr.startsWith("http://") || bitmapStr.startsWith("https://")) {
                return GenerateNotification.getBitmapFromURL(bitmapStr);
            }
            return GenerateNotification.getBitmapFromAssetsOrResourceName(bitmapStr);
        }
        return null;
    }

    private static int getResourceIcon(String iconName) {
        if (!GenerateNotification.isValidResourceName(iconName)) {
            return 0;
        }
        int notificationIcon = GenerateNotification.getDrawableId(iconName);
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        try {
            return R.drawable.class.getField(iconName).getInt(null);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private static int getSmallIconId(Bundle gcmBundle) {
        int notificationIcon = 0;
        if (gcmBundle.containsKey("sicon") && (notificationIcon = GenerateNotification.getResourceIcon(gcmBundle.getString("sicon"))) != 0) {
            return notificationIcon;
        }
        notificationIcon = GenerateNotification.getDrawableId("ic_stat_onesignal_default");
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        notificationIcon = GenerateNotification.getDrawableId("ic_stat_gamethrive_default");
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        notificationIcon = GenerateNotification.getDrawableId("corona_statusbar_icon_default");
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        notificationIcon = GenerateNotification.serviceContext.getApplicationInfo().icon;
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        return 17301651;
    }

    private static int getDrawableId(String name) {
        return contextResources.getIdentifier(name, "drawable", packageName);
    }

    private static Uri getCustomSound(Bundle gcmBundle) {
        int soundId;
        if (GenerateNotification.isValidResourceName(gcmBundle.getString("sound")) && (soundId = contextResources.getIdentifier(gcmBundle.getString("sound"), "raw", packageName)) != 0) {
            return Uri.parse((String)("android.resource://" + packageName + "/" + soundId));
        }
        soundId = contextResources.getIdentifier("onesignal_default_sound", "raw", packageName);
        if (soundId != 0) {
            return Uri.parse((String)("android.resource://" + packageName + "/" + soundId));
        }
        soundId = contextResources.getIdentifier("gamethrive_default_sound", "raw", packageName);
        if (soundId != 0) {
            return Uri.parse((String)("android.resource://" + packageName + "/" + soundId));
        }
        return null;
    }

    private static void addNotificationActionButtons(Bundle gcmBundle, NotificationCompat.Builder mBuilder, int notificationId) {
        try {
            JSONObject additionalDataJSON;
            JSONObject customJson = new JSONObject(gcmBundle.getString("custom"));
            if (customJson.has("a") && (additionalDataJSON = customJson.getJSONObject("a")).has("actionButtons")) {
                JSONArray buttons = additionalDataJSON.getJSONArray("actionButtons");
                for (int i = 0; i < buttons.length(); ++i) {
                    JSONObject button = buttons.getJSONObject(i);
                    additionalDataJSON.put("actionSelected", (Object)button.getString("id"));
                    Bundle bundle = new Bundle(gcmBundle);
                    bundle.putString("custom", customJson.toString());
                    Intent buttonIntent = GenerateNotification.getNewBaseIntent();
                    buttonIntent.setAction("" + i);
                    buttonIntent.putExtra("notificationId", notificationId);
                    buttonIntent.putExtra("data", bundle);
                    PendingIntent buttonPIntent = PendingIntent.getActivity((Context)serviceContext, (int)notificationId, (Intent)buttonIntent, (int)0x8000000);
                    int buttonIcon = 0;
                    if (button.has("icon")) {
                        buttonIcon = GenerateNotification.getResourceIcon(button.getString("icon"));
                    }
                    mBuilder.addAction(buttonIcon, (CharSequence)button.getString("text"), buttonPIntent);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private static void addAlertButtons(Bundle gcmBundle, List<String> buttonsLabels, List<String> buttonsIds) {
        try {
            JSONObject additionalDataJSON;
            JSONObject customJson = new JSONObject(gcmBundle.getString("custom"));
            if (customJson.has("a") && (additionalDataJSON = customJson.getJSONObject("a")).has("actionButtons")) {
                JSONArray buttons = additionalDataJSON.getJSONArray("actionButtons");
                for (int i = 0; i < buttons.length(); ++i) {
                    JSONObject button = buttons.getJSONObject(i);
                    buttonsLabels.add(button.getString("text"));
                    buttonsIds.add(button.getString("id"));
                }
            }
            if (buttonsLabels.size() < 3) {
                buttonsLabels.add("Close");
                buttonsIds.add("__DEFAULT__");
            }
        }
        catch (JSONException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Failed to parse buttons for alert dialog.", e);
        }
    }
}

