/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.util.Log;
import android.util.TypedValue;
import com.loopj.android.http.JsonHttpResponseHandler;
import com.loopj.android.http.ResponseHandlerInterface;
import com.onesignal.AdvertisingIdProviderFallback;
import com.onesignal.AdvertisingIdProviderGPS;
import com.onesignal.AdvertisingIdentifierProvider;
import com.onesignal.OneSignalRestClient;
import com.onesignal.PushRegistrator;
import com.onesignal.PushRegistratorADM;
import com.onesignal.PushRegistratorGPS;
import com.onesignal.TrackAmazonPurchase;
import com.onesignal.TrackGooglePurchase;
import com.stericson.RootTools.internal.RootToolsInternalMethods;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.http.Header;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OneSignal {
    static final String TAG = "OneSignal";
    private static String appId;
    private static Activity appContext;
    private static LOG_LEVEL visualogLevel;
    private static LOG_LEVEL logCatLevel;
    private static String registrationId;
    private static String userId;
    private static JSONObject pendingTags;
    private static NotificationOpenedHandler notificationOpenedHandler;
    static boolean initDone;
    private static boolean foreground;
    private static IdsAvailableHandler idsAvailableHandler;
    private static long lastTrackedTime;
    private static long unSentActiveTime;
    private static String lastNotificationIdOpenned;
    private static TrackGooglePurchase trackGooglePurchase;
    private static TrackAmazonPurchase trackAmazonPurchase;
    public static final String VERSION = "010800";
    private static PushRegistrator pushRegistrator;
    private static AdvertisingIdentifierProvider mainAdIdProvider;
    private static int deviceType;
    private static LinkedList<String> notificationsReceivedStack;

    public static void init(Activity context, String googleProjectNumber, String oneSignalAppId) {
        OneSignal.init(context, googleProjectNumber, oneSignalAppId, null);
    }

    public static void init(Activity context, String googleProjectNumber, String oneSignalAppId, NotificationOpenedHandler inNnotificationOpenedHandler) {
        if (initDone) {
            return;
        }
        appId = oneSignalAppId;
        appContext = context;
        notificationOpenedHandler = inNnotificationOpenedHandler;
        lastTrackedTime = SystemClock.elapsedRealtime();
        try {
            Class.forName("com.amazon.device.iap.PurchasingListener");
            trackAmazonPurchase = new TrackAmazonPurchase((Context)appContext);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            Class.forName("com.amazon.device.messaging.ADM");
            pushRegistrator = new PushRegistratorADM();
            deviceType = 2;
        }
        catch (ClassNotFoundException e) {
            pushRegistrator = new PushRegistratorGPS();
            deviceType = 1;
        }
        String oldAppId = OneSignal.GetSavedAppId();
        if (oldAppId != null) {
            if (!oldAppId.equals(appId)) {
                OneSignal.Log(LOG_LEVEL.DEBUG, "APP ID changed, clearing user id as it is no longer valid.");
                OneSignal.saveUserId(null);
                OneSignal.SaveAppId(appId);
            }
        } else {
            OneSignal.SaveAppId(appId);
        }
        pushRegistrator.registerForPush((Context)appContext, googleProjectNumber, new PushRegistrator.RegisteredHandler(){

            @Override
            public void complete(String id) {
                OneSignal.registerUser(id);
            }
        });
        if (appContext.getIntent() != null && appContext.getIntent().getBundleExtra("data") != null) {
            OneSignal.runNotificationOpenedCallback(appContext.getIntent().getBundleExtra("data"), false, true);
        }
        if (TrackGooglePurchase.CanTrack(appContext)) {
            trackGooglePurchase = new TrackGooglePurchase(appContext);
        }
        initDone = true;
    }

    public static void setLogLevel(LOG_LEVEL inLogCatLevel, LOG_LEVEL inVisualLogLevel) {
        logCatLevel = inLogCatLevel;
        visualogLevel = inVisualLogLevel;
    }

    public static void setLogLevel(int inLogCatLevel, int inVisualLogLevel) {
        OneSignal.setLogLevel(OneSignal.getLogLevel(inLogCatLevel), OneSignal.getLogLevel(inVisualLogLevel));
    }

    private static LOG_LEVEL getLogLevel(int level) {
        switch (level) {
            case 0: {
                return LOG_LEVEL.NONE;
            }
            case 1: {
                return LOG_LEVEL.FATAL;
            }
            case 2: {
                return LOG_LEVEL.ERROR;
            }
            case 3: {
                return LOG_LEVEL.WARN;
            }
            case 4: {
                return LOG_LEVEL.INFO;
            }
            case 5: {
                return LOG_LEVEL.DEBUG;
            }
            case 6: {
                return LOG_LEVEL.VERBOSE;
            }
        }
        if (level < 0) {
            return LOG_LEVEL.NONE;
        }
        return LOG_LEVEL.VERBOSE;
    }

    public static void Log(LOG_LEVEL level, String message) {
        OneSignal.Log(level, message, null);
    }

    public static void Log(final LOG_LEVEL level, String message, Throwable throwable) {
        if (level.compareTo(logCatLevel) < 1) {
            if (level == LOG_LEVEL.VERBOSE) {
                Log.v((String)TAG, (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.DEBUG) {
                Log.d((String)TAG, (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.INFO) {
                Log.i((String)TAG, (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.WARN) {
                Log.w((String)TAG, (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.ERROR || level == LOG_LEVEL.FATAL) {
                Log.e((String)TAG, (String)message, (Throwable)throwable);
            }
        }
        if (appContext != null && level.compareTo(visualogLevel) < 1) {
            try {
                String fullMessgae = message + "\n";
                if (throwable != null) {
                    fullMessgae = fullMessgae + throwable.getMessage();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    throwable.printStackTrace(pw);
                    fullMessgae = fullMessgae + sw.toString();
                }
                final String finalFullMessage = fullMessgae;
                appContext.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        new AlertDialog.Builder((Context)appContext).setTitle((CharSequence)level.toString()).setMessage((CharSequence)finalFullMessage).show();
                    }
                });
            }
            catch (Throwable t) {
                Log.e((String)TAG, (String)"Error showing logging message.", (Throwable)t);
            }
        }
    }

    public static void onPaused() {
        long time_elapsed;
        foreground = false;
        if (trackAmazonPurchase != null) {
            trackAmazonPurchase.checkListener();
        }
        if ((time_elapsed = (long)((double)(SystemClock.elapsedRealtime() - lastTrackedTime) / 1000.0 + 0.5)) < 0L || time_elapsed > 604800L) {
            return;
        }
        long unSentActiveTime = OneSignal.GetUnsentActiveTime();
        long totalTimeActive = unSentActiveTime + time_elapsed;
        if (totalTimeActive < 30L) {
            OneSignal.SaveUnsentActiveTime(totalTimeActive);
            return;
        }
        if (OneSignal.getUserId() == null) {
            return;
        }
        JSONObject jsonBody = new JSONObject();
        try {
            jsonBody.put("app_id", (Object)appId);
            jsonBody.put("state", (Object)"ping");
            jsonBody.put("active_time", totalTimeActive);
            OneSignal.addNetType(jsonBody);
            OneSignalRestClient.post((Context)appContext, "players/" + OneSignal.getUserId() + "/on_focus", jsonBody, new JsonHttpResponseHandler(){

                @Override
                public void onFailure(int statusCode, Header[] headers, Throwable throwable, JSONObject errorResponse) {
                    OneSignal.Log(LOG_LEVEL.WARN, "HTTP sending on_focus Failed.", throwable);
                }
            });
            OneSignal.SaveUnsentActiveTime(0L);
            lastTrackedTime = SystemClock.elapsedRealtime();
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Generating on_focus:JSON Failed.", t);
        }
    }

    public static void onResumed() {
        foreground = true;
        lastTrackedTime = SystemClock.elapsedRealtime();
        if (trackGooglePurchase != null) {
            trackGooglePurchase.trackIAP();
        }
    }

    static boolean isForeground() {
        return foreground;
    }

    private static void addNetType(JSONObject jsonObj) {
        try {
            ConnectivityManager cm = (ConnectivityManager)appContext.getSystemService("connectivity");
            NetworkInfo netInfo = cm.getActiveNetworkInfo();
            int networkType = netInfo.getType();
            int netType = 1;
            if (networkType == 1 || networkType == 9) {
                netType = 0;
            }
            jsonObj.put("net_type", netType);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static int getTimeZoneOffset() {
        TimeZone timzone = Calendar.getInstance().getTimeZone();
        int offset = timzone.getRawOffset();
        if (timzone.inDaylightTime(new Date())) {
            offset += timzone.getDSTSavings();
        }
        return offset / 1000;
    }

    private static void registerUser(String id) {
        if (id != null) {
            OneSignal.SaveRegistractionId(id);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String adId;
                    JSONObject jsonBody = new JSONObject();
                    jsonBody.put("app_id", (Object)appId);
                    jsonBody.put("device_type", deviceType);
                    if (registrationId != null) {
                        jsonBody.put("identifier", (Object)registrationId);
                    }
                    if ((adId = mainAdIdProvider.getIdentifier((Context)appContext)) != null) {
                        jsonBody.put("ad_id", (Object)adId);
                    } else {
                        adId = new AdvertisingIdProviderFallback().getIdentifier((Context)appContext);
                        if (adId != null) {
                            jsonBody.put("ad_id", (Object)adId);
                        }
                    }
                    jsonBody.put("device_os", (Object)Build.VERSION.RELEASE);
                    jsonBody.put("device_model", (Object)Build.MODEL);
                    jsonBody.put("timezone", OneSignal.getTimeZoneOffset());
                    jsonBody.put("language", (Object)Locale.getDefault().getLanguage());
                    jsonBody.put("sdk", (Object)OneSignal.VERSION);
                    try {
                        jsonBody.put("game_version", (Object)("" + appContext.getPackageManager().getPackageInfo((String)appContext.getPackageName(), (int)0).versionCode));
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        // empty catch block
                    }
                    OneSignal.addNetType(jsonBody);
                    if (RootToolsInternalMethods.isRooted()) {
                        jsonBody.put("rooted", true);
                    }
                    try {
                        Field[] fields = Class.forName(appContext.getPackageName() + ".R$raw").getFields();
                        JSONArray soundList = new JSONArray();
                        TypedValue fileType = new TypedValue();
                        for (int i = 0; i < fields.length; ++i) {
                            appContext.getResources().getValue(fields[i].getInt(null), fileType, true);
                            String fileName = fileType.string.toString().toLowerCase();
                            if (!fileName.endsWith(".wav") && !fileName.endsWith(".mp3")) continue;
                            soundList.put((Object)fields[i].getName());
                        }
                        if (soundList.length() > 0) {
                            jsonBody.put("sounds", (Object)soundList);
                        }
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    String urlStr = OneSignal.getUserId() == null ? "players" : "players/" + OneSignal.getUserId() + "/on_session";
                    JsonHttpResponseHandler jsonHandler = new JsonHttpResponseHandler(){

                        @Override
                        public void onSuccess(int statusCode, Header[] headers, JSONObject response) {
                            try {
                                if (response.has("id")) {
                                    OneSignal.saveUserId(response.getString("id"));
                                    if (pendingTags != null) {
                                        OneSignal.sendTags(pendingTags);
                                        pendingTags = null;
                                    }
                                    if (idsAvailableHandler != null) {
                                        appContext.runOnUiThread(new Runnable(){

                                            @Override
                                            public void run() {
                                                idsAvailableHandler.idsAvailable(OneSignal.getUserId(), OneSignal.GetRegistrationId());
                                                idsAvailableHandler = null;
                                            }
                                        });
                                    }
                                    OneSignal.Log(LOG_LEVEL.INFO, "Device registerd with OneSignal, UserId=" + response.getString("id"));
                                }
                            }
                            catch (Throwable t) {
                                OneSignal.Log(LOG_LEVEL.ERROR, "ERROR parsing on_session or create JSON Response.", t);
                            }
                        }

                        @Override
                        public void onFailure(int statusCode, Header[] headers, Throwable throwable, JSONObject errorResponse) {
                            OneSignal.Log(LOG_LEVEL.WARN, "HTTP Create or on_session for user failed to send!", throwable);
                        }
                    };
                    OneSignalRestClient.postSync((Context)appContext, urlStr, jsonBody, jsonHandler);
                }
                catch (Throwable t) {
                    OneSignal.Log(LOG_LEVEL.ERROR, "Generating JSON create or on_session for user failed!", t);
                }
            }
        }).start();
    }

    public static void sendTag(String key, String value) {
        try {
            OneSignal.sendTags(new JSONObject().put(key, (Object)value));
        }
        catch (JSONException t) {
            t.printStackTrace();
        }
    }

    public static void sendTags(String jsonString) {
        try {
            OneSignal.sendTags(new JSONObject(jsonString));
        }
        catch (JSONException t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Generating JSONObject for sendTags failed!", t);
        }
    }

    public static void sendTags(JSONObject keyValues) {
        try {
            if (OneSignal.getUserId() == null) {
                if (pendingTags == null) {
                    pendingTags = new JSONObject();
                }
                Iterator keys = keyValues.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    pendingTags.put(key, keyValues.get(key));
                }
            } else {
                JSONObject jsonBody = new JSONObject();
                jsonBody.put("app_id", (Object)appId);
                jsonBody.put("tags", (Object)keyValues);
                OneSignal.addNetType(jsonBody);
                OneSignalRestClient.put((Context)appContext, "players/" + OneSignal.getUserId(), jsonBody, new JsonHttpResponseHandler(){

                    @Override
                    public void onFailure(int statusCode, Header[] headers, Throwable throwable, JSONObject errorResponse) {
                        OneSignal.Log(LOG_LEVEL.WARN, "HTTP sendTags failed!", throwable);
                    }
                });
            }
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Generating JSON sendTags failed!", t);
        }
    }

    public static void getTags(final GetTagsHandler getTagsHandler) {
        OneSignalRestClient.get((Context)appContext, "players/" + OneSignal.getUserId(), new JsonHttpResponseHandler(){

            @Override
            public void onSuccess(int statusCode, Header[] headers, final JSONObject response) {
                appContext.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            getTagsHandler.tagsAvailable(response.getJSONObject("tags"));
                        }
                        catch (Throwable t) {
                            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to Parse getTags.", t);
                        }
                    }
                });
            }

            @Override
            public void onFailure(int statusCode, Header[] headers, Throwable throwable, JSONObject errorResponse) {
                OneSignal.Log(LOG_LEVEL.WARN, "HTTP failed to getTags.", throwable);
            }
        });
    }

    public static void deleteTag(String key) {
        ArrayList<String> tempList = new ArrayList<String>(1);
        tempList.add(key);
        OneSignal.deleteTags(tempList);
    }

    public static void deleteTags(Collection<String> keys) {
        try {
            JSONObject jsonTags = new JSONObject();
            for (String key : keys) {
                jsonTags.put(key, (Object)"");
            }
            OneSignal.sendTags(jsonTags);
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON for deleteTags.", t);
        }
    }

    public static void deleteTags(String jsonArrayString) {
        try {
            JSONObject jsonTags = new JSONObject();
            JSONArray jsonArray = new JSONArray(jsonArrayString);
            for (int i = 0; i < jsonArray.length(); ++i) {
                jsonTags.put(jsonArray.getString(i), (Object)"");
            }
            OneSignal.sendTags(jsonTags);
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON for deleteTags.", t);
        }
    }

    public static void idsAvailable(IdsAvailableHandler inIdsAvailableHandler) {
        if (OneSignal.getUserId() != null) {
            inIdsAvailableHandler.idsAvailable(OneSignal.getUserId(), OneSignal.GetRegistrationId());
        } else {
            idsAvailableHandler = inIdsAvailableHandler;
        }
    }

    static void sendPurchases(JSONArray purchases, boolean newAsExisting, ResponseHandlerInterface httpHandler) {
        if (OneSignal.getUserId() == null) {
            return;
        }
        try {
            JSONObject jsonBody = new JSONObject();
            jsonBody.put("app_id", (Object)appId);
            if (newAsExisting) {
                jsonBody.put("existing", true);
            }
            jsonBody.put("purchases", (Object)purchases);
            if (httpHandler == null) {
                httpHandler = new JsonHttpResponseHandler();
            }
            OneSignalRestClient.post((Context)appContext, "players/" + OneSignal.getUserId() + "/on_purchase", jsonBody, httpHandler);
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON for sendPurchases.", t);
        }
    }

    private static void runNotificationOpenedCallback(final Bundle data, final boolean isActive, boolean isUiThread) {
        try {
            JSONObject customJSON = new JSONObject(data.getString("custom"));
            if (!isActive && customJSON.has("u")) {
                String url = customJSON.getString("u");
                if (!url.startsWith("http://") && !url.startsWith("https://")) {
                    url = "http://" + url;
                }
                Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                appContext.startActivity(browserIntent);
            }
            if (notificationOpenedHandler != null) {
                JSONObject additionalDataJSON = new JSONObject();
                if (customJSON.has("a")) {
                    additionalDataJSON = customJSON.getJSONObject("a");
                }
                if (data.containsKey("title")) {
                    additionalDataJSON.put("title", (Object)data.getString("title"));
                }
                if (customJSON.has("u")) {
                    additionalDataJSON.put("launchURL", (Object)customJSON.getString("u"));
                }
                if (data.containsKey("sound")) {
                    additionalDataJSON.put("sound", (Object)data.getString("sound"));
                }
                if (data.containsKey("sicon")) {
                    additionalDataJSON.put("smallIcon", (Object)data.getString("sicon"));
                }
                if (data.containsKey("licon")) {
                    additionalDataJSON.put("largeIcon", (Object)data.getString("licon"));
                }
                if (data.containsKey("bicon")) {
                    additionalDataJSON.put("bigPicture", (Object)data.getString("bicon"));
                }
                if (additionalDataJSON.equals(new JSONObject())) {
                    additionalDataJSON = null;
                }
                final JSONObject finalAdditionalDataJSON = additionalDataJSON;
                Runnable callBack = new Runnable(){

                    @Override
                    public void run() {
                        notificationOpenedHandler.notificationOpened(data.getString("alert"), finalAdditionalDataJSON, isActive);
                    }
                };
                if (isUiThread) {
                    callBack.run();
                } else {
                    appContext.runOnUiThread(callBack);
                }
            }
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to run callback from notifiation opened.", t);
        }
    }

    static void handleNotificationOpened(Bundle data) {
        OneSignal.sendNotificationOpened((Context)appContext, data);
        OneSignal.runNotificationOpenedCallback(data, true, false);
    }

    public static void handleNotificationOpened(Context inContext, Bundle data) {
        OneSignal.sendNotificationOpened(inContext, data);
        Intent launchIntent = inContext.getPackageManager().getLaunchIntentForPackage(inContext.getPackageName()).putExtra("data", data);
        launchIntent.setFlags(131072);
        inContext.startActivity(launchIntent);
        if (initDone) {
            OneSignal.runNotificationOpenedCallback(data, false, false);
        }
    }

    private static void sendNotificationOpened(Context inContext, Bundle data) {
        try {
            JSONObject customJson = new JSONObject(data.getString("custom"));
            String notificationId = customJson.getString("i");
            if (notificationId.equals(lastNotificationIdOpenned)) {
                return;
            }
            lastNotificationIdOpenned = notificationId;
            JSONObject jsonBody = new JSONObject();
            jsonBody.put("app_id", (Object)OneSignal.getSavedAppId(inContext));
            jsonBody.put("player_id", (Object)OneSignal.getSavedUserId(inContext));
            jsonBody.put("opened", true);
            OneSignalRestClient.put(inContext, "notifications/" + customJson.getString("i"), jsonBody, new JsonHttpResponseHandler(){

                @Override
                public void onFailure(int statusCode, Header[] headers, Throwable throwable, JSONObject errorResponse) {
                    OneSignal.Log(LOG_LEVEL.WARN, "HTTP sending Notification Opened Failed", throwable);
                }
            });
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON to send notification opened.", t);
        }
    }

    private static void SaveAppId(String appId) {
        SharedPreferences prefs = OneSignal.getGcmPreferences((Context)appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString("GT_APP_ID", appId);
        editor.commit();
    }

    private static String GetSavedAppId() {
        SharedPreferences prefs = OneSignal.getGcmPreferences((Context)appContext);
        return prefs.getString("GT_APP_ID", null);
    }

    private static String getSavedAppId(Context inContext) {
        SharedPreferences prefs = OneSignal.getGcmPreferences(inContext);
        return prefs.getString("GT_APP_ID", null);
    }

    private static String getSavedUserId(Context inContext) {
        SharedPreferences prefs = OneSignal.getGcmPreferences(inContext);
        return prefs.getString("GT_PLAYER_ID", null);
    }

    static String getUserId() {
        if (userId == null) {
            SharedPreferences prefs = OneSignal.getGcmPreferences((Context)appContext);
            userId = prefs.getString("GT_PLAYER_ID", null);
        }
        return userId;
    }

    private static void saveUserId(String inUserId) {
        userId = inUserId;
        SharedPreferences prefs = OneSignal.getGcmPreferences((Context)appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString("GT_PLAYER_ID", userId);
        editor.commit();
    }

    static String GetRegistrationId() {
        if (registrationId == null) {
            SharedPreferences prefs = OneSignal.getGcmPreferences((Context)appContext);
            registrationId = prefs.getString("GT_REGISTRATION_ID", null);
        }
        return registrationId;
    }

    public static void enableVibrate(boolean enable) {
        SharedPreferences prefs = OneSignal.getGcmPreferences((Context)appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putBoolean("GT_VIBRATE_ENABLED", enable);
        editor.commit();
    }

    static boolean getVibrate(Context appContext) {
        SharedPreferences prefs = OneSignal.getGcmPreferences(appContext);
        return prefs.getBoolean("GT_VIBRATE_ENABLED", true);
    }

    public static void enableSound(boolean enable) {
        SharedPreferences prefs = OneSignal.getGcmPreferences((Context)appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putBoolean("GT_SOUND_ENABLED", enable);
        editor.commit();
    }

    static boolean getSoundEnabled(Context appContext) {
        SharedPreferences prefs = OneSignal.getGcmPreferences(appContext);
        return prefs.getBoolean("GT_SOUND_ENABLED", true);
    }

    private static void SaveRegistractionId(String inRegistrationId) {
        registrationId = inRegistrationId;
        SharedPreferences prefs = OneSignal.getGcmPreferences((Context)appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString("GT_REGISTRATION_ID", registrationId);
        editor.commit();
    }

    private static long GetUnsentActiveTime() {
        if (unSentActiveTime == -1L) {
            SharedPreferences prefs = OneSignal.getGcmPreferences((Context)appContext);
            unSentActiveTime = prefs.getLong("GT_UNSENT_ACTIVE_TIME", 0L);
        }
        return unSentActiveTime;
    }

    private static void SaveUnsentActiveTime(long time) {
        unSentActiveTime = time;
        SharedPreferences prefs = OneSignal.getGcmPreferences((Context)appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putLong("GT_UNSENT_ACTIVE_TIME", time);
        editor.commit();
    }

    static SharedPreferences getGcmPreferences(Context context) {
        return context.getSharedPreferences(OneSignal.class.getSimpleName(), 0);
    }

    private static void GetNotificationsReceived(Context context) {
        if (notificationsReceivedStack == null) {
            notificationsReceivedStack = new LinkedList();
            SharedPreferences prefs = OneSignal.getGcmPreferences(context);
            String jsonListStr = prefs.getString("GT_RECEIVED_NOTIFICATION_LIST", null);
            if (jsonListStr != null) {
                try {
                    JSONArray notificationsReceivedList = new JSONArray(jsonListStr);
                    for (int i = 0; i < notificationsReceivedList.length(); ++i) {
                        notificationsReceivedStack.push(notificationsReceivedList.getString(i));
                    }
                }
                catch (Throwable t) {
                    OneSignal.Log(LOG_LEVEL.ERROR, "Failed to get notification received list.", t);
                }
            }
        }
    }

    private static void AddNotificationIdToList(String id, Context context) {
        OneSignal.GetNotificationsReceived(context);
        if (notificationsReceivedStack == null) {
            return;
        }
        if (notificationsReceivedStack.size() >= 10) {
            notificationsReceivedStack.removeLast();
        }
        notificationsReceivedStack.addFirst(id);
        JSONArray jsonArray = new JSONArray();
        for (int i = notificationsReceivedStack.size() - 1; i > -1; --i) {
            String notificationId = notificationsReceivedStack.get(i);
            if (notificationId == null) continue;
            jsonArray.put((Object)notificationsReceivedStack.get(i));
        }
        SharedPreferences prefs = OneSignal.getGcmPreferences(context);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString("GT_RECEIVED_NOTIFICATION_LIST", jsonArray.toString());
        editor.commit();
    }

    static boolean isDuplicateNotification(String id, Context context) {
        OneSignal.GetNotificationsReceived(context);
        if (notificationsReceivedStack == null || id == null || "".equals(id)) {
            return false;
        }
        if (notificationsReceivedStack.contains(id)) {
            OneSignal.Log(LOG_LEVEL.DEBUG, "Duplicate GCM message received, skipping processing. " + id);
            return true;
        }
        OneSignal.AddNotificationIdToList(id, context);
        return false;
    }

    static boolean isValidAndNotDuplicated(Context context, Bundle bundle) {
        if (bundle.isEmpty()) {
            return false;
        }
        try {
            if (bundle.containsKey("custom")) {
                JSONObject customJSON = new JSONObject(bundle.getString("custom"));
                if (customJSON.has("i")) {
                    return !OneSignal.isDuplicateNotification(customJSON.getString("i"), context);
                }
                OneSignal.Log(LOG_LEVEL.DEBUG, "Not a OneSignal formated GCM message. No 'i' field in custom.");
            } else {
                OneSignal.Log(LOG_LEVEL.DEBUG, "Not a OneSignal formated GCM message. No 'custom' field in the bundle.");
            }
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.INFO, "Could not parse bundle for duplicate.", t);
        }
        return false;
    }

    static {
        visualogLevel = LOG_LEVEL.NONE;
        logCatLevel = LOG_LEVEL.INFO;
        userId = null;
        foreground = true;
        unSentActiveTime = -1L;
        mainAdIdProvider = new AdvertisingIdProviderGPS();
    }

    public static interface GetTagsHandler {
        public void tagsAvailable(JSONObject var1);
    }

    public static interface IdsAvailableHandler {
        public void idsAvailable(String var1, String var2);
    }

    public static interface NotificationOpenedHandler {
        public void notificationOpened(String var1, JSONObject var2, boolean var3);
    }

    public static enum LOG_LEVEL {
        NONE,
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        VERBOSE;

    }
}

