/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import android.util.TypedValue;
import com.loopj.android.http.JsonHttpResponseHandler;
import com.loopj.android.http.ResponseHandlerInterface;
import com.onesignal.AdvertisingIdProviderFallback;
import com.onesignal.AdvertisingIdProviderGPS;
import com.onesignal.AdvertisingIdentifierProvider;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.OneSignalRestClient;
import com.onesignal.PushRegistrator;
import com.onesignal.PushRegistratorADM;
import com.onesignal.PushRegistratorGPS;
import com.onesignal.TrackAmazonPurchase;
import com.onesignal.TrackGooglePurchase;
import com.stericson.RootTools.internal.RootToolsInternalMethods;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.http.Header;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OneSignal {
    static final String TAG = "OneSignal";
    private static String appId;
    static Activity appContext;
    private static LOG_LEVEL visualLogLevel;
    private static LOG_LEVEL logCatLevel;
    private static String registrationId;
    private static String userId;
    private static JSONObject pendingTags;
    private static int savedSubscription;
    private static int syncedSubscription;
    private static int currentSubscription;
    private static final int UNSUBSCRIBE_VALUE = -2;
    private static NotificationOpenedHandler notificationOpenedHandler;
    static boolean initDone;
    private static boolean foreground;
    private static IdsAvailableHandler idsAvailableHandler;
    private static long lastTrackedTime;
    private static long unSentActiveTime;
    private static TrackGooglePurchase trackGooglePurchase;
    private static TrackAmazonPurchase trackAmazonPurchase;
    public static final String VERSION = "011005";
    private static PushRegistrator pushRegistrator;
    private static AdvertisingIdentifierProvider mainAdIdProvider;
    private static int deviceType;
    public static String sdkType;
    private static JSONObject nextInitAdditionalDataJSON;
    private static String nextInitMessage;

    public static void init(Activity context, String googleProjectNumber, String oneSignalAppId) {
        OneSignal.init(context, googleProjectNumber, oneSignalAppId, null);
    }

    public static void init(Activity context, String googleProjectNumber, String oneSignalAppId, NotificationOpenedHandler inNotificationOpenedHandler) {
        String oneSignalDataJsonString;
        try {
            Class.forName("com.amazon.device.messaging.ADM");
            pushRegistrator = new PushRegistratorADM();
            deviceType = 2;
        }
        catch (ClassNotFoundException e) {
            pushRegistrator = new PushRegistratorGPS();
            deviceType = 1;
        }
        try {
            UUID.fromString(oneSignalAppId);
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.FATAL, "OneSignal AppId format is invalid.\nExample: 'b2f7f966-d8cc-11e4-bed1-df8f05be55ba'\n", t, (Context)context);
            return;
        }
        if ("b2f7f966-d8cc-11e4-bed1-df8f05be55ba".equals(oneSignalAppId) || "5eb5a37e-b458-11e3-ac11-000c2940e62c".equals(oneSignalAppId)) {
            OneSignal.Log(LOG_LEVEL.WARN, "OneSignal Example AppID detected, please update to your app's id found on OneSignal.com");
        }
        if (deviceType == 1) {
            try {
                Double.parseDouble(googleProjectNumber);
                if (googleProjectNumber.length() < 8 || googleProjectNumber.length() > 16) {
                    throw new IllegalArgumentException("Google Project number (Sender_ID) should be a 10 to 14 digit number in length.");
                }
            }
            catch (Throwable t) {
                OneSignal.Log(LOG_LEVEL.FATAL, "Google Project number (Sender_ID) format is invalid. Please use the 10 to 14 digit number found in the Google Developer Console for your project.\nExample: '703322744261'\n", t, (Context)context);
                currentSubscription = -6;
            }
            try {
                Class.forName("com.google.android.gms.gcm.GoogleCloudMessaging");
            }
            catch (ClassNotFoundException e) {
                OneSignal.Log(LOG_LEVEL.FATAL, "The GCM Google Play services client library was not found. Please make sure to include it in your project.", e, (Context)context);
                currentSubscription = -4;
            }
        }
        try {
            Class.forName("android.support.v4.view.MenuCompat");
            try {
                Class.forName("android.support.v4.content.WakefulBroadcastReceiver");
            }
            catch (ClassNotFoundException e) {
                OneSignal.Log(LOG_LEVEL.FATAL, "The included Android Support Library v4 is to old. Please update your project's android-support-v4.jar to the latest revision.", e, (Context)context);
                currentSubscription = -5;
            }
        }
        catch (ClassNotFoundException e) {
            OneSignal.Log(LOG_LEVEL.FATAL, "Could not find the Android Support Library v4. Please make sure android-support-v4.jar has been correctly added to your project.", e, (Context)context);
            currentSubscription = -3;
        }
        if (initDone) {
            if (context != null) {
                appContext = context;
            }
            if (inNotificationOpenedHandler != null) {
                notificationOpenedHandler = inNotificationOpenedHandler;
            }
            OneSignal.onResumed();
            if (nextInitMessage != null && notificationOpenedHandler != null) {
                OneSignal.fireNotificationOpenedHandler(nextInitMessage, nextInitAdditionalDataJSON, false);
                nextInitMessage = null;
                nextInitAdditionalDataJSON = null;
            }
            return;
        }
        savedSubscription = OneSignal.getSubscription((Context)context);
        syncedSubscription = OneSignal.getSyncedSubscription((Context)context);
        if (currentSubscription > 0 && savedSubscription > -3) {
            currentSubscription = savedSubscription;
        }
        appId = oneSignalAppId;
        appContext = context;
        notificationOpenedHandler = inNotificationOpenedHandler;
        lastTrackedTime = SystemClock.elapsedRealtime();
        try {
            Class.forName("com.amazon.device.iap.PurchasingListener");
            trackAmazonPurchase = new TrackAmazonPurchase((Context)appContext);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        String oldAppId = OneSignal.getSavedAppId();
        if (oldAppId != null) {
            if (!oldAppId.equals(appId)) {
                OneSignal.Log(LOG_LEVEL.DEBUG, "APP ID changed, clearing user id as it is no longer valid.");
                OneSignal.saveUserId(null);
                OneSignal.SaveAppId(appId);
            }
        } else {
            OneSignal.SaveAppId(appId);
        }
        pushRegistrator.registerForPush((Context)appContext, googleProjectNumber, new PushRegistrator.RegisteredHandler(){
            private boolean firstRun = true;

            @Override
            public void complete(String id) {
                if (this.firstRun) {
                    OneSignal.registerUser(id);
                } else {
                    OneSignal.updateRegistrationId(id);
                }
                this.firstRun = false;
            }
        });
        if (appContext.getIntent() != null && (oneSignalDataJsonString = appContext.getIntent().getStringExtra("onesignal_data")) != null) {
            try {
                JSONArray dataArray = new JSONArray(oneSignalDataJsonString);
                OneSignal.openWebURLFromNotification(dataArray);
                OneSignal.runNotificationOpenedCallback(dataArray, false);
            }
            catch (JSONException e) {
                OneSignal.Log(LOG_LEVEL.ERROR, "Failed to process onesignal_data intent on app cold start.");
            }
        }
        if (TrackGooglePurchase.CanTrack(appContext)) {
            trackGooglePurchase = new TrackGooglePurchase(appContext);
        }
        initDone = true;
    }

    private static void updateRegistrationId(String id) {
        String orgRegId = OneSignal.GetRegistrationId();
        if (id != null && !id.equals(orgRegId)) {
            OneSignal.SaveRegistrationId(id);
            OneSignal.fireIdsAvailableCallback();
            try {
                JSONObject jsonBody = OneSignal.playerUpdateBaseJSON();
                jsonBody.put("identifier", (Object)registrationId);
                OneSignal.postPlayerUpdate(jsonBody);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    public static void setLogLevel(LOG_LEVEL inLogCatLevel, LOG_LEVEL inVisualLogLevel) {
        logCatLevel = inLogCatLevel;
        visualLogLevel = inVisualLogLevel;
    }

    public static void setLogLevel(int inLogCatLevel, int inVisualLogLevel) {
        OneSignal.setLogLevel(OneSignal.getLogLevel(inLogCatLevel), OneSignal.getLogLevel(inVisualLogLevel));
    }

    private static LOG_LEVEL getLogLevel(int level) {
        switch (level) {
            case 0: {
                return LOG_LEVEL.NONE;
            }
            case 1: {
                return LOG_LEVEL.FATAL;
            }
            case 2: {
                return LOG_LEVEL.ERROR;
            }
            case 3: {
                return LOG_LEVEL.WARN;
            }
            case 4: {
                return LOG_LEVEL.INFO;
            }
            case 5: {
                return LOG_LEVEL.DEBUG;
            }
            case 6: {
                return LOG_LEVEL.VERBOSE;
            }
        }
        if (level < 0) {
            return LOG_LEVEL.NONE;
        }
        return LOG_LEVEL.VERBOSE;
    }

    private static boolean atLogLevel(LOG_LEVEL level) {
        return level.compareTo(visualLogLevel) < 1 || level.compareTo(logCatLevel) < 1;
    }

    public static void Log(LOG_LEVEL level, String message) {
        OneSignal.Log(level, message, null, (Context)appContext);
    }

    public static void Log(LOG_LEVEL level, String message, Throwable throwable) {
        OneSignal.Log(level, message, throwable, (Context)appContext);
    }

    public static void Log(final LOG_LEVEL level, String message, Throwable throwable, final Context context) {
        if (level.compareTo(logCatLevel) < 1) {
            if (level == LOG_LEVEL.VERBOSE) {
                Log.v((String)TAG, (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.DEBUG) {
                Log.d((String)TAG, (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.INFO) {
                Log.i((String)TAG, (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.WARN) {
                Log.w((String)TAG, (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.ERROR || level == LOG_LEVEL.FATAL) {
                Log.e((String)TAG, (String)message, (Throwable)throwable);
            }
        }
        if (context != null && level.compareTo(visualLogLevel) < 1) {
            try {
                String fullMessage = message + "\n";
                if (throwable != null) {
                    fullMessage = fullMessage + throwable.getMessage();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    throwable.printStackTrace(pw);
                    fullMessage = fullMessage + sw.toString();
                }
                final String finalFullMessage = fullMessage;
                ((Activity)context).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        new AlertDialog.Builder(context).setTitle((CharSequence)level.toString()).setMessage((CharSequence)finalFullMessage).show();
                    }
                });
            }
            catch (Throwable t) {
                Log.e((String)TAG, (String)"Error showing logging message.", (Throwable)t);
            }
        }
    }

    private static void logHttpError(String errorString, int statusCode, Throwable throwable, JSONObject errorResponse) {
        String jsonError = "";
        if (errorResponse != null && OneSignal.atLogLevel(LOG_LEVEL.INFO)) {
            jsonError = "\n" + errorResponse.toString() + "\n";
        }
        OneSignal.Log(LOG_LEVEL.WARN, "HTTP code: " + statusCode + " " + errorString + jsonError, throwable);
    }

    public static void onPaused() {
        foreground = false;
        if (trackAmazonPurchase != null) {
            trackAmazonPurchase.checkListener();
        }
        long time_elapsed = (long)((double)(SystemClock.elapsedRealtime() - lastTrackedTime) / 1000.0 + 0.5);
        lastTrackedTime = SystemClock.elapsedRealtime();
        if (time_elapsed < 0L || time_elapsed > 604800L) {
            return;
        }
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Android Context not found, please call OneSignal.init when your app starts.");
            return;
        }
        long unSentActiveTime = OneSignal.GetUnsentActiveTime();
        long totalTimeActive = unSentActiveTime + time_elapsed;
        if (totalTimeActive < 30L) {
            OneSignal.SaveUnsentActiveTime(totalTimeActive);
            return;
        }
        if (OneSignal.getUserId() == null) {
            return;
        }
        JSONObject jsonBody = new JSONObject();
        try {
            jsonBody.put("app_id", (Object)appId);
            jsonBody.put("state", (Object)"ping");
            jsonBody.put("active_time", totalTimeActive);
            OneSignal.addNetType(jsonBody);
            OneSignalRestClient.post((Context)appContext, "players/" + OneSignal.getUserId() + "/on_focus", jsonBody, new JsonHttpResponseHandler(){

                @Override
                public void onFailure(int statusCode, Header[] headers, Throwable throwable, JSONObject errorResponse) {
                    OneSignal.logHttpError("sending on_focus Failed", statusCode, throwable, errorResponse);
                }
            });
            OneSignal.SaveUnsentActiveTime(0L);
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Generating on_focus:JSON Failed.", t);
        }
    }

    public static void onResumed() {
        foreground = true;
        lastTrackedTime = SystemClock.elapsedRealtime();
        if (trackGooglePurchase != null) {
            trackGooglePurchase.trackIAP();
        }
    }

    static boolean isForeground() {
        return foreground;
    }

    private static void addNetType(JSONObject jsonObj) {
        try {
            ConnectivityManager cm = (ConnectivityManager)appContext.getSystemService("connectivity");
            NetworkInfo netInfo = cm.getActiveNetworkInfo();
            int networkType = netInfo.getType();
            int netType = 1;
            if (networkType == 1 || networkType == 9) {
                netType = 0;
            }
            jsonObj.put("net_type", netType);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static int getTimeZoneOffset() {
        TimeZone timzone = Calendar.getInstance().getTimeZone();
        int offset = timzone.getRawOffset();
        if (timzone.inDaylightTime(new Date())) {
            offset += timzone.getDSTSavings();
        }
        return offset / 1000;
    }

    private static void registerUser(String id) {
        if (id != null) {
            OneSignal.SaveRegistrationId(id);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String adId;
                    String packageName = appContext.getPackageName();
                    PackageManager packageManager = appContext.getPackageManager();
                    final JSONObject jsonBody = new JSONObject();
                    jsonBody.put("app_id", (Object)appId);
                    if (registrationId != null) {
                        jsonBody.put("identifier", (Object)registrationId);
                    }
                    if ((adId = mainAdIdProvider.getIdentifier((Context)appContext)) != null) {
                        jsonBody.put("ad_id", (Object)adId);
                    } else {
                        adId = new AdvertisingIdProviderFallback().getIdentifier((Context)appContext);
                        if (adId != null) {
                            jsonBody.put("ad_id", (Object)adId);
                        }
                    }
                    jsonBody.put("device_os", (Object)Build.VERSION.RELEASE);
                    jsonBody.put("timezone", OneSignal.getTimeZoneOffset());
                    jsonBody.put("language", (Object)Locale.getDefault().getLanguage());
                    jsonBody.put("sdk", (Object)OneSignal.VERSION);
                    if (OneSignal.getUserId() == null) {
                        jsonBody.put("android_package", (Object)packageName);
                        jsonBody.put("sdk_type", (Object)sdkType);
                    }
                    jsonBody.put("device_model", (Object)Build.MODEL);
                    jsonBody.put("device_type", deviceType);
                    if (syncedSubscription != currentSubscription) {
                        jsonBody.put("notification_types", currentSubscription);
                    }
                    try {
                        jsonBody.put("game_version", (Object)("" + packageManager.getPackageInfo((String)packageName, (int)0).versionCode));
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        // empty catch block
                    }
                    List packList = packageManager.getInstalledPackages(0);
                    int count = -1;
                    for (int i = 0; i < packList.size(); ++i) {
                        count += (((PackageInfo)packList.get((int)i)).applicationInfo.flags & 1) == 0 ? 1 : 0;
                    }
                    jsonBody.put("pkgc", count);
                    OneSignal.addNetType(jsonBody);
                    if (RootToolsInternalMethods.isRooted()) {
                        jsonBody.put("rooted", true);
                    }
                    try {
                        Field[] fields = Class.forName(packageName + ".R$raw").getFields();
                        JSONArray soundList = new JSONArray();
                        TypedValue fileType = new TypedValue();
                        for (int i = 0; i < fields.length; ++i) {
                            appContext.getResources().getValue(fields[i].getInt(null), fileType, true);
                            String fileName = fileType.string.toString().toLowerCase();
                            if (!fileName.endsWith(".wav") && !fileName.endsWith(".mp3")) continue;
                            soundList.put((Object)fields[i].getName());
                        }
                        if (soundList.length() > 0) {
                            jsonBody.put("sounds", (Object)soundList);
                        }
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    String urlStr = OneSignal.getUserId() == null ? "players" : "players/" + OneSignal.getUserId() + "/on_session";
                    JsonHttpResponseHandler jsonHandler = new JsonHttpResponseHandler(){

                        @Override
                        public void onSuccess(int statusCode, Header[] headers, JSONObject response) {
                            try {
                                try {
                                    if (jsonBody.has("notification_types")) {
                                        OneSignal.saveSyncedSubscription(jsonBody.getInt("notification_types"));
                                    }
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                }
                                if (response.has("id")) {
                                    OneSignal.saveUserId(response.getString("id"));
                                    OneSignal.sendPendingIdData();
                                    OneSignal.fireIdsAvailableCallback();
                                    OneSignal.Log(LOG_LEVEL.INFO, "Device registered with OneSignal, UserId = " + response.getString("id"));
                                } else {
                                    OneSignal.Log(LOG_LEVEL.INFO, "Device session registered with OneSignal, UserId = " + OneSignal.getUserId());
                                }
                            }
                            catch (Throwable t) {
                                OneSignal.Log(LOG_LEVEL.ERROR, "ERROR parsing on_session or create JSON Response.", t);
                            }
                        }

                        @Override
                        public void onFailure(int statusCode, Header[] headers, Throwable throwable, JSONObject errorResponse) {
                            OneSignal.logHttpError("Create or on_session for user failed to send!", statusCode, throwable, errorResponse);
                        }
                    };
                    OneSignalRestClient.postSync((Context)appContext, urlStr, jsonBody, jsonHandler);
                }
                catch (Throwable t) {
                    OneSignal.Log(LOG_LEVEL.ERROR, "Generating JSON create or on_session for user failed!", t);
                }
            }
        }).start();
    }

    private static void sendPendingIdData() {
        if (pendingTags != null || currentSubscription != 1) {
            try {
                JSONObject json = OneSignal.playerUpdateBaseJSON();
                if (pendingTags != null) {
                    json.put("tags", (Object)pendingTags);
                    pendingTags = null;
                }
                if (currentSubscription != 1) {
                    json.put("notification_types", currentSubscription);
                }
                OneSignal.postPlayerUpdate(json);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public static void sendTag(String key, String value) {
        try {
            OneSignal.sendTags(new JSONObject().put(key, (Object)value));
        }
        catch (JSONException t) {
            t.printStackTrace();
        }
    }

    public static void sendTags(String jsonString) {
        try {
            OneSignal.sendTags(new JSONObject(jsonString));
        }
        catch (JSONException t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Generating JSONObject for sendTags failed!", t);
        }
    }

    public static void sendTags(JSONObject keyValues) {
        try {
            if (OneSignal.getUserId() == null) {
                if (pendingTags == null) {
                    pendingTags = new JSONObject();
                }
                Iterator keys = keyValues.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    pendingTags.put(key, keyValues.get(key));
                }
            } else {
                JSONObject jsonBody = OneSignal.playerUpdateBaseJSON();
                if (keyValues != null) {
                    jsonBody.put("tags", (Object)keyValues);
                }
                OneSignal.postPlayerUpdate(jsonBody);
            }
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Generating JSON sendTags failed!", t);
        }
    }

    private static JSONObject playerUpdateBaseJSON() {
        JSONObject jsonBody = new JSONObject();
        try {
            jsonBody.put("app_id", (Object)appId);
            OneSignal.addNetType(jsonBody);
        }
        catch (JSONException e) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Generating player update base JSON failed!", e);
        }
        return jsonBody;
    }

    private static void postPlayerUpdate(final JSONObject postBody) {
        try {
            OneSignalRestClient.put((Context)appContext, "players/" + OneSignal.getUserId(), postBody, new JsonHttpResponseHandler(){

                @Override
                public void onFailure(int statusCode, Header[] headers, Throwable throwable, JSONObject errorResponse) {
                    OneSignal.logHttpError("player update failed!", statusCode, throwable, errorResponse);
                }

                @Override
                public void onSuccess(int statusCode, Header[] headers, JSONObject response) {
                    try {
                        if (postBody.has("notification_types")) {
                            OneSignal.saveSyncedSubscription(postBody.getInt("notification_types"));
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (UnsupportedEncodingException e) {
            OneSignal.Log(LOG_LEVEL.ERROR, "HTTP player update encoding exception!", e);
        }
    }

    public static void postNotification(String json, PostNotificationResponseHandler handler) {
        try {
            OneSignal.postNotification(new JSONObject(json), handler);
        }
        catch (JSONException e) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Invalid postNotification JSON format: " + json);
        }
    }

    public static void postNotification(JSONObject json, final PostNotificationResponseHandler handler) {
        block8: {
            try {
                json.put("app_id", (Object)OneSignal.getSavedAppId());
                OneSignalRestClient.post((Context)appContext, "notifications/", json, new JsonHttpResponseHandler(){

                    @Override
                    public void onSuccess(int statusCode, Header[] headers, JSONObject response) {
                        OneSignal.Log(LOG_LEVEL.DEBUG, "HTTP create notification success: " + (response != null ? response : "null"));
                        if (handler != null) {
                            handler.onSuccess(response);
                        }
                    }

                    @Override
                    public void onFailure(int statusCode, Header[] headers, Throwable throwable, JSONObject response) {
                        block4: {
                            OneSignal.logHttpError("create notification failed", statusCode, throwable, response);
                            if (statusCode == 0) {
                                try {
                                    response = new JSONObject("{'error': 'HTTP no response error'}");
                                }
                                catch (JSONException e1) {
                                    if (!OneSignal.atLogLevel(LOG_LEVEL.INFO)) break block4;
                                    e1.printStackTrace();
                                }
                            }
                        }
                        if (handler != null) {
                            handler.onFailure(response);
                        }
                    }
                });
            }
            catch (UnsupportedEncodingException e) {
                OneSignal.Log(LOG_LEVEL.ERROR, "HTTP create notification encoding exception!", e);
                if (handler != null) {
                    try {
                        handler.onFailure(new JSONObject("{'error': 'HTTP create notification encoding exception!'}"));
                    }
                    catch (JSONException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            catch (JSONException e) {
                OneSignal.Log(LOG_LEVEL.ERROR, "HTTP create notification json exception!", e);
                if (handler == null) break block8;
                try {
                    handler.onFailure(new JSONObject("{'error': 'HTTP create notification json exception!'}"));
                }
                catch (JSONException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static void getTags(final GetTagsHandler getTagsHandler) {
        OneSignalRestClient.get((Context)appContext, "players/" + OneSignal.getUserId(), new JsonHttpResponseHandler(){

            @Override
            public void onSuccess(int statusCode, Header[] headers, final JSONObject response) {
                appContext.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            getTagsHandler.tagsAvailable(response.getJSONObject("tags"));
                        }
                        catch (Throwable t) {
                            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to Parse getTags.", t);
                        }
                    }
                });
            }

            @Override
            public void onFailure(int statusCode, Header[] headers, Throwable throwable, JSONObject errorResponse) {
                OneSignal.logHttpError("failed to getTags.", statusCode, throwable, errorResponse);
            }
        });
    }

    public static void deleteTag(String key) {
        ArrayList<String> tempList = new ArrayList<String>(1);
        tempList.add(key);
        OneSignal.deleteTags(tempList);
    }

    public static void deleteTags(Collection<String> keys) {
        try {
            JSONObject jsonTags = new JSONObject();
            for (String key : keys) {
                jsonTags.put(key, (Object)"");
            }
            OneSignal.sendTags(jsonTags);
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON for deleteTags.", t);
        }
    }

    public static void deleteTags(String jsonArrayString) {
        try {
            JSONObject jsonTags = new JSONObject();
            JSONArray jsonArray = new JSONArray(jsonArrayString);
            for (int i = 0; i < jsonArray.length(); ++i) {
                jsonTags.put(jsonArray.getString(i), (Object)"");
            }
            OneSignal.sendTags(jsonTags);
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON for deleteTags.", t);
        }
    }

    public static void idsAvailable(IdsAvailableHandler inIdsAvailableHandler) {
        idsAvailableHandler = inIdsAvailableHandler;
        if (OneSignal.getUserId() != null) {
            OneSignal.internalFireIdsAvailableCallback();
        }
    }

    private static void fireIdsAvailableCallback() {
        if (idsAvailableHandler != null) {
            appContext.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    OneSignal.internalFireIdsAvailableCallback();
                }
            });
        }
    }

    private static void internalFireIdsAvailableCallback() {
        String userId;
        String regId = OneSignal.GetRegistrationId();
        if (currentSubscription < 1) {
            regId = null;
        }
        if ((userId = OneSignal.getUserId()) == null) {
            return;
        }
        idsAvailableHandler.idsAvailable(userId, regId);
        if (regId != null) {
            idsAvailableHandler = null;
        }
    }

    static void sendPurchases(JSONArray purchases, boolean newAsExisting, ResponseHandlerInterface httpHandler) {
        if (OneSignal.getUserId() == null) {
            return;
        }
        try {
            JSONObject jsonBody = new JSONObject();
            jsonBody.put("app_id", (Object)appId);
            if (newAsExisting) {
                jsonBody.put("existing", true);
            }
            jsonBody.put("purchases", (Object)purchases);
            if (httpHandler == null) {
                httpHandler = new JsonHttpResponseHandler();
            }
            OneSignalRestClient.post((Context)appContext, "players/" + OneSignal.getUserId() + "/on_purchase", jsonBody, httpHandler);
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON for sendPurchases.", t);
        }
    }

    private static void openWebURLFromNotification(JSONArray dataArray) {
        int jsonArraySize = dataArray.length();
        for (int i = 0; i < jsonArraySize; ++i) {
            try {
                JSONObject data = dataArray.getJSONObject(i);
                if (!data.has("custom")) {
                    return;
                }
                JSONObject customJSON = new JSONObject(data.getString("custom"));
                if (!customJSON.has("u")) continue;
                String url = customJSON.getString("u");
                if (!url.startsWith("http://") && !url.startsWith("https://")) {
                    url = "http://" + url;
                }
                Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                appContext.startActivity(browserIntent);
                continue;
            }
            catch (Throwable t) {
                OneSignal.Log(LOG_LEVEL.ERROR, "Error parsing JSON item " + i + "/" + jsonArraySize + " for launching a web URL.", t);
            }
        }
    }

    private static void runNotificationOpenedCallback(JSONArray dataArray, boolean isActive) {
        if (notificationOpenedHandler == null) {
            return;
        }
        int jsonArraySize = dataArray.length();
        JSONObject completeAdditionalData = null;
        String firstMessage = null;
        for (int i = 0; i < jsonArraySize; ++i) {
            try {
                JSONObject data = dataArray.getJSONObject(i);
                JSONObject additionalDataJSON = null;
                if (data.has("custom")) {
                    JSONObject customJSON = new JSONObject(data.getString("custom"));
                    additionalDataJSON = new JSONObject();
                    if (customJSON.has("a")) {
                        additionalDataJSON = customJSON.getJSONObject("a");
                    }
                    if (data.has("title")) {
                        additionalDataJSON.put("title", (Object)data.getString("title"));
                    }
                    if (customJSON.has("u")) {
                        additionalDataJSON.put("launchURL", (Object)customJSON.getString("u"));
                    }
                    if (data.has("sound")) {
                        additionalDataJSON.put("sound", (Object)data.getString("sound"));
                    }
                    if (data.has("sicon")) {
                        additionalDataJSON.put("smallIcon", (Object)data.getString("sicon"));
                    }
                    if (data.has("licon")) {
                        additionalDataJSON.put("largeIcon", (Object)data.getString("licon"));
                    }
                    if (data.has("bicon")) {
                        additionalDataJSON.put("bigPicture", (Object)data.getString("bicon"));
                    }
                    if (additionalDataJSON.equals(new JSONObject())) {
                        additionalDataJSON = null;
                    }
                }
                if (firstMessage == null) {
                    completeAdditionalData = additionalDataJSON;
                    firstMessage = data.getString("alert");
                    continue;
                }
                if (completeAdditionalData == null) {
                    completeAdditionalData = new JSONObject();
                }
                if (!completeAdditionalData.has("stacked_notifications")) {
                    completeAdditionalData.put("stacked_notifications", (Object)new JSONArray());
                }
                additionalDataJSON.put("message", (Object)data.getString("alert"));
                completeAdditionalData.getJSONArray("stacked_notifications").put((Object)additionalDataJSON);
                continue;
            }
            catch (Throwable t) {
                OneSignal.Log(LOG_LEVEL.ERROR, "Error parsing JSON item " + i + "/" + jsonArraySize + " for callback.", t);
            }
        }
        if (appContext.isFinishing() && (notificationOpenedHandler.getClass().isAnnotationPresent(TiedToCurrentActivity.class) || notificationOpenedHandler instanceof Activity)) {
            nextInitAdditionalDataJSON = completeAdditionalData;
            nextInitMessage = firstMessage;
            return;
        }
        OneSignal.fireNotificationOpenedHandler(firstMessage, completeAdditionalData, isActive);
    }

    private static void fireNotificationOpenedHandler(final String message, final JSONObject additionalDataJSON, final boolean isActive) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            notificationOpenedHandler.notificationOpened(message, additionalDataJSON, isActive);
        } else {
            appContext.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    notificationOpenedHandler.notificationOpened(message, additionalDataJSON, isActive);
                }
            });
        }
    }

    static void handleNotificationOpened(JSONArray data) {
        OneSignal.sendNotificationOpened((Context)appContext, data);
        OneSignal.runNotificationOpenedCallback(data, true);
    }

    public static void handleNotificationOpened(Context inContext, JSONArray data) {
        Intent launchIntent;
        OneSignal.sendNotificationOpened(inContext, data);
        PackageManager packageManager = inContext.getPackageManager();
        boolean isCustom = false;
        Intent intent = new Intent().setAction("com.onesignal.NotificationOpened.RECEIVE").setPackage(inContext.getPackageName());
        List resolveInfo = packageManager.queryBroadcastReceivers(intent, 32);
        if (resolveInfo.size() > 0) {
            intent.putExtra("onesignal_data", data.toString());
            inContext.sendBroadcast(intent);
            isCustom = true;
        }
        if ((resolveInfo = packageManager.queryIntentActivities(intent, 65536)).size() > 0) {
            isCustom = true;
            if (!isCustom) {
                intent.putExtra("onesignal_data", data.toString());
            }
            intent.setFlags(131072);
            inContext.startActivity(intent);
        }
        if (!isCustom && (launchIntent = inContext.getPackageManager().getLaunchIntentForPackage(inContext.getPackageName())) != null) {
            launchIntent.putExtra("onesignal_data", data.toString()).setFlags(131072);
            inContext.startActivity(launchIntent);
        }
        if (initDone) {
            OneSignal.openWebURLFromNotification(data);
            OneSignal.runNotificationOpenedCallback(data, false);
        }
    }

    private static void sendNotificationOpened(Context inContext, JSONArray dataArray) {
        for (int i = 0; i < dataArray.length(); ++i) {
            try {
                JSONObject customJson;
                JSONObject data = dataArray.getJSONObject(i);
                if (!data.has("custom") || !(customJson = new JSONObject(data.getString("custom"))).has("i")) continue;
                String notificationId = customJson.getString("i");
                JSONObject jsonBody = new JSONObject();
                jsonBody.put("app_id", (Object)OneSignal.getSavedAppId(inContext));
                jsonBody.put("player_id", (Object)OneSignal.getSavedUserId(inContext));
                jsonBody.put("opened", true);
                OneSignalRestClient.put(inContext, "notifications/" + notificationId, jsonBody, new JsonHttpResponseHandler(){

                    @Override
                    public void onFailure(int statusCode, Header[] headers, Throwable throwable, JSONObject errorResponse) {
                        OneSignal.logHttpError("sending Notification Opened Failed", statusCode, throwable, errorResponse);
                    }
                });
                continue;
            }
            catch (Throwable t) {
                OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON to send notification opened.", t);
            }
        }
    }

    private static void SaveAppId(String appId) {
        if (appContext == null) {
            return;
        }
        SharedPreferences prefs = OneSignal.getGcmPreferences((Context)appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString("GT_APP_ID", appId);
        editor.commit();
    }

    private static String getSavedAppId() {
        return OneSignal.getSavedAppId((Context)appContext);
    }

    private static String getSavedAppId(Context inContext) {
        if (inContext == null) {
            return "";
        }
        SharedPreferences prefs = OneSignal.getGcmPreferences(inContext);
        return prefs.getString("GT_APP_ID", null);
    }

    private static String getSavedUserId(Context inContext) {
        if (inContext == null) {
            return "";
        }
        SharedPreferences prefs = OneSignal.getGcmPreferences(inContext);
        return prefs.getString("GT_PLAYER_ID", null);
    }

    static String getUserId() {
        if (userId == null && appContext != null) {
            SharedPreferences prefs = OneSignal.getGcmPreferences((Context)appContext);
            userId = prefs.getString("GT_PLAYER_ID", null);
        }
        return userId;
    }

    private static void saveUserId(String inUserId) {
        userId = inUserId;
        if (appContext == null) {
            return;
        }
        SharedPreferences prefs = OneSignal.getGcmPreferences((Context)appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString("GT_PLAYER_ID", userId);
        editor.commit();
    }

    static String GetRegistrationId() {
        if (registrationId == null && appContext != null) {
            SharedPreferences prefs = OneSignal.getGcmPreferences((Context)appContext);
            registrationId = prefs.getString("GT_REGISTRATION_ID", null);
        }
        return registrationId;
    }

    public static void enableVibrate(boolean enable) {
        if (appContext == null) {
            return;
        }
        SharedPreferences prefs = OneSignal.getGcmPreferences((Context)appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putBoolean("GT_VIBRATE_ENABLED", enable);
        editor.commit();
    }

    static boolean getVibrate(Context context) {
        SharedPreferences prefs = OneSignal.getGcmPreferences(context);
        return prefs.getBoolean("GT_VIBRATE_ENABLED", true);
    }

    public static void enableSound(boolean enable) {
        if (appContext == null) {
            return;
        }
        SharedPreferences prefs = OneSignal.getGcmPreferences((Context)appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putBoolean("GT_SOUND_ENABLED", enable);
        editor.commit();
    }

    static boolean getSoundEnabled(Context context) {
        SharedPreferences prefs = OneSignal.getGcmPreferences(context);
        return prefs.getBoolean("GT_SOUND_ENABLED", true);
    }

    public static void enableNotificationsWhenActive(boolean enable) {
        if (appContext == null) {
            return;
        }
        SharedPreferences prefs = OneSignal.getGcmPreferences((Context)appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putBoolean("ONESIGNAL_ALWAYS_SHOW_NOTIF", enable);
        editor.commit();
    }

    static boolean getNotificationsWhenActiveEnabled(Context context) {
        SharedPreferences prefs = OneSignal.getGcmPreferences(context);
        return prefs.getBoolean("ONESIGNAL_ALWAYS_SHOW_NOTIF", false);
    }

    public static void enableInAppAlertNotification(boolean enable) {
        if (appContext == null) {
            return;
        }
        SharedPreferences prefs = OneSignal.getGcmPreferences((Context)appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putBoolean("ONESIGNAL_INAPP_ALERT", enable);
        editor.commit();
    }

    static boolean getInAppAlertNotificationEnabled(Context context) {
        SharedPreferences prefs = OneSignal.getGcmPreferences(context);
        return prefs.getBoolean("ONESIGNAL_INAPP_ALERT", false);
    }

    public static void setSubscription(boolean enable) {
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not set subscription.");
            return;
        }
        currentSubscription = currentSubscription < -2 ? currentSubscription : (enable ? 1 : -2);
        OneSignal.saveSubscription(currentSubscription);
        if (syncedSubscription == currentSubscription) {
            return;
        }
        try {
            if (OneSignal.getUserId() != null) {
                JSONObject jsonBody = OneSignal.playerUpdateBaseJSON();
                jsonBody.put("notification_types", currentSubscription);
                OneSignal.postPlayerUpdate(jsonBody);
            }
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Generating JSON setSubscription failed!", t);
        }
    }

    private static void saveSubscription(int value) {
        SharedPreferences prefs = OneSignal.getGcmPreferences((Context)appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putInt("ONESIGNAL_SUBSCRIPTION", value);
        editor.commit();
        savedSubscription = value;
    }

    private static void saveSyncedSubscription(int value) {
        SharedPreferences prefs = OneSignal.getGcmPreferences((Context)appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putInt("ONESIGNAL_SYNCED_SUBSCRIPTION", value);
        editor.commit();
        syncedSubscription = value;
    }

    static int getSyncedSubscription(Context context) {
        SharedPreferences prefs = OneSignal.getGcmPreferences(context);
        return prefs.getInt("ONESIGNAL_SYNCED_SUBSCRIPTION", 1);
    }

    static int getSubscription(Context context) {
        SharedPreferences prefs = OneSignal.getGcmPreferences(context);
        return prefs.getInt("ONESIGNAL_SUBSCRIPTION", 1);
    }

    private static void SaveRegistrationId(String inRegistrationId) {
        registrationId = inRegistrationId;
        SharedPreferences prefs = OneSignal.getGcmPreferences((Context)appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString("GT_REGISTRATION_ID", registrationId);
        editor.commit();
    }

    private static long GetUnsentActiveTime() {
        if (unSentActiveTime == -1L && appContext != null) {
            SharedPreferences prefs = OneSignal.getGcmPreferences((Context)appContext);
            unSentActiveTime = prefs.getLong("GT_UNSENT_ACTIVE_TIME", 0L);
        }
        return unSentActiveTime;
    }

    private static void SaveUnsentActiveTime(long time) {
        unSentActiveTime = time;
        if (appContext == null) {
            return;
        }
        SharedPreferences prefs = OneSignal.getGcmPreferences((Context)appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putLong("GT_UNSENT_ACTIVE_TIME", time);
        editor.commit();
    }

    static SharedPreferences getGcmPreferences(Context context) {
        return context.getSharedPreferences(OneSignal.class.getSimpleName(), 0);
    }

    static boolean isDuplicateNotification(String id, Context context) {
        if (id == null || "".equals(id)) {
            return false;
        }
        OneSignalDbHelper dbHelper = new OneSignalDbHelper(context);
        SQLiteDatabase readableDb = dbHelper.getReadableDatabase();
        String[] retColumn = new String[]{"notification_id"};
        String[] whereArgs = new String[]{id};
        Cursor cursor = readableDb.query("notification", retColumn, "notification_id = ?", whereArgs, null, null, null);
        boolean exists = cursor.moveToFirst();
        readableDb.close();
        if (exists) {
            OneSignal.Log(LOG_LEVEL.DEBUG, "Duplicate GCM message received, skipping processing. " + id);
            return true;
        }
        return false;
    }

    static boolean isValidAndNotDuplicated(Context context, Bundle bundle) {
        if (bundle.isEmpty()) {
            return false;
        }
        try {
            if (bundle.containsKey("custom")) {
                JSONObject customJSON = new JSONObject(bundle.getString("custom"));
                if (customJSON.has("i")) {
                    return !OneSignal.isDuplicateNotification(customJSON.getString("i"), context);
                }
                OneSignal.Log(LOG_LEVEL.DEBUG, "Not a OneSignal formatted GCM message. No 'i' field in custom.");
            } else {
                OneSignal.Log(LOG_LEVEL.DEBUG, "Not a OneSignal formatted GCM message. No 'custom' field in the bundle.");
            }
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.DEBUG, "Could not parse bundle for duplicate, probably not a OneSignal notification.", t);
        }
        return false;
    }

    static {
        visualLogLevel = LOG_LEVEL.NONE;
        logCatLevel = LOG_LEVEL.WARN;
        userId = null;
        currentSubscription = 1;
        foreground = true;
        unSentActiveTime = -1L;
        mainAdIdProvider = new AdvertisingIdProviderGPS();
        sdkType = "native";
        nextInitAdditionalDataJSON = null;
        nextInitMessage = null;
    }

    public static interface PostNotificationResponseHandler {
        public void onSuccess(JSONObject var1);

        public void onFailure(JSONObject var1);
    }

    public static interface GetTagsHandler {
        public void tagsAvailable(JSONObject var1);
    }

    public static interface IdsAvailableHandler {
        public void idsAvailable(String var1, String var2);
    }

    public static interface NotificationOpenedHandler {
        public void notificationOpened(String var1, JSONObject var2, boolean var3);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface TiedToCurrentActivity {
    }

    public static enum LOG_LEVEL {
        NONE,
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        VERBOSE;

    }
}

