/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.saml2;

import com.onelogin.saml2.model.Contact;
import com.onelogin.saml2.model.Organization;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.util.Util;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class Metadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(Metadata.class);
    private static final int N_DAYS_VALID_UNTIL = 2;
    private static final int SECONDS_CACHED = 604800;
    private final String metadataString;
    private final Calendar validUntilTime;
    private final Integer cacheDuration;

    public Metadata(Saml2Settings settings, Calendar validUntilTime, Integer cacheDuration) throws CertificateEncodingException {
        if (validUntilTime == null) {
            this.validUntilTime = Calendar.getInstance();
            this.validUntilTime.add(6, 2);
        } else {
            this.validUntilTime = validUntilTime;
        }
        this.cacheDuration = cacheDuration == null ? Integer.valueOf(604800) : cacheDuration;
        StrSubstitutor substitutor = this.generateSubstitutor(settings);
        String unsignedMetadataString = substitutor.replace((CharSequence)Metadata.getMetadataTemplate());
        LOGGER.debug("metadata --> " + unsignedMetadataString);
        this.metadataString = unsignedMetadataString;
    }

    public Metadata(Saml2Settings settings) throws CertificateEncodingException {
        this(settings, null, null);
    }

    private StrSubstitutor generateSubstitutor(Saml2Settings settings) throws CertificateEncodingException {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("id", Util.generateUniqueID());
        valueMap.put("validUntilTime", Util.formatDateTime(this.validUntilTime.getTimeInMillis()));
        valueMap.put("cacheDuration", String.valueOf(this.cacheDuration));
        valueMap.put("spEntityId", settings.getSpEntityId());
        valueMap.put("strAuthnsign", String.valueOf(settings.getAuthnRequestsSigned()));
        valueMap.put("strWsign", String.valueOf(settings.getWantAssertionsSigned()));
        valueMap.put("spNameIDFormat", settings.getSpNameIDFormat());
        valueMap.put("spAssertionConsumerServiceBinding", settings.getSpAssertionConsumerServiceBinding());
        valueMap.put("spAssertionConsumerServiceUrl", settings.getSpAssertionConsumerServiceUrl().toString());
        valueMap.put("sls", this.toSLSXml(settings.getSpSingleLogoutServiceUrl(), settings.getSpSingleLogoutServiceBinding()).toString());
        valueMap.put("strKeyDescriptor", this.toX509KeyDescriptorsXML(settings.getSPcert()).toString());
        valueMap.put("strContacts", this.toContactsXml(settings.getContacts()));
        valueMap.put("strOrganization", this.toOrganizationXml(settings.getOrganization(), "en"));
        return new StrSubstitutor(valueMap);
    }

    private static StringBuilder getMetadataTemplate() {
        StringBuilder template = new StringBuilder();
        template.append("<?xml version=\"1.0\"?>");
        template.append("<md:EntityDescriptor xmlns:md=\"urn:oasis:names:tc:SAML:2.0:metadata\"");
        template.append(" validUntil=\"${validUntilTime}\"");
        template.append(" cacheDuration=\"PT${cacheDuration}S\"");
        template.append(" entityID=\"${spEntityId}\"");
        template.append(" ID=\"${id}\">");
        template.append("<md:SPSSODescriptor AuthnRequestsSigned=\"${strAuthnsign}\" WantAssertionsSigned=\"${strWsign}\" protocolSupportEnumeration=\"urn:oasis:names:tc:SAML:2.0:protocol\">");
        template.append("${strKeyDescriptor}");
        template.append("${sls}<md:NameIDFormat>${spNameIDFormat}</md:NameIDFormat>");
        template.append("<md:AssertionConsumerService Binding=\"${spAssertionConsumerServiceBinding}\"");
        template.append(" Location=\"${spAssertionConsumerServiceUrl}\"");
        template.append(" index=\"1\"/>");
        template.append("</md:SPSSODescriptor>${strOrganization}${strContacts}");
        template.append("</md:EntityDescriptor>");
        return template;
    }

    private String toContactsXml(List<Contact> contacts) {
        StringBuilder contactsXml = new StringBuilder();
        for (Contact contact : contacts) {
            contactsXml.append("<md:ContactPerson contactType=\"" + contact.getContactType() + "\">");
            contactsXml.append("<md:GivenName>" + contact.getGivenName() + "</md:GivenName>");
            contactsXml.append("<md:EmailAddress>" + contact.getEmailAddress() + "</md:EmailAddress>");
            contactsXml.append("</md:ContactPerson>");
        }
        return contactsXml.toString();
    }

    private String toOrganizationXml(Organization organization, String lang) {
        String orgXml = "";
        if (lang == null) {
            lang = "en";
        }
        if (organization != null) {
            orgXml = "<md:Organization><md:OrganizationName xml:lang=\"" + lang + "\">" + organization.getOrgName() + "</md:OrganizationName><md:OrganizationDisplayName xml:lang=\"" + lang + "\">" + organization.getOrgDisplayName() + "</md:OrganizationDisplayName><md:OrganizationURL xml:lang=\"" + lang + "\">" + organization.getOrgUrl() + "</md:OrganizationURL></md:Organization>";
        }
        return orgXml;
    }

    private String toX509KeyDescriptorsXML(X509Certificate cert) throws CertificateEncodingException {
        StringBuilder keyDescriptorXml = new StringBuilder();
        if (cert != null) {
            Base64 encoder = new Base64(64);
            byte[] encodedCert = cert.getEncoded();
            String certString = new String(encoder.encode(encodedCert));
            keyDescriptorXml.append("<md:KeyDescriptor use=\"signing\">");
            keyDescriptorXml.append("<ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">");
            keyDescriptorXml.append("<ds:X509Data>");
            keyDescriptorXml.append("<ds:X509Certificate>" + certString + "</ds:X509Certificate>");
            keyDescriptorXml.append("</ds:X509Data>");
            keyDescriptorXml.append("</ds:KeyInfo>");
            keyDescriptorXml.append("</md:KeyDescriptor>");
            keyDescriptorXml.append("<md:KeyDescriptor use=\"encryption\">");
            keyDescriptorXml.append("<ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">");
            keyDescriptorXml.append("<ds:X509Data>");
            keyDescriptorXml.append("<ds:X509Certificate>" + certString + "</ds:X509Certificate>");
            keyDescriptorXml.append("</ds:X509Data>");
            keyDescriptorXml.append("</ds:KeyInfo>");
            keyDescriptorXml.append("</md:KeyDescriptor>");
        }
        return keyDescriptorXml.toString();
    }

    private String toSLSXml(URL spSingleLogoutServiceUrl, String spSingleLogoutServiceBinding) {
        StringBuilder slsXml = new StringBuilder();
        if (spSingleLogoutServiceUrl != null) {
            slsXml.append("<md:SingleLogoutService Binding=\"" + spSingleLogoutServiceBinding + "\"");
            slsXml.append(" Location=\"" + spSingleLogoutServiceUrl.toString() + "\"/>");
        }
        return slsXml.toString();
    }

    public final String getMetadataString() {
        return this.metadataString;
    }

    public static String signMetadata(String metadata, PrivateKey key, X509Certificate cert, String signAlgorithm) throws XPathExpressionException, XMLSecurityException {
        Document metadataDoc = Util.loadXML(metadata);
        String signedMetadata = Util.addSign(metadataDoc, key, cert, signAlgorithm);
        LOGGER.debug("Signed metadata --> " + signedMetadata);
        return signedMetadata;
    }
}

