/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.saml;

import com.onelogin.Constants;
import com.onelogin.saml.XMLErrorHandler;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Utils {
    static final String ISO8601DATEFORMAT = "yyyy-MM-ddTHH:mm:ssZ";
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static NodeList query(Document dom, String query, Node context) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                String result = null;
                if (prefix.equals("samlp") || prefix.equals("samlp2")) {
                    result = Constants.NS_SAMLP;
                } else if (prefix.equals("saml") || prefix.equals("saml2")) {
                    result = Constants.NS_SAML;
                } else if (prefix.equals("ds")) {
                    result = Constants.NS_DS;
                } else if (prefix.equals("xenc")) {
                    result = Constants.NS_XENC;
                }
                return result;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return null;
            }

            public Iterator getPrefixes(String namespaceURI) {
                return null;
            }
        });
        NodeList nodeList = context == null ? (NodeList)xpath.evaluate(query, dom, XPathConstants.NODESET) : (NodeList)xpath.evaluate(query, context, XPathConstants.NODESET);
        return nodeList;
    }

    public static Map<String, String> getStatus(Document dom) throws Error {
        HashMap<String, String> status = new HashMap<String, String>();
        try {
            NodeList statusEntry = Utils.query(dom, "/samlp:Response/samlp:Status", null);
            if (statusEntry.getLength() == 0) {
                throw new Error("Missing Status on response");
            }
            NodeList codeEntry = Utils.query(dom, "/samlp:Response/samlp:Status/samlp:StatusCode", (Element)statusEntry.item(0));
            if (codeEntry.getLength() == 0) {
                throw new Error("Missing Status Code on response");
            }
            status.put("code", codeEntry.item(0).getAttributes().getNamedItem("Value").getNodeValue());
            NodeList messageEntry = Utils.query(dom, "/samlp:Response/samlp:Status/samlp:StatusMessage", (Element)statusEntry.item(0));
            if (messageEntry.getLength() == 0) {
                status.put("msg", "");
            } else {
                status.put("msg", messageEntry.item(0).getNodeValue());
            }
        }
        catch (Error e) {
            log.error("Error executing getStatus: " + e.getMessage());
            throw e;
        }
        catch (Exception ex) {
            log.error("Error executing getStatus: " + ex.getMessage(), (Throwable)ex);
        }
        return status;
    }

    public static Document loadXML(String xml) throws Exception {
        if (xml.contains("<!ENTITY")) {
            throw new Exception("Detected use of ENTITY in XML, disabled to prevent XXE/XEE attacks");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            factory.setAttribute("http://xml.org/sax/features/external-general-entities", Boolean.FALSE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            factory.setAttribute("http://xml.org/sax/features/external-parameter-entities", Boolean.FALSE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            factory.setAttribute("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            factory.setAttribute("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xml)));
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression expr = xpath.compile("//*[@ID]");
            NodeList nodeList = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element elem = (Element)nodeList.item(i);
                Attr attr = (Attr)elem.getAttributes().getNamedItem("ID");
                elem.setIdAttributeNode(attr, true);
            }
            return doc;
        }
        catch (Exception e) {
            log.error("Error executing loadXML: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Document validateXML(Document xml, String schemaName) throws Exception {
        return Utils.validateXML(Utils.getStringFromDocument(xml), schemaName, new Boolean[0]);
    }

    public static Document validateXML(String xmlString, String schemaName, Boolean ... debugMode) throws Exception {
        try {
            String schemaFullPath = "schemas" + File.separatorChar + schemaName;
            log.debug("schemaFullPath: " + schemaFullPath);
            ClassLoader classLoader = Utils.class.getClassLoader();
            URL schemaFile = classLoader.getResource(schemaFullPath);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(schemaFile);
            Validator validator = schema.newValidator();
            XMLErrorHandler errorHandler = new XMLErrorHandler();
            validator.setErrorHandler(errorHandler);
            validator.validate(new StreamSource(new StringReader(xmlString)));
            if (errorHandler.getErrorXML().size() > 0) {
                throw new Error("Invalid XML. See the log");
            }
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception ex) {
            log.error("Error executing validateXML: " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        return Utils.convertStringToDocument(xmlString);
    }

    public static boolean validateSign(Node signatureElement, Certificate cert, String ... fingerprint) throws Exception {
        boolean res = false;
        DOMValidateContext ctx = new DOMValidateContext(cert.getPublicKey(), signatureElement);
        XMLSignatureFactory sigF = XMLSignatureFactory.getInstance("DOM");
        try {
            XMLSignature xmlSignature = sigF.unmarshalXMLSignature(ctx);
            res = xmlSignature.validate(ctx);
        }
        catch (MarshalException e) {
            log.error("Cannot locate Signature Node " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (NullPointerException e) {
            log.error("Context can't be validated", (Throwable)e);
            throw e;
        }
        return res;
    }

    private static Document convertStringToDocument(String xmlStr) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlStr)));
            return doc;
        }
        catch (Exception ex) {
            log.error("Error executing convertStringToDocument: " + ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static String getStringFromDocument(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            writer.flush();
            return writer.toString();
        }
        catch (TransformerException ex) {
            log.error("Error executing getStringFromDocument: " + ex.getMessage(), (Throwable)ex);
            return null;
        }
    }
}

