/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.saml;

import com.onelogin.AccountSettings;
import com.onelogin.Constants;
import com.onelogin.Error;
import com.onelogin.saml.Utils;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Response {
    private Document document;
    private Element rootElement;
    private final AccountSettings accountSettings;
    private String response;
    private String currentUrl;
    private StringBuffer error = new StringBuffer();
    private String audienceUrl;
    private static final Logger log = LoggerFactory.getLogger(Response.class);

    public Response(AccountSettings accountSettings) throws CertificateException {
        this.accountSettings = accountSettings;
    }

    public Response(AccountSettings accountSettings, String response, String currentURL) throws Exception {
        this(accountSettings);
        this.loadXmlFromBase64(response);
        this.currentUrl = currentURL;
    }

    public void loadXmlFromBase64(String responseStr) throws Exception {
        Base64 base64 = new Base64();
        byte[] decodedB = base64.decode(responseStr);
        this.response = new String(decodedB);
        this.document = Utils.loadXML(this.response);
        if (this.document == null) {
            throw new Exception("SAML Response could not be processed");
        }
    }

    public boolean isValid(String ... requestId) {
        try {
            String destinationUrl;
            Calendar now = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            if (this.document == null) {
                throw new Exception("SAML Response is not loaded");
            }
            if (this.currentUrl == null || this.currentUrl.isEmpty()) {
                throw new Exception("The URL of the current host was not established");
            }
            this.rootElement = this.document.getDocumentElement();
            this.rootElement.normalize();
            if (!this.rootElement.getAttribute("Version").equals("2.0")) {
                throw new Exception("Unsupported SAML Version.");
            }
            if (!this.rootElement.hasAttribute("ID")) {
                throw new Exception("Missing ID attribute on SAML Response.");
            }
            this.checkStatus();
            if (!this.validateNumAssertions()) {
                throw new Exception("SAML Response must contain 1 Assertion.");
            }
            NodeList signNodes = this.document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            ArrayList<String> signedElements = new ArrayList<String>();
            for (int i = 0; i < signNodes.getLength(); ++i) {
                signedElements.add(signNodes.item(i).getParentNode().getLocalName());
            }
            if (!signedElements.isEmpty() && !this.validateSignedElements(signedElements)) {
                throw new Exception("Found an unexpected Signature Element. SAML Response rejected");
            }
            Document res = Utils.validateXML(this.document, "saml-schema-protocol-2.0.xsd");
            if (!(res instanceof Document)) {
                throw new Exception("Invalid SAML Response. Not match the saml-schema-protocol-2.0.xsd");
            }
            if (this.rootElement.hasAttribute("InResponseTo")) {
                String responseInResponseTo = this.document.getDocumentElement().getAttribute("InResponseTo");
                if (requestId.length > 0 && responseInResponseTo.compareTo(requestId[0]) != 0) {
                    throw new Exception("The InResponseTo of the Response: " + responseInResponseTo + ", does not match the ID of the AuthNRequest sent by the SP: " + requestId[0]);
                }
            }
            if (!this.validateTimestamps()) {
                throw new Exception("Timing issues (please check your clock settings)");
            }
            NodeList encryptedAttributeNodes = this.queryAssertion("/saml:AttributeStatement/saml:EncryptedAttribute");
            if (encryptedAttributeNodes.getLength() > 0) {
                throw new Exception("There is an EncryptedAttribute in the Response and this SP not support them");
            }
            Set<String> validAudiences = this.getAudiences();
            if (this.rootElement.hasAttribute("Destination") && (destinationUrl = this.rootElement.getAttribute("Destination")) != null && !destinationUrl.isEmpty() && !destinationUrl.equals(this.currentUrl)) {
                throw new Exception("The response was received at " + this.currentUrl + " instead of " + destinationUrl);
            }
            Set<String> issuers = this.getIssuers();
            for (String issuer : issuers) {
                if (!issuer.isEmpty()) continue;
                throw new Exception("Invalid issuer in the Assertion/Response");
            }
            Calendar sessionExpiration = this.getSessionNotOnOrAfter();
            if (sessionExpiration != null && (now.equals(sessionExpiration) || now.after(sessionExpiration))) {
                throw new Exception("The attributes have expired, based on the SessionNotOnOrAfter of the AttributeStatement of this Response");
            }
            boolean validSubjectConfirmation = true;
            NodeList subjectConfirmationNodes = this.queryAssertion("/saml:Subject/saml:SubjectConfirmation");
            for (int i = 0; i < subjectConfirmationNodes.getLength(); ++i) {
                Node scn = subjectConfirmationNodes.item(i);
                Node method = scn.getAttributes().getNamedItem("Method");
                if (method != null && !method.getNodeValue().equals(Constants.CM_BEARER)) continue;
                NodeList subjectConfirmationDataNodes = scn.getChildNodes();
                for (int c = 0; c < subjectConfirmationDataNodes.getLength(); ++c) {
                    Calendar nb;
                    Node notBefore;
                    Calendar noa;
                    Node notOnOrAfter;
                    if (subjectConfirmationDataNodes.item(c).getLocalName() == null || !subjectConfirmationDataNodes.item(c).getLocalName().equals("SubjectConfirmationData")) continue;
                    Node recipient = subjectConfirmationDataNodes.item(c).getAttributes().getNamedItem("Recipient");
                    if (recipient != null && !recipient.getNodeValue().isEmpty() && !recipient.getNodeValue().equals(this.currentUrl)) {
                        validSubjectConfirmation = false;
                    }
                    if ((notOnOrAfter = subjectConfirmationDataNodes.item(c).getAttributes().getNamedItem("NotOnOrAfter")) != null && (now.equals(noa = DatatypeConverter.parseDateTime((String)notOnOrAfter.getNodeValue())) || now.after(noa))) {
                        validSubjectConfirmation = false;
                    }
                    if ((notBefore = subjectConfirmationDataNodes.item(c).getAttributes().getNamedItem("NotBefore")) == null || !now.before(nb = DatatypeConverter.parseDateTime((String)notBefore.getNodeValue()))) continue;
                    validSubjectConfirmation = false;
                }
            }
            if (!validSubjectConfirmation) {
                throw new Exception("A valid SubjectConfirmation was not found on this Response");
            }
            if (signedElements.isEmpty()) {
                throw new Exception("No Signature found. SAML Response rejected");
            }
            Certificate cert = this.accountSettings.getIdpCert();
            if (!Utils.validateSign(signNodes.item(0), cert, new String[0])) {
                throw new Exception("Signature validation failed. SAML Response rejected");
            }
            return true;
        }
        catch (Error e) {
            this.error.append(e.getMessage());
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error.append(e.getMessage());
            return false;
        }
    }

    public String getNameId() throws Exception {
        NodeList nodes = this.document.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "NameID");
        if (nodes.getLength() == 0) {
            throw new Exception("No name id found in Document.");
        }
        return nodes.item(0).getTextContent();
    }

    public String getAttribute(String name) {
        HashMap<String, ArrayList<String>> attributes = this.getAttributes();
        if (!attributes.isEmpty()) {
            return attributes.get(name).toString();
        }
        return null;
    }

    public HashMap<String, ArrayList<String>> getAttributes() {
        HashMap<String, ArrayList<String>> attributes = new HashMap<String, ArrayList<String>>();
        NodeList nodes = this.document.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Attribute");
        if (nodes.getLength() != 0) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                NamedNodeMap attrName = nodes.item(i).getAttributes();
                String attName = attrName.getNamedItem("Name").getNodeValue();
                NodeList children = nodes.item(i).getChildNodes();
                ArrayList<String> attrValues = new ArrayList<String>();
                for (int j = 0; j < children.getLength(); ++j) {
                    attrValues.add(children.item(j).getTextContent());
                }
                attributes.put(attName, attrValues);
            }
        } else {
            return null;
        }
        return attributes;
    }

    private Map<String, String> checkStatus() throws Exception {
        Map<String, String> status = Utils.getStatus(this.document);
        if (status.containsKey("code") && !status.get("code").equals(Constants.STATUS_SUCCESS)) {
            String statusExceptionMsg = "The status code of the Response was not Success, was " + status.get("code").substring(status.get("code").lastIndexOf(58) + 1);
            if (status.containsKey("msg")) {
                statusExceptionMsg = statusExceptionMsg + " -> " + status.containsKey("msg");
            }
            throw new Exception(statusExceptionMsg);
        }
        return status;
    }

    public Set<String> getAudiences() throws XPathExpressionException {
        LinkedHashSet<String> audiences = new LinkedHashSet<String>();
        NodeList entries = this.queryAssertion("/saml:Conditions/saml:AudienceRestriction/saml:Audience");
        if (entries.getLength() > 0 && entries.item(0) != null && entries.item(0).getChildNodes().getLength() > 0) {
            this.audienceUrl = entries.item(0).getChildNodes().item(0).getNodeValue();
        }
        for (int i = 0; i < entries.getLength(); ++i) {
            String value;
            if (entries.item(i) == null || (value = entries.item(i).getTextContent()) == null || value.trim().isEmpty()) continue;
            audiences.add(value.trim());
        }
        return audiences;
    }

    public Set<String> getIssuers() throws XPathExpressionException {
        NodeList assertionIssuer;
        LinkedHashSet<String> issuers = new LinkedHashSet<String>();
        NodeList responseIssuer = this.queryAssertion("/samlp:Response/saml:Issuer");
        if (responseIssuer.getLength() == 1) {
            issuers.add(responseIssuer.item(0).getTextContent());
        }
        if ((assertionIssuer = this.queryAssertion("/saml:Issuer")).getLength() == 1) {
            issuers.add(assertionIssuer.item(0).getTextContent());
        }
        return issuers;
    }

    public Calendar getSessionNotOnOrAfter() throws XPathExpressionException {
        String notOnOrAfter = null;
        NodeList entries = this.queryAssertion("/saml:AuthnStatement[@SessionNotOnOrAfter]");
        if (entries.getLength() > 0) {
            notOnOrAfter = entries.item(0).getAttributes().getNamedItem("SessionNotOnOrAfter").getNodeValue();
            return DatatypeConverter.parseDateTime((String)notOnOrAfter);
        }
        return null;
    }

    private boolean validateNumAssertions() {
        NodeList assertionNodes = this.document.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        return assertionNodes != null && assertionNodes.getLength() == 1;
    }

    private boolean validateSignedElements(ArrayList<String> signedElements) {
        if (signedElements.size() > 2) {
            return false;
        }
        HashMap<String, Integer> occurrences = new HashMap<String, Integer>();
        for (String e : signedElements) {
            if (occurrences.containsKey(e)) {
                occurrences.put(e, (Integer)occurrences.get(e) + 1);
                continue;
            }
            occurrences.put(e, 1);
        }
        return !(occurrences.containsKey("Response") && (Integer)occurrences.get("Response") > 1 || occurrences.containsKey("Assertion") && (Integer)occurrences.get("Assertion") > 1) && (occurrences.containsKey("Response") || occurrences.containsKey("Assertion"));
    }

    private boolean validateTimestamps() {
        NodeList timestampNodes = this.document.getElementsByTagNameNS("*", "Conditions");
        if (timestampNodes.getLength() != 0) {
            for (int i = 0; i < timestampNodes.getLength(); ++i) {
                NamedNodeMap attrName = timestampNodes.item(i).getAttributes();
                Node nbAttribute = attrName.getNamedItem("NotBefore");
                Node naAttribute = attrName.getNamedItem("NotOnOrAfter");
                Calendar now = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                log.debug("now :" + now.get(11) + ":" + now.get(12) + ":" + now.get(13));
                if (naAttribute != null) {
                    Calendar notOnOrAfterDate = DatatypeConverter.parseDateTime((String)naAttribute.getNodeValue());
                    log.debug("notOnOrAfterDate :" + notOnOrAfterDate.get(11) + ":" + notOnOrAfterDate.get(12) + ":" + notOnOrAfterDate.get(13));
                    if (now.equals(notOnOrAfterDate) || now.after(notOnOrAfterDate)) {
                        return false;
                    }
                }
                if (nbAttribute == null) continue;
                Calendar notBeforeDate = DatatypeConverter.parseDateTime((String)nbAttribute.getNodeValue());
                log.debug("notBeforeDate :" + notBeforeDate.get(11) + ":" + notBeforeDate.get(12) + ":" + notBeforeDate.get(13));
                if (!now.before(notBeforeDate)) continue;
                return false;
            }
        }
        return true;
    }

    public void setDestinationUrl(String urld) {
        this.currentUrl = urld;
    }

    public String getError() {
        if (this.error != null) {
            return this.error.toString();
        }
        return "";
    }

    private NodeList queryAssertion(String assertionXpath) throws XPathExpressionException {
        String nameQuery = "";
        String signatureQuery = "/samlp:Response/saml:Assertion/ds:Signature/ds:SignedInfo/ds:Reference";
        NodeList nodeList = Utils.query(this.document, signatureQuery, null);
        if (nodeList.getLength() > 0) {
            Node assertionReferenceNode = nodeList.item(0);
            String id = assertionReferenceNode.getAttributes().getNamedItem("URI").getNodeValue().substring(1);
            nameQuery = "/samlp:Response/saml:Assertion[@ID='" + id + "']" + assertionXpath;
        } else {
            signatureQuery = "/samlp:Response/ds:Signature/ds:SignedInfo/ds:Reference";
            nodeList = Utils.query(this.document, signatureQuery, null);
            if (nodeList.getLength() > 0) {
                Node assertionReferenceNode = nodeList.item(0);
                String id = assertionReferenceNode.getAttributes().getNamedItem("URI").getNodeValue().substring(1);
                nameQuery = "/samlp:Response[@ID='" + id + "']/saml:Assertion" + assertionXpath;
            } else {
                nameQuery = "/samlp:Response/saml:Assertion" + assertionXpath;
            }
        }
        return Utils.query(this.document, nameQuery, null);
    }
}

