/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.saml2.settings;

import com.onelogin.saml2.model.Contact;
import com.onelogin.saml2.model.Organization;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.util.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingsBuilder.class);
    private Properties prop = new Properties();
    private Saml2Settings saml2Setting;
    public static final String STRICT_PROPERTY_KEY = "onelogin.saml2.strict";
    public static final String DEBUG_PROPERTY_KEY = "onelogin.saml2.debug";
    public static final String SP_ENTITYID_PROPERTY_KEY = "onelogin.saml2.sp.entityid";
    public static final String SP_ASSERTION_CONSUMER_SERVICE_URL_PROPERTY_KEY = "onelogin.saml2.sp.assertion_consumer_service.url";
    public static final String SP_ASSERTION_CONSUMER_SERVICE_BINDING_PROPERTY_KEY = "onelogin.saml2.sp.assertion_consumer_service.binding";
    public static final String SP_SINGLE_LOGOUT_SERVICE_URL_PROPERTY_KEY = "onelogin.saml2.sp.single_logout_service.url";
    public static final String SP_SINGLE_LOGOUT_SERVICE_BINDING_PROPERTY_KEY = "onelogin.saml2.sp.single_logout_service.binding";
    public static final String SP_NAMEIDFORMAT_PROPERTY_KEY = "onelogin.saml2.sp.nameidformat";
    public static final String SP_X509CERT_PROPERTY_KEY = "onelogin.saml2.sp.x509cert";
    public static final String SP_PRIVATEKEY_PROPERTY_KEY = "onelogin.saml2.sp.privatekey";
    public static final String IDP_ENTITYID_PROPERTY_KEY = "onelogin.saml2.idp.entityid";
    public static final String IDP_SINGLE_SIGN_ON_SERVICE_URL_PROPERTY_KEY = "onelogin.saml2.idp.single_sign_on_service.url";
    public static final String IDP_SINGLE_SIGN_ON_SERVICE_BINDING_PROPERTY_KEY = "onelogin.saml2.idp.single_sign_on_service.binding";
    public static final String IDP_SINGLE_LOGOUT_SERVICE_URL_PROPERTY_KEY = "onelogin.saml2.idp.single_logout_service.url";
    public static final String IDP_SINGLE_LOGOUT_SERVICE_BINDING_PROPERTY_KEY = "onelogin.saml2.idp.single_logout_service.binding";
    public static final String IDP_X509CERT_PROPERTY_KEY = "onelogin.saml2.idp.x509cert";
    public static final String CERTFINGERPRINT_PROPERTY_KEY = "onelogin.saml2.idp.certfingerprint";
    public static final String CERTFINGERPRINT_ALGORITHM_PROPERTY_KEY = "onelogin.saml2.idp.certfingerprint_algorithm";
    public static final String SECURITY_NAMEID_ENCRYPTED = "onelogin.saml2.security.nameid_encrypted";
    public static final String SECURITY_AUTHREQUEST_SIGNED = "onelogin.saml2.security.authnrequest_signed";
    public static final String SECURITY_LOGOUTREQUEST_SIGNED = "onelogin.saml2.security.logoutrequest_signed";
    public static final String SECURITY_LOGOUTRESPONSE_SIGNED = "onelogin.saml2.security.logoutresponse_signed";
    public static final String SECURITY_WANT_MESSAGES_SIGNED = "onelogin.saml2.security.want_messages_signed";
    public static final String SECURITY_WANT_ASSERTIONS_SIGNED = "onelogin.saml2.security.want_assertions_signed";
    public static final String SECURITY_WANT_ASSERTIONS_ENCRYPTED = "onelogin.saml2.security.want_assertions_encrypted";
    public static final String SECURITY_WANT_NAMEID = "onelogin.saml2.security.want_nameid";
    public static final String SECURITY_WANT_NAMEID_ENCRYPTED = "onelogin.saml2.security.want_nameid_encrypted";
    public static final String SECURITY_SIGN_METADATA = "onelogin.saml2.security.sign_metadata";
    public static final String SECURITY_REQUESTED_AUTHNCONTEXT = "onelogin.saml2.security.requested_authncontext";
    public static final String SECURITY_REQUESTED_AUTHNCONTEXTCOMPARISON = "onelogin.saml2.security.requested_authncontextcomparison";
    public static final String SECURITY_WANT_XML_VALIDATION = "onelogin.saml2.security.want_xml_validation";
    public static final String SECURITY_SIGNATURE_ALGORITHM = "onelogin.saml2.security.signature_algorithm";
    public static final String SECURITY_REJECT_UNSOLICITED_RESPONSES_WITH_INRESPONSETO = "onelogin.saml2.security.reject_unsolicited_responses_with_inresponseto";
    public static final String CONTACT_TECHNICAL_GIVEN_NAME = "onelogin.saml2.contacts.technical.given_name";
    public static final String CONTACT_TECHNICAL_EMAIL_ADDRESS = "onelogin.saml2.contacts.technical.email_address";
    public static final String CONTACT_SUPPORT_GIVEN_NAME = "onelogin.saml2.contacts.support.given_name";
    public static final String CONTACT_SUPPORT_EMAIL_ADDRESS = "onelogin.saml2.contacts.support.email_address";
    public static final String ORGANIZATION_NAME = "onelogin.saml2.organization.name";
    public static final String ORGANIZATION_DISPLAYNAME = "onelogin.saml2.organization.displayname";
    public static final String ORGANIZATION_URL = "onelogin.saml2.organization.url";

    public SettingsBuilder fromFile(String propFileName) throws IOException {
        this.loadPropFile(propFileName);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPropFile(String propFileName) throws IOException {
        block9: {
            InputStream inputStream = null;
            try {
                inputStream = this.getClass().getClassLoader().getResourceAsStream(propFileName);
                if (inputStream != null) {
                    this.prop.load(inputStream);
                    LOGGER.debug("properties file " + propFileName + "loaded succesfully");
                    break block9;
                }
                throw new FileNotFoundException("properties file '" + propFileName + "' not found in the classpath");
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("properties file not closed properly.", (Throwable)e);
                }
            }
        }
    }

    public Saml2Settings build() throws IOException {
        Boolean debug;
        this.saml2Setting = new Saml2Settings();
        Boolean strict = this.loadBooleanProperty(STRICT_PROPERTY_KEY);
        if (strict != null) {
            this.saml2Setting.setStrict(strict);
        }
        if ((debug = this.loadBooleanProperty(DEBUG_PROPERTY_KEY)) != null) {
            this.saml2Setting.setDebug(debug);
        }
        this.loadSpSetting();
        this.loadIdpSetting();
        this.loadSecuritySetting();
        this.saml2Setting.setContacts(this.loadContacts());
        this.saml2Setting.setOrganization(this.loadOrganization());
        return this.saml2Setting;
    }

    private void loadIdpSetting() {
        String idpCertFingerprintAlgorithm;
        String idpCertFingerprint;
        X509Certificate idpX509cert;
        String idpSingleLogoutServiceBinding;
        URL idpSingleLogoutServiceUrl;
        String idpSingleSignOnServiceBinding;
        URL idpSingleSignOnServiceUrl;
        String idpEntityID = this.loadStringProperty(IDP_ENTITYID_PROPERTY_KEY);
        if (idpEntityID != null) {
            this.saml2Setting.setIdpEntityId(idpEntityID);
        }
        if ((idpSingleSignOnServiceUrl = this.loadURLProperty(IDP_SINGLE_SIGN_ON_SERVICE_URL_PROPERTY_KEY)) != null) {
            this.saml2Setting.setIdpSingleSignOnServiceUrl(idpSingleSignOnServiceUrl);
        }
        if ((idpSingleSignOnServiceBinding = this.loadStringProperty(IDP_SINGLE_SIGN_ON_SERVICE_BINDING_PROPERTY_KEY)) != null) {
            this.saml2Setting.setIdpSingleSignOnServiceBinding(idpSingleSignOnServiceBinding);
        }
        if ((idpSingleLogoutServiceUrl = this.loadURLProperty(IDP_SINGLE_LOGOUT_SERVICE_URL_PROPERTY_KEY)) != null) {
            this.saml2Setting.setIdpSingleLogoutServiceUrl(idpSingleLogoutServiceUrl);
        }
        if ((idpSingleLogoutServiceBinding = this.loadStringProperty(IDP_SINGLE_LOGOUT_SERVICE_BINDING_PROPERTY_KEY)) != null) {
            this.saml2Setting.setIdpSingleLogoutServiceBinding(idpSingleLogoutServiceBinding);
        }
        if ((idpX509cert = this.loadCertificateFromProp(IDP_X509CERT_PROPERTY_KEY)) != null) {
            this.saml2Setting.setIdpx509cert(idpX509cert);
        }
        if ((idpCertFingerprint = this.loadStringProperty(CERTFINGERPRINT_PROPERTY_KEY)) != null) {
            this.saml2Setting.setIdpCertFingerprint(idpCertFingerprint);
        }
        if ((idpCertFingerprintAlgorithm = this.loadStringProperty(CERTFINGERPRINT_ALGORITHM_PROPERTY_KEY)) != null && !idpCertFingerprintAlgorithm.isEmpty()) {
            this.saml2Setting.setIdpCertFingerprintAlgorithm(idpCertFingerprintAlgorithm);
        }
    }

    private void loadSecuritySetting() {
        Boolean rejectUnsolicitedResponsesWithInResponseTo;
        String signatureAlgorithm;
        String requestedAuthnContextComparison;
        List<String> requestedAuthnContext;
        Boolean signMetadata;
        Boolean wantXMLValidation;
        Boolean wantNameIdEncrypted;
        Boolean wantNameId;
        Boolean wantAssertionsEncrypted;
        Boolean wantAssertionsSigned;
        Boolean wantMessagesSigned;
        Boolean logoutResponseSigned;
        Boolean logoutRequestSigned;
        Boolean authnRequestsSigned;
        Boolean nameIdEncrypted = this.loadBooleanProperty(SECURITY_NAMEID_ENCRYPTED);
        if (nameIdEncrypted != null) {
            this.saml2Setting.setNameIdEncrypted(nameIdEncrypted);
        }
        if ((authnRequestsSigned = this.loadBooleanProperty(SECURITY_AUTHREQUEST_SIGNED)) != null) {
            this.saml2Setting.setAuthnRequestsSigned(authnRequestsSigned);
        }
        if ((logoutRequestSigned = this.loadBooleanProperty(SECURITY_LOGOUTREQUEST_SIGNED)) != null) {
            this.saml2Setting.setLogoutRequestSigned(logoutRequestSigned);
        }
        if ((logoutResponseSigned = this.loadBooleanProperty(SECURITY_LOGOUTRESPONSE_SIGNED)) != null) {
            this.saml2Setting.setLogoutResponseSigned(logoutResponseSigned);
        }
        if ((wantMessagesSigned = this.loadBooleanProperty(SECURITY_WANT_MESSAGES_SIGNED)) != null) {
            this.saml2Setting.setWantMessagesSigned(wantMessagesSigned);
        }
        if ((wantAssertionsSigned = this.loadBooleanProperty(SECURITY_WANT_ASSERTIONS_SIGNED)) != null) {
            this.saml2Setting.setWantAssertionsSigned(wantAssertionsSigned);
        }
        if ((wantAssertionsEncrypted = this.loadBooleanProperty(SECURITY_WANT_ASSERTIONS_ENCRYPTED)) != null) {
            this.saml2Setting.setWantAssertionsEncrypted(wantAssertionsEncrypted);
        }
        if ((wantNameId = this.loadBooleanProperty(SECURITY_WANT_NAMEID)) != null) {
            this.saml2Setting.setWantNameId(wantNameId);
        }
        if ((wantNameIdEncrypted = this.loadBooleanProperty(SECURITY_WANT_NAMEID_ENCRYPTED)) != null) {
            this.saml2Setting.setWantNameIdEncrypted(wantNameIdEncrypted);
        }
        if ((wantXMLValidation = this.loadBooleanProperty(SECURITY_WANT_XML_VALIDATION)) != null) {
            this.saml2Setting.setWantXMLValidation(wantXMLValidation);
        }
        if ((signMetadata = this.loadBooleanProperty(SECURITY_SIGN_METADATA)) != null) {
            this.saml2Setting.setSignMetadata(signMetadata);
        }
        if ((requestedAuthnContext = this.loadListProperty(SECURITY_REQUESTED_AUTHNCONTEXT)) != null) {
            this.saml2Setting.setRequestedAuthnContext(requestedAuthnContext);
        }
        if ((requestedAuthnContextComparison = this.loadStringProperty(SECURITY_REQUESTED_AUTHNCONTEXTCOMPARISON)) != null && !requestedAuthnContextComparison.isEmpty()) {
            this.saml2Setting.setRequestedAuthnContextComparison(requestedAuthnContextComparison);
        }
        if ((signatureAlgorithm = this.loadStringProperty(SECURITY_SIGNATURE_ALGORITHM)) != null && !signatureAlgorithm.isEmpty()) {
            this.saml2Setting.setSignatureAlgorithm(signatureAlgorithm);
        }
        if ((rejectUnsolicitedResponsesWithInResponseTo = this.loadBooleanProperty(SECURITY_REJECT_UNSOLICITED_RESPONSES_WITH_INRESPONSETO)) != null) {
            this.saml2Setting.setRejectUnsolicitedResponsesWithInResponseTo(rejectUnsolicitedResponsesWithInResponseTo);
        }
    }

    private Organization loadOrganization() {
        Organization orgResult = null;
        String orgName = this.loadStringProperty(ORGANIZATION_NAME);
        String orgDisplayName = this.loadStringProperty(ORGANIZATION_DISPLAYNAME);
        URL orgUrl = this.loadURLProperty(ORGANIZATION_URL);
        if (orgName != null && !orgName.isEmpty() || orgDisplayName != null && !orgDisplayName.isEmpty() || orgUrl != null) {
            orgResult = new Organization(orgName, orgDisplayName, orgUrl);
        }
        return orgResult;
    }

    private List<Contact> loadContacts() {
        LinkedList<Contact> contacts = new LinkedList<Contact>();
        String technicalGn = this.loadStringProperty(CONTACT_TECHNICAL_GIVEN_NAME);
        String technicalEmailAddress = this.loadStringProperty(CONTACT_TECHNICAL_EMAIL_ADDRESS);
        if (technicalGn != null && !technicalGn.isEmpty() || technicalEmailAddress != null && !technicalEmailAddress.isEmpty()) {
            Contact technical = new Contact("technical", technicalGn, technicalEmailAddress);
            contacts.add(technical);
        }
        String supportGn = this.loadStringProperty(CONTACT_SUPPORT_GIVEN_NAME);
        String supportEmailAddress = this.loadStringProperty(CONTACT_SUPPORT_EMAIL_ADDRESS);
        if (supportGn != null && !supportGn.isEmpty() || supportEmailAddress != null && !supportEmailAddress.isEmpty()) {
            Contact support = new Contact("support", supportGn, supportEmailAddress);
            contacts.add(support);
        }
        return contacts;
    }

    private void loadSpSetting() throws IOException {
        PrivateKey spPrivateKey;
        X509Certificate spX509cert;
        String spNameIDFormat;
        String spSingleLogoutServiceBinding;
        URL spSingleLogoutServiceUrl;
        String spAssertionConsumerServiceBinding;
        URL assertionConsumerServiceUrl;
        String spEntityID = this.loadStringProperty(SP_ENTITYID_PROPERTY_KEY);
        if (spEntityID != null) {
            this.saml2Setting.setSpEntityId(spEntityID);
        }
        if ((assertionConsumerServiceUrl = this.loadURLProperty(SP_ASSERTION_CONSUMER_SERVICE_URL_PROPERTY_KEY)) != null) {
            this.saml2Setting.setSpAssertionConsumerServiceUrl(assertionConsumerServiceUrl);
        }
        if ((spAssertionConsumerServiceBinding = this.loadStringProperty(SP_ASSERTION_CONSUMER_SERVICE_BINDING_PROPERTY_KEY)) != null) {
            this.saml2Setting.setSpAssertionConsumerServiceBinding(spAssertionConsumerServiceBinding);
        }
        if ((spSingleLogoutServiceUrl = this.loadURLProperty(SP_SINGLE_LOGOUT_SERVICE_URL_PROPERTY_KEY)) != null) {
            this.saml2Setting.setSpSingleLogoutServiceUrl(spSingleLogoutServiceUrl);
        }
        if ((spSingleLogoutServiceBinding = this.loadStringProperty(SP_SINGLE_LOGOUT_SERVICE_BINDING_PROPERTY_KEY)) != null) {
            this.saml2Setting.setSpSingleLogoutServiceBinding(spSingleLogoutServiceBinding);
        }
        if ((spNameIDFormat = this.loadStringProperty(SP_NAMEIDFORMAT_PROPERTY_KEY)) != null && !spNameIDFormat.isEmpty()) {
            this.saml2Setting.setSpNameIDFormat(spNameIDFormat);
        }
        if ((spX509cert = this.loadCertificateFromProp(SP_X509CERT_PROPERTY_KEY)) != null) {
            this.saml2Setting.setSpX509cert(spX509cert);
        }
        if ((spPrivateKey = this.loadPrivateKeyFromProp(SP_PRIVATEKEY_PROPERTY_KEY)) != null) {
            this.saml2Setting.setSpPrivateKey(spPrivateKey);
        }
    }

    private String loadStringProperty(String propertyKey) {
        String propValue = this.prop.getProperty(propertyKey);
        if (propValue != null) {
            propValue = propValue.trim();
        }
        return propValue;
    }

    private Boolean loadBooleanProperty(String propertyKey) {
        String booleanPropValue = this.prop.getProperty(propertyKey);
        if (booleanPropValue != null) {
            return Boolean.parseBoolean(booleanPropValue.trim());
        }
        return null;
    }

    private List<String> loadListProperty(String propertyKey) {
        String arrayPropValue = this.prop.getProperty(propertyKey);
        if (arrayPropValue != null && !arrayPropValue.isEmpty()) {
            String[] values = arrayPropValue.trim().split(",");
            for (int i = 0; i < values.length; ++i) {
                values[i] = values[i].trim();
            }
            return Arrays.asList(values);
        }
        return null;
    }

    private URL loadURLProperty(String propertyKey) {
        String urlPropValue = this.prop.getProperty(propertyKey);
        if (urlPropValue == null || urlPropValue.isEmpty()) {
            return null;
        }
        try {
            return new URL(urlPropValue.trim());
        }
        catch (MalformedURLException e) {
            LOGGER.error("'" + propertyKey + "' contains malformed url.", (Throwable)e);
            return null;
        }
    }

    protected X509Certificate loadCertificateFromProp(String propertyKey) {
        String certString = this.prop.getProperty(propertyKey);
        if (certString == null || certString.isEmpty()) {
            return null;
        }
        try {
            return Util.loadCert(certString);
        }
        catch (CertificateException e) {
            LOGGER.error("Error loading certificate from properties.", (Throwable)e);
            return null;
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("the certificate is not in correct format.", (Throwable)e);
            return null;
        }
    }

    protected PrivateKey loadPrivateKeyFromProp(String propertyKey) {
        String keyString = this.prop.getProperty(propertyKey);
        if (keyString == null || keyString.isEmpty()) {
            return null;
        }
        try {
            return Util.loadPrivateKey(keyString);
        }
        catch (Exception e) {
            LOGGER.error("Error loading privatekey from properties.", (Throwable)e);
            return null;
        }
    }
}

