/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.http;

import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.http.BaseRequest;
import com.onedrive.sdk.http.HttpMethod;
import com.onedrive.sdk.http.IHttpRequest;
import com.onedrive.sdk.http.IHttpStreamRequest;
import com.onedrive.sdk.options.HeaderOption;
import com.onedrive.sdk.options.Option;
import java.io.InputStream;
import java.net.URL;
import java.util.List;

public abstract class BaseStreamRequest<T>
implements IHttpStreamRequest {
    private final BaseRequest mBaseRequest;

    public BaseStreamRequest(String requestUrl, IOneDriveClient client, List<Option> options, Class<T> responseClass) {
        this.mBaseRequest = new BaseRequest(requestUrl, client, options, responseClass){};
    }

    protected void send(ICallback<InputStream> callback) {
        this.mBaseRequest.setHttpMethod(HttpMethod.GET);
        this.mBaseRequest.getClient().getHttpProvider().send((IHttpRequest)this, callback, InputStream.class, null);
    }

    protected InputStream send() throws ClientException {
        this.mBaseRequest.setHttpMethod(HttpMethod.GET);
        return this.mBaseRequest.getClient().getHttpProvider().send(this, InputStream.class, null);
    }

    protected void send(byte[] fileContents, ICallback<T> callback) {
        this.mBaseRequest.setHttpMethod(HttpMethod.PUT);
        this.mBaseRequest.getClient().getHttpProvider().send((IHttpRequest)this, callback, this.mBaseRequest.getResponseType(), fileContents);
    }

    protected T send(byte[] fileContents) {
        this.mBaseRequest.setHttpMethod(HttpMethod.PUT);
        return (T)this.mBaseRequest.getClient().getHttpProvider().send(this, this.mBaseRequest.getResponseType(), fileContents);
    }

    @Override
    public URL getRequestUrl() {
        return this.mBaseRequest.getRequestUrl();
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.mBaseRequest.getHttpMethod();
    }

    @Override
    public void addHeader(String header, String value) {
        this.mBaseRequest.addHeader(header, value);
    }

    @Override
    public List<HeaderOption> getHeaders() {
        return this.mBaseRequest.getHeaders();
    }

    @Override
    public List<Option> getOptions() {
        return this.mBaseRequest.getOptions();
    }
}

