/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.generated;

import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.onedrive.sdk.extensions.IdentitySet;
import com.onedrive.sdk.extensions.Item;
import com.onedrive.sdk.extensions.ItemCollectionPage;
import com.onedrive.sdk.generated.BaseItemCollectionResponse;
import com.onedrive.sdk.serializer.IJsonBackedObject;
import com.onedrive.sdk.serializer.ISerializer;
import java.util.Arrays;

public class BaseShare
implements IJsonBackedObject {
    @SerializedName(value="id")
    public String id;
    @SerializedName(value="name")
    public String name;
    @SerializedName(value="owner")
    public IdentitySet owner;
    public transient ItemCollectionPage items;
    private transient JsonObject mRawObject;
    private transient ISerializer mSerializer;

    public JsonObject getRawObject() {
        return this.mRawObject;
    }

    protected ISerializer getSerializer() {
        return this.mSerializer;
    }

    @Override
    public void setRawObject(ISerializer serializer, JsonObject json) {
        this.mSerializer = serializer;
        this.mRawObject = json;
        if (json.has("items")) {
            BaseItemCollectionResponse response = new BaseItemCollectionResponse();
            if (json.has("items@odata.nextLink")) {
                response.nextLink = json.get("items@odata.nextLink").getAsString();
            }
            JsonObject[] sourceArray = serializer.deserializeObject(json.get("items").toString(), JsonObject[].class);
            Item[] array = new Item[sourceArray.length];
            for (int i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), Item.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            this.items = new ItemCollectionPage(response, null);
        }
    }
}

