/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.extensions;

import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.core.OneDriveErrorCodes;
import com.onedrive.sdk.extensions.UploadSession;
import com.onedrive.sdk.http.OneDriveServiceException;

public class ChunkedUploadResult<UploadType> {
    private final UploadType mUploadedItem;
    private final UploadSession mSession;
    private final ClientException mError;

    public ChunkedUploadResult(UploadType uploaded) {
        this.mUploadedItem = uploaded;
        this.mSession = null;
        this.mError = null;
    }

    public ChunkedUploadResult(UploadSession session) {
        this.mSession = session;
        this.mUploadedItem = null;
        this.mError = null;
    }

    public ChunkedUploadResult(ClientException error) {
        this.mError = error;
        this.mUploadedItem = null;
        this.mSession = null;
    }

    public ChunkedUploadResult(OneDriveServiceException exception) {
        this(new ClientException(exception.getMessage(true), exception, OneDriveErrorCodes.UploadSessionFailed));
    }

    public boolean chunkCompleted() {
        return this.mUploadedItem != null || this.mSession != null;
    }

    public boolean uploadCompleted() {
        return this.mUploadedItem != null;
    }

    public boolean hasError() {
        return this.mError != null;
    }

    public UploadType getItem() {
        return this.mUploadedItem;
    }

    public UploadSession getSession() {
        return this.mSession;
    }

    public ClientException getError() {
        return this.mError;
    }
}

