/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.concurrency;

import com.onedrive.sdk.extensions.AsyncOperationStatus;
import com.onedrive.sdk.http.DefaultHttpProvider;
import com.onedrive.sdk.http.IConnection;
import com.onedrive.sdk.http.IHttpRequest;
import com.onedrive.sdk.http.IStatefulResponseHandler;
import com.onedrive.sdk.logger.ILogger;
import com.onedrive.sdk.serializer.ISerializer;
import java.io.BufferedInputStream;

public class AsyncMonitorResponseHandler
implements IStatefulResponseHandler<AsyncOperationStatus, String> {
    @Override
    public void configConnection(IConnection connection) {
        connection.setFollowRedirects(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncOperationStatus generateResult(IHttpRequest request, IConnection connection, ISerializer serializer, ILogger logger) throws Exception {
        if (connection.getResponseCode() == 303) {
            logger.logDebug("Item copy job has completed.");
            return AsyncOperationStatus.createdCompleted(connection.getHeaders().get("Location"));
        }
        try (BufferedInputStream in = null;){
            in = new BufferedInputStream(connection.getInputStream());
            AsyncOperationStatus result = serializer.deserializeObject(DefaultHttpProvider.streamToString(in), AsyncOperationStatus.class);
            result.seeOther = connection.getHeaders().get("Location");
            AsyncOperationStatus asyncOperationStatus = result;
            return asyncOperationStatus;
        }
    }
}

