/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.http;

import android.net.Uri;
import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.core.OneDriveErrorCodes;
import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.http.HttpMethod;
import com.onedrive.sdk.http.IHttpRequest;
import com.onedrive.sdk.options.HeaderOption;
import com.onedrive.sdk.options.Option;
import com.onedrive.sdk.options.QueryOption;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class BaseRequest
implements IHttpRequest {
    private static final String REQUEST_STATS_HEADER_NAME = "X-RequestStats";
    public static final String REQUEST_STATS_HEADER_VALUE_FORMAT_STRING = "SDK-Version=Android-v%s";
    private HttpMethod mMethod;
    private final String mRequestUrl;
    private final IOneDriveClient mClient;
    private final List<HeaderOption> mHeadersOptions;
    private final List<QueryOption> mQueryOptions;
    private final Class mResponseClass;

    public BaseRequest(String requestUrl, IOneDriveClient client, List<Option> options, Class responseClass) {
        this.mRequestUrl = requestUrl;
        this.mClient = client;
        this.mResponseClass = responseClass;
        this.mHeadersOptions = new ArrayList<HeaderOption>();
        this.mQueryOptions = new ArrayList<QueryOption>();
        if (options != null) {
            for (Option option : options) {
                if (option instanceof HeaderOption) {
                    this.mHeadersOptions.add((HeaderOption)option);
                }
                if (!(option instanceof QueryOption)) continue;
                this.mQueryOptions.add((QueryOption)option);
            }
        }
        HeaderOption requestStatsHeader = new HeaderOption(REQUEST_STATS_HEADER_NAME, String.format(REQUEST_STATS_HEADER_VALUE_FORMAT_STRING, "1.3.0"));
        this.mHeadersOptions.add(requestStatsHeader);
    }

    @Override
    public URL getRequestUrl() {
        Uri baseUrl = Uri.parse((String)this.mRequestUrl);
        Uri.Builder uriBuilder = new Uri.Builder().scheme(baseUrl.getScheme()).encodedAuthority(baseUrl.getEncodedAuthority()).encodedQuery(baseUrl.getEncodedQuery());
        for (String segment : baseUrl.getPathSegments()) {
            uriBuilder.appendPath(segment);
        }
        for (QueryOption option : this.mQueryOptions) {
            uriBuilder.appendQueryParameter(option.getName(), option.getValue());
        }
        String urlString = uriBuilder.build().toString();
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new ClientException("Invalid URL: " + urlString, e, OneDriveErrorCodes.InvalidRequest);
        }
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.mMethod;
    }

    @Override
    public List<HeaderOption> getHeaders() {
        return this.mHeadersOptions;
    }

    @Override
    public void addHeader(String header, String value) {
        this.mHeadersOptions.add(new HeaderOption(header, value));
    }

    protected <T1, T2> void send(HttpMethod method, ICallback<T1> callback, T2 serializedObject) {
        this.mMethod = method;
        this.mClient.getHttpProvider().send(this, callback, this.mResponseClass, serializedObject);
    }

    protected <T1, T2> T1 send(HttpMethod method, T2 serializedObject) throws ClientException {
        this.mMethod = method;
        return (T1)this.mClient.getHttpProvider().send(this, this.mResponseClass, serializedObject);
    }

    public List<QueryOption> getQueryOptions() {
        return this.mQueryOptions;
    }

    @Override
    public List<Option> getOptions() {
        LinkedList<Option> list = new LinkedList<Option>();
        list.addAll(this.mHeadersOptions);
        list.addAll(this.mQueryOptions);
        return Collections.unmodifiableList(list);
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.mMethod = httpMethod;
    }

    public IOneDriveClient getClient() {
        return this.mClient;
    }

    public Class getResponseType() {
        return this.mResponseClass;
    }
}

