/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.generated;

import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.concurrency.IExecutors;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.extensions.DriveCollectionPage;
import com.onedrive.sdk.extensions.DriveCollectionRequest;
import com.onedrive.sdk.extensions.DriveCollectionRequestBuilder;
import com.onedrive.sdk.extensions.IDriveCollectionPage;
import com.onedrive.sdk.extensions.IDriveCollectionRequest;
import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.generated.BaseDriveCollectionResponse;
import com.onedrive.sdk.generated.IBaseDriveCollectionRequest;
import com.onedrive.sdk.http.BaseCollectionRequest;
import com.onedrive.sdk.options.Option;
import com.onedrive.sdk.options.QueryOption;
import java.util.List;

public class BaseDriveCollectionRequest
extends BaseCollectionRequest<BaseDriveCollectionResponse, IDriveCollectionPage>
implements IBaseDriveCollectionRequest {
    public BaseDriveCollectionRequest(String requestUrl, IOneDriveClient client, List<Option> options) {
        super(requestUrl, client, options, BaseDriveCollectionResponse.class, IDriveCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDriveCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDriveCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDriveCollectionPage get() throws ClientException {
        BaseDriveCollectionResponse response = (BaseDriveCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public IDriveCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("expand", value));
        return (DriveCollectionRequest)this;
    }

    @Override
    public IDriveCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("select", value));
        return (DriveCollectionRequest)this;
    }

    @Override
    public IDriveCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("top", value + ""));
        return (DriveCollectionRequest)this;
    }

    public IDriveCollectionPage buildFromResponse(BaseDriveCollectionResponse response) {
        DriveCollectionRequestBuilder builder = response.nextLink != null ? new DriveCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DriveCollectionPage page = new DriveCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

