/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.generated;

import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.extensions.IPermissionRequest;
import com.onedrive.sdk.extensions.Permission;
import com.onedrive.sdk.extensions.PermissionRequest;
import com.onedrive.sdk.generated.IBasePermissionRequest;
import com.onedrive.sdk.http.BaseRequest;
import com.onedrive.sdk.http.HttpMethod;
import com.onedrive.sdk.options.Option;
import com.onedrive.sdk.options.QueryOption;
import java.util.List;

public class BasePermissionRequest
extends BaseRequest
implements IBasePermissionRequest {
    public BasePermissionRequest(String requestUrl, IOneDriveClient client, List<Option> options) {
        super(requestUrl, client, options, Permission.class);
    }

    @Override
    public void get(ICallback<Permission> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Permission get() throws ClientException {
        return (Permission)this.send(HttpMethod.GET, null);
    }

    @Override
    @Deprecated
    public void update(Permission sourcePermission, ICallback<Permission> callback) {
        this.patch(sourcePermission, callback);
    }

    @Override
    @Deprecated
    public Permission update(Permission sourcePermission) throws ClientException {
        return this.patch(sourcePermission);
    }

    @Override
    public void patch(Permission sourcePermission, ICallback<Permission> callback) {
        this.send(HttpMethod.PATCH, callback, sourcePermission);
    }

    @Override
    public Permission patch(Permission sourcePermission) throws ClientException {
        return (Permission)this.send(HttpMethod.PATCH, sourcePermission);
    }

    @Override
    public void delete(ICallback<Void> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    @Deprecated
    public void create(Permission newPermission, ICallback<Permission> callback) {
        this.post(newPermission, callback);
    }

    @Override
    @Deprecated
    public Permission create(Permission newPermission) throws ClientException {
        return this.post(newPermission);
    }

    @Override
    public void post(Permission newPermission, ICallback<Permission> callback) {
        this.send(HttpMethod.POST, callback, newPermission);
    }

    @Override
    public Permission post(Permission newPermission) throws ClientException {
        return (Permission)this.send(HttpMethod.POST, newPermission);
    }

    @Override
    public IPermissionRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("select", value));
        return (PermissionRequest)this;
    }

    @Override
    public IPermissionRequest top(int value) {
        this.getQueryOptions().add(new QueryOption("top", value + ""));
        return (PermissionRequest)this;
    }

    @Override
    public IPermissionRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("expand", value));
        return (PermissionRequest)this;
    }
}

