// ------------------------------------------------------------------------------
// Copyright (c) 2015 Microsoft Corporation
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
// ------------------------------------------------------------------------------

package com.onedrive.sdk.generated;

import com.onedrive.sdk.concurrency.*;
import com.onedrive.sdk.core.*;
import com.onedrive.sdk.extensions.*;
import com.onedrive.sdk.http.*;
import com.onedrive.sdk.generated.*;
import com.onedrive.sdk.options.*;
import com.onedrive.sdk.serializer.*;

import java.util.*;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base One Drive Client.
 */
public interface IBaseOneDriveClient extends IBaseClient {

    /**
     * Gets the collection of Drive objects.
     *
     * @return The request builder for the collection of Drive objects
     */
    IDriveCollectionRequestBuilder getDrives();

    /**
     * Gets a single Drive.
     *
     * @param id The id of the Drive to retrieve.
     * @return The request builder for the Drive object
     */
    IDriveRequestBuilder getDrive(final String id);

    /**
     * Gets the collection of Share objects.
     *
     * @return The request builder for the collection of Share objects
     */
    IShareCollectionRequestBuilder getShares();

    /**
     * Gets a single Share.
     *
     * @param id The id of the Share to retrieve.
     * @return The request builder for the Share object
     */
    IShareRequestBuilder getShare(final String id);

}
