// ------------------------------------------------------------------------------
// Copyright (c) 2015 Microsoft Corporation
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
// ------------------------------------------------------------------------------

package com.onedrive.sdk.generated;

import com.onedrive.sdk.concurrency.*;
import com.onedrive.sdk.core.*;
import com.onedrive.sdk.extensions.*;
import com.onedrive.sdk.http.*;
import com.onedrive.sdk.generated.*;
import com.onedrive.sdk.options.*;
import com.onedrive.sdk.serializer.*;

import java.util.*;

import com.google.gson.JsonObject;
import com.google.gson.annotations.*;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Audio.
 */
public class BaseAudio implements IJsonBackedObject {

    /**
     * The Album.
     */
    @SerializedName("album")
    public String album;

    /**
     * The Album Artist.
     */
    @SerializedName("albumArtist")
    public String albumArtist;

    /**
     * The Artist.
     */
    @SerializedName("artist")
    public String artist;

    /**
     * The Bitrate.
     */
    @SerializedName("bitrate")
    public Long bitrate;

    /**
     * The Composers.
     */
    @SerializedName("composers")
    public String composers;

    /**
     * The Copyright.
     */
    @SerializedName("copyright")
    public String copyright;

    /**
     * The Disc.
     */
    @SerializedName("disc")
    public Short disc;

    /**
     * The Disc Count.
     */
    @SerializedName("discCount")
    public Short discCount;

    /**
     * The Duration.
     */
    @SerializedName("duration")
    public Long duration;

    /**
     * The Genre.
     */
    @SerializedName("genre")
    public String genre;

    /**
     * The Has Drm.
     */
    @SerializedName("hasDrm")
    public Boolean hasDrm;

    /**
     * The Is Variable Bitrate.
     */
    @SerializedName("isVariableBitrate")
    public Boolean isVariableBitrate;

    /**
     * The Title.
     */
    @SerializedName("title")
    public String title;

    /**
     * The Track.
     */
    @SerializedName("track")
    public Integer track;

    /**
     * The Track Count.
     */
    @SerializedName("trackCount")
    public Integer trackCount;

    /**
     * The Year.
     */
    @SerializedName("year")
    public Integer year;


    /**
     * The raw representation of this class
     */
    private transient JsonObject mRawObject;

    /**
     * The serializer
     */
    private transient ISerializer mSerializer;

    /**
     * Gets the raw representation of this class
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return mRawObject;
    }

    /**
     * Gets serializer
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return mSerializer;
    }

    /**
     * Sets the raw json object
     *
     * @param serializer The serializer
     * @param json The json object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        mSerializer = serializer;
        mRawObject = json;

    }
}
