// ------------------------------------------------------------------------------
// Copyright (c) 2015 Microsoft Corporation
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
// ------------------------------------------------------------------------------

package com.onedrive.sdk.generated;

import com.onedrive.sdk.concurrency.*;
import com.onedrive.sdk.core.*;
import com.onedrive.sdk.extensions.*;
import com.onedrive.sdk.http.*;
import com.onedrive.sdk.generated.*;
import com.onedrive.sdk.options.*;
import com.onedrive.sdk.serializer.*;

import java.util.*;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Drive Request.
 */
public class BaseDriveRequest extends BaseRequest implements IBaseDriveRequest {

    /**
     * The request for the Drive
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     */
    public BaseDriveRequest(String requestUrl, IOneDriveClient client, List<Option> options) {
        super(requestUrl, client, options, Drive.class);
    }

    public void get(final ICallback<Drive> callback) {
        send(HttpMethod.GET, callback, null);
    }

    public Drive get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * @deprecated  As of release 1.1.3, replaced by {@link #patch(Drive, ICallback)}
     */
    @Deprecated public void update(final Drive sourceDrive, final ICallback<Drive> callback) {
        this.patch(sourceDrive, callback);
    }

    /**
     * @deprecated  As of release 1.1.3, replaced by {@link #patch(Drive)}
     */
    @Deprecated public Drive update(final Drive sourceDrive) throws ClientException {
        return this.patch(sourceDrive);
    }

    public void patch(final Drive sourceDrive, final ICallback<Drive> callback) {
        send(HttpMethod.PATCH, callback, sourceDrive);
    }

    public Drive patch(final Drive sourceDrive) throws ClientException {
        return send(HttpMethod.PATCH, sourceDrive);
    }

    public void delete(final ICallback<Void> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * @deprecated  As of release 1.1.3, replaced by {@link #post(Drive, ICallback)}
     */
    @Deprecated public void create(final Drive newDrive, final ICallback<Drive> callback) {
        this.post(newDrive, callback);
    }

    /**
     * @deprecated  As of release 1.1.3, replaced by {@link #post(Drive)}
     */
    @Deprecated public Drive create(final Drive newDrive) throws ClientException {
        return this.post(newDrive);
    }

    public void post(final Drive newDrive, final ICallback<Drive> callback) {
        send(HttpMethod.POST, callback, newDrive);
    }

    public Drive post(final Drive newDrive) throws ClientException {
        return send(HttpMethod.POST, newDrive);
    }

    public IDriveRequest select(final String value) {
        getQueryOptions().add(new QueryOption("select", value));
        return (DriveRequest)this;
    }

    public IDriveRequest top(final int value) {
        getQueryOptions().add(new QueryOption("top", value+""));
        return (DriveRequest)this;
    }

    public IDriveRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("expand", value));
        return (DriveRequest)this;
    }
}
