/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.generated;

import com.onedrive.sdk.concurrency.AsyncMonitor;
import com.onedrive.sdk.concurrency.AsyncMonitorLocation;
import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.concurrency.ResultGetter;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.extensions.CopyBody;
import com.onedrive.sdk.extensions.CopyRequest;
import com.onedrive.sdk.extensions.ICopyRequest;
import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.extensions.Item;
import com.onedrive.sdk.extensions.ItemReference;
import com.onedrive.sdk.extensions.ItemRequest;
import com.onedrive.sdk.generated.IBaseCopyRequest;
import com.onedrive.sdk.http.BaseRequest;
import com.onedrive.sdk.http.HttpMethod;
import com.onedrive.sdk.options.Option;
import com.onedrive.sdk.options.QueryOption;
import java.util.List;

public class BaseCopyRequest
extends BaseRequest
implements IBaseCopyRequest {
    protected final CopyBody mBody = new CopyBody();

    public BaseCopyRequest(String requestUrl, IOneDriveClient client, List<Option> options, String name, ItemReference parentReference) {
        super(requestUrl, client, options, AsyncMonitorLocation.class);
        this.mBody.name = name;
        this.mBody.parentReference = parentReference;
        this.addHeader("Prefer", "respond-async");
    }

    @Override
    @Deprecated
    public void create(ICallback<AsyncMonitor<Item>> callback) {
        this.post(callback);
    }

    @Override
    @Deprecated
    public AsyncMonitor<Item> create() throws ClientException {
        return this.post();
    }

    @Override
    public void post(final ICallback<AsyncMonitor<Item>> callback) {
        this.getClient().getExecutors().performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    BaseCopyRequest.this.getClient().getExecutors().performOnForeground(BaseCopyRequest.this.post(), callback);
                }
                catch (ClientException e) {
                    BaseCopyRequest.this.getClient().getExecutors().performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public AsyncMonitor<Item> post() throws ClientException {
        AsyncMonitorLocation monitorLocation = (AsyncMonitorLocation)this.send(HttpMethod.POST, this.mBody);
        return new AsyncMonitor<Item>(this.getClient(), monitorLocation, new ResultGetter<Item>(){

            @Override
            public Item getResultFrom(String resourceUrl, IOneDriveClient client) {
                return new ItemRequest(resourceUrl, client, null).get();
            }
        });
    }

    @Override
    public ICopyRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("select", value));
        return (CopyRequest)this;
    }

    @Override
    public ICopyRequest top(int value) {
        this.getQueryOptions().add(new QueryOption("top", value + ""));
        return (CopyRequest)this;
    }

    @Override
    public ICopyRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("expand", value));
        return (CopyRequest)this;
    }
}

