/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.core;

import com.onedrive.sdk.authentication.IAuthenticator;
import com.onedrive.sdk.concurrency.IExecutors;
import com.onedrive.sdk.core.IBaseClient;
import com.onedrive.sdk.http.IHttpProvider;
import com.onedrive.sdk.logger.ILogger;
import com.onedrive.sdk.serializer.ISerializer;

public class BaseClient
implements IBaseClient {
    private IAuthenticator mAuthenticator;
    private IExecutors mExecutors;
    private IHttpProvider mHttpProvider;
    private ILogger mLogger;
    private ISerializer mSerializer;

    @Override
    public IAuthenticator getAuthenticator() {
        return this.mAuthenticator;
    }

    @Override
    public String getServiceRoot() {
        return this.getAuthenticator().getAccountInfo().getServiceRoot();
    }

    @Override
    public IExecutors getExecutors() {
        return this.mExecutors;
    }

    @Override
    public IHttpProvider getHttpProvider() {
        return this.mHttpProvider;
    }

    @Override
    public ILogger getLogger() {
        return this.mLogger;
    }

    @Override
    public ISerializer getSerializer() {
        return this.mSerializer;
    }

    @Override
    public void validate() {
        if (this.mAuthenticator == null) {
            throw new NullPointerException("Authenticator");
        }
        if (this.mExecutors == null) {
            throw new NullPointerException("Executors");
        }
        if (this.mHttpProvider == null) {
            throw new NullPointerException("HttpProvider");
        }
        if (this.mSerializer == null) {
            throw new NullPointerException("Serializer");
        }
    }

    protected void setLogger(ILogger logger) {
        this.mLogger = logger;
    }

    protected void setExecutors(IExecutors executors) {
        this.mExecutors = executors;
    }

    protected void setAuthenticator(IAuthenticator authenticator) {
        this.mAuthenticator = authenticator;
    }

    protected void setHttpProvider(IHttpProvider httpProvider) {
        this.mHttpProvider = httpProvider;
    }

    public void setSerializer(ISerializer serializer) {
        this.mSerializer = serializer;
    }
}

