/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.generated;

import com.onedrive.sdk.extensions.AllPhotosRequestBuilder;
import com.onedrive.sdk.extensions.DriveRequest;
import com.onedrive.sdk.extensions.IAllPhotosRequestBuilder;
import com.onedrive.sdk.extensions.IDriveRequest;
import com.onedrive.sdk.extensions.IItemRequestBuilder;
import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.extensions.ItemRequestBuilder;
import com.onedrive.sdk.generated.IBaseDriveRequestBuilder;
import com.onedrive.sdk.http.BaseRequestBuilder;
import com.onedrive.sdk.options.Option;
import java.util.List;

public class BaseDriveRequestBuilder
extends BaseRequestBuilder
implements IBaseDriveRequestBuilder {
    public BaseDriveRequestBuilder(String requestUrl, IOneDriveClient client, List<Option> options) {
        super(requestUrl, client, options);
    }

    @Override
    public IDriveRequest buildRequest() {
        return this.buildRequest(this.getOptions());
    }

    @Override
    public IDriveRequest buildRequest(List<Option> options) {
        return new DriveRequest(this.getRequestUrl(), this.getClient(), options);
    }

    @Override
    public IItemRequestBuilder getItems(String id) {
        return new ItemRequestBuilder(this.getRequestUrlWithAdditionalSegment("items") + "/" + id, this.getClient(), null);
    }

    @Override
    public IItemRequestBuilder getShared(String id) {
        return new ItemRequestBuilder(this.getRequestUrlWithAdditionalSegment("shared") + "/" + id, this.getClient(), null);
    }

    @Override
    public IItemRequestBuilder getSpecial(String id) {
        return new ItemRequestBuilder(this.getRequestUrlWithAdditionalSegment("special") + "/" + id, this.getClient(), null);
    }

    @Override
    public IAllPhotosRequestBuilder getAllPhotos() {
        return new AllPhotosRequestBuilder(this.getRequestUrlWithAdditionalSegment("view.allPhotos"), this.getClient(), null);
    }
}

