/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.generated;

import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.extensions.IThumbnailRequest;
import com.onedrive.sdk.extensions.Thumbnail;
import com.onedrive.sdk.extensions.ThumbnailRequest;
import com.onedrive.sdk.generated.IBaseThumbnailRequest;
import com.onedrive.sdk.http.BaseRequest;
import com.onedrive.sdk.http.HttpMethod;
import com.onedrive.sdk.options.Option;
import com.onedrive.sdk.options.QueryOption;
import java.util.List;

public class BaseThumbnailRequest
extends BaseRequest
implements IBaseThumbnailRequest {
    public BaseThumbnailRequest(String requestUrl, IOneDriveClient client, List<Option> options) {
        super(requestUrl, client, options, Thumbnail.class);
    }

    @Override
    public void get(ICallback<Thumbnail> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Thumbnail get() throws ClientException {
        return (Thumbnail)this.send(HttpMethod.GET, null);
    }

    @Override
    @Deprecated
    public void update(Thumbnail sourceThumbnail, ICallback<Thumbnail> callback) {
        this.patch(sourceThumbnail, callback);
    }

    @Override
    @Deprecated
    public Thumbnail update(Thumbnail sourceThumbnail) throws ClientException {
        return this.patch(sourceThumbnail);
    }

    @Override
    public void patch(Thumbnail sourceThumbnail, ICallback<Thumbnail> callback) {
        this.send(HttpMethod.PATCH, callback, sourceThumbnail);
    }

    @Override
    public Thumbnail patch(Thumbnail sourceThumbnail) throws ClientException {
        return (Thumbnail)this.send(HttpMethod.PATCH, sourceThumbnail);
    }

    @Override
    public void delete(ICallback<Void> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    @Deprecated
    public void create(Thumbnail newThumbnail, ICallback<Thumbnail> callback) {
        this.post(newThumbnail, callback);
    }

    @Override
    @Deprecated
    public Thumbnail create(Thumbnail newThumbnail) throws ClientException {
        return this.post(newThumbnail);
    }

    @Override
    public void post(Thumbnail newThumbnail, ICallback<Thumbnail> callback) {
        this.send(HttpMethod.POST, callback, newThumbnail);
    }

    @Override
    public Thumbnail post(Thumbnail newThumbnail) throws ClientException {
        return (Thumbnail)this.send(HttpMethod.POST, newThumbnail);
    }

    @Override
    public IThumbnailRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("select", value));
        return (ThumbnailRequest)this;
    }

    @Override
    public IThumbnailRequest top(int value) {
        this.getQueryOptions().add(new QueryOption("top", value + ""));
        return (ThumbnailRequest)this;
    }

    @Override
    public IThumbnailRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("expand", value));
        return (ThumbnailRequest)this;
    }
}

