/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.authentication;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.onedrive.sdk.authentication.ClientAuthenticatorException;
import com.onedrive.sdk.authentication.DisambiguationRequest;
import com.onedrive.sdk.authentication.DisambiguationWebView;
import com.onedrive.sdk.core.OneDriveErrorCodes;
import com.onedrive.sdk.logger.ILogger;

class DisambiguationDialog
extends Dialog
implements DialogInterface.OnCancelListener {
    private static final String DISAMBIGUATION_PAGE_URL = "https://onedrive.live.com/picker/accountchooser?ru=https://localhost:777&load_login=false";
    private final DisambiguationRequest mRequest;

    public DisambiguationDialog(Context context, DisambiguationRequest request) {
        super(context, 0x1030010);
        this.mRequest = request;
    }

    public ILogger getLogger() {
        return this.mRequest.getLogger();
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.mRequest.getLogger().logDebug("Disambiguation dialog canceled");
        this.mRequest.getCallback().failure(new ClientAuthenticatorException("Authentication Disambiguation Canceled", OneDriveErrorCodes.AuthenticationCancelled));
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setOnCancelListener(this);
        FrameLayout content = new FrameLayout(this.getContext());
        LinearLayout webViewContainer = new LinearLayout(this.getContext());
        WebView webView = new WebView(this.getContext());
        webView.setWebViewClient((WebViewClient)new DisambiguationWebView(this, this.mRequest.getCallback()));
        WebSettings webSettings = webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webView.loadUrl(DISAMBIGUATION_PAGE_URL);
        ViewGroup.LayoutParams matchParentLayout = new ViewGroup.LayoutParams(-1, -1);
        webView.setLayoutParams(matchParentLayout);
        webView.setVisibility(0);
        webViewContainer.addView((View)webView);
        webViewContainer.setVisibility(0);
        content.addView((View)webViewContainer);
        content.setVisibility(0);
        content.forceLayout();
        webViewContainer.forceLayout();
        this.addContentView((View)content, matchParentLayout);
    }
}

