/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.authentication;

import android.app.Activity;
import com.onedrive.sdk.authentication.ADALAuthenticator;
import com.onedrive.sdk.authentication.ClientAuthenticatorException;
import com.onedrive.sdk.authentication.DisambiguationRequest;
import com.onedrive.sdk.authentication.DisambiguationResponse;
import com.onedrive.sdk.authentication.IAccountInfo;
import com.onedrive.sdk.authentication.IAuthenticator;
import com.onedrive.sdk.authentication.MSAAuthenticator;
import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.concurrency.IExecutors;
import com.onedrive.sdk.concurrency.SimpleWaiter;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.core.OneDriveErrorCodes;
import com.onedrive.sdk.http.IHttpProvider;
import com.onedrive.sdk.logger.ILogger;
import java.security.InvalidParameterException;
import java.util.concurrent.atomic.AtomicReference;

public class DisambiguationAuthenticator
implements IAuthenticator {
    private final AtomicReference<IAccountInfo> mAccountInfo = new AtomicReference();
    private final MSAAuthenticator mMSAAuthenticator;
    private final ADALAuthenticator mADALAuthenticator;
    private IExecutors mExecutors;
    private Activity mActivity;
    private boolean mInitialized;
    private ILogger mLogger;

    public DisambiguationAuthenticator(MSAAuthenticator msaAuthenticator, ADALAuthenticator adalAuthenticator) {
        this.mMSAAuthenticator = msaAuthenticator;
        this.mADALAuthenticator = adalAuthenticator;
    }

    @Override
    public synchronized void init(IExecutors executors, IHttpProvider httpProvider, Activity activity, ILogger logger) {
        if (this.mInitialized) {
            return;
        }
        this.mExecutors = executors;
        this.mActivity = activity;
        this.mLogger = logger;
        this.mLogger.logDebug("Initializing MSA and ADAL authenticators");
        this.mMSAAuthenticator.init(executors, httpProvider, activity, logger);
        this.mADALAuthenticator.init(executors, httpProvider, activity, logger);
        this.mInitialized = true;
    }

    @Override
    public void login(final String emailAddressHint, final ICallback<IAccountInfo> loginCallback) {
        if (!this.mInitialized) {
            throw new IllegalStateException("init must be called");
        }
        if (loginCallback == null) {
            throw new InvalidParameterException("loginCallback");
        }
        this.mLogger.logDebug("Starting login async");
        this.mExecutors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    DisambiguationAuthenticator.this.mExecutors.performOnForeground(DisambiguationAuthenticator.this.login(emailAddressHint), loginCallback);
                }
                catch (ClientException e) {
                    DisambiguationAuthenticator.this.mExecutors.performOnForeground(e, loginCallback);
                }
            }
        });
    }

    @Override
    public synchronized IAccountInfo login(String emailAddressHint) throws ClientException {
        IAccountInfo accountInfo;
        this.mLogger.logDebug("Starting login");
        final SimpleWaiter disambiguationWaiter = new SimpleWaiter();
        final AtomicReference response = new AtomicReference();
        final AtomicReference error = new AtomicReference();
        ICallback<DisambiguationResponse> disambiguationCallback = new ICallback<DisambiguationResponse>(){

            @Override
            public void success(DisambiguationResponse result) {
                DisambiguationAuthenticator.this.mLogger.logDebug(String.format("Successfully disambiguated '%s' as account type '%s'", new Object[]{result.getAccount(), result.getAccountType()}));
                response.set(result);
                disambiguationWaiter.signal();
            }

            @Override
            public void failure(ClientException error2) {
                error.set(new ClientAuthenticatorException("Unable to disambiguate account type", OneDriveErrorCodes.AuthenticationFailure));
                DisambiguationAuthenticator.this.mLogger.logError(((ClientException)error.get()).getMessage(), (Throwable)error.get());
                disambiguationWaiter.signal();
            }
        };
        this.mLogger.logDebug("Creating disambiguation ui, waiting for user to sign in");
        new DisambiguationRequest(this.mActivity, disambiguationCallback, this.mLogger).execute();
        disambiguationWaiter.waitForSignal();
        if (error.get() != null) {
            throw (ClientException)error.get();
        }
        DisambiguationResponse disambiguationResponse = (DisambiguationResponse)response.get();
        switch (disambiguationResponse.getAccountType()) {
            case ActiveDirectory: {
                accountInfo = this.mADALAuthenticator.login(disambiguationResponse.getAccount());
                break;
            }
            case MicrosoftAccount: {
                accountInfo = this.mMSAAuthenticator.login(disambiguationResponse.getAccount());
                break;
            }
            default: {
                UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("Unrecognized account type " + (Object)((Object)disambiguationResponse.getAccountType()));
                this.mLogger.logError("Unrecognized account type", unsupportedOperationException);
                throw unsupportedOperationException;
            }
        }
        this.mAccountInfo.set(accountInfo);
        return this.mAccountInfo.get();
    }

    @Override
    public void loginSilent(final ICallback<IAccountInfo> loginCallback) {
        if (!this.mInitialized) {
            throw new IllegalStateException("init must be called");
        }
        if (loginCallback == null) {
            throw new InvalidParameterException("loginCallback");
        }
        this.mLogger.logDebug("Starting login silent async");
        this.mExecutors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    DisambiguationAuthenticator.this.mExecutors.performOnForeground(DisambiguationAuthenticator.this.loginSilent(), loginCallback);
                }
                catch (ClientException e) {
                    DisambiguationAuthenticator.this.mExecutors.performOnForeground(e, loginCallback);
                }
            }
        });
    }

    @Override
    public synchronized IAccountInfo loginSilent() throws ClientException {
        if (!this.mInitialized) {
            throw new IllegalStateException("init must be called");
        }
        this.mLogger.logDebug("Starting login silent");
        this.mLogger.logDebug("Checking MSA");
        IAccountInfo accountInfo = this.mMSAAuthenticator.loginSilent();
        if (accountInfo != null) {
            this.mLogger.logDebug("Found account info in MSA");
            this.mAccountInfo.set(accountInfo);
            return accountInfo;
        }
        this.mLogger.logDebug("Checking ADAL");
        accountInfo = this.mADALAuthenticator.loginSilent();
        this.mAccountInfo.set(accountInfo);
        if (accountInfo != null) {
            this.mLogger.logDebug("Found account info in ADAL");
        }
        return accountInfo;
    }

    @Override
    public void logout(final ICallback<Void> logoutCallback) {
        if (!this.mInitialized) {
            throw new IllegalStateException("init must be called");
        }
        if (logoutCallback == null) {
            throw new InvalidParameterException("logoutCallback");
        }
        this.mLogger.logDebug("Starting logout async");
        this.mExecutors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                DisambiguationAuthenticator.this.logout();
                DisambiguationAuthenticator.this.mExecutors.performOnForeground((Void)null, logoutCallback);
            }
        });
    }

    @Override
    public synchronized void logout() throws ClientException {
        if (!this.mInitialized) {
            throw new IllegalStateException("init must be called");
        }
        this.mLogger.logDebug("Starting logout");
        if (this.mMSAAuthenticator.getAccountInfo() != null) {
            this.mLogger.logDebug("Starting logout of MSA account");
            this.mMSAAuthenticator.logout();
        } else if (this.mADALAuthenticator.getAccountInfo() != null) {
            this.mLogger.logDebug("Starting logout of ADAL account");
            this.mADALAuthenticator.logout();
        }
    }

    @Override
    public IAccountInfo getAccountInfo() {
        return this.mAccountInfo.get();
    }
}

