/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.generated;

import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.extensions.IItemRequest;
import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.extensions.Item;
import com.onedrive.sdk.extensions.ItemRequest;
import com.onedrive.sdk.generated.IBaseItemRequest;
import com.onedrive.sdk.http.BaseRequest;
import com.onedrive.sdk.http.HttpMethod;
import com.onedrive.sdk.options.Option;
import com.onedrive.sdk.options.QueryOption;
import java.util.List;

public class BaseItemRequest
extends BaseRequest
implements IBaseItemRequest {
    public BaseItemRequest(String requestUrl, IOneDriveClient client, List<Option> options) {
        super(requestUrl, client, options, Item.class);
    }

    @Override
    public void get(ICallback<Item> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Item get() throws ClientException {
        return (Item)this.send(HttpMethod.GET, null);
    }

    @Override
    public void update(Item sourceItem, ICallback<Item> callback) {
        this.send(HttpMethod.PATCH, callback, sourceItem);
    }

    @Override
    public Item update(Item sourceItem) throws ClientException {
        return (Item)this.send(HttpMethod.PATCH, sourceItem);
    }

    @Override
    public void delete(ICallback<Void> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void create(Item newItem, ICallback<Item> callback) {
        this.send(HttpMethod.POST, callback, newItem);
    }

    @Override
    public Item create(Item newItem) throws ClientException {
        return (Item)this.send(HttpMethod.POST, newItem);
    }

    @Override
    public IItemRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("select", value));
        return (ItemRequest)this;
    }

    @Override
    public IItemRequest top(int value) {
        this.getQueryOptions().add(new QueryOption("top", value + ""));
        return (ItemRequest)this;
    }

    @Override
    public IItemRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("expand", value));
        return (ItemRequest)this;
    }
}

