/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.generated;

import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.concurrency.IExecutors;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.extensions.ISharedWithMeCollectionPage;
import com.onedrive.sdk.extensions.ISharedWithMeRequest;
import com.onedrive.sdk.extensions.SharedWithMeCollectionPage;
import com.onedrive.sdk.extensions.SharedWithMeRequest;
import com.onedrive.sdk.extensions.SharedWithMeRequestBuilder;
import com.onedrive.sdk.generated.BaseSharedWithMeCollectionResponse;
import com.onedrive.sdk.generated.IBaseSharedWithMeRequest;
import com.onedrive.sdk.http.BaseCollectionRequest;
import com.onedrive.sdk.options.Option;
import com.onedrive.sdk.options.QueryOption;
import java.util.List;

public class BaseSharedWithMeRequest
extends BaseCollectionRequest<BaseSharedWithMeCollectionResponse, ISharedWithMeCollectionPage>
implements IBaseSharedWithMeRequest {
    public BaseSharedWithMeRequest(String requestUrl, IOneDriveClient client, List<Option> options) {
        super(requestUrl, client, options, BaseSharedWithMeCollectionResponse.class, ISharedWithMeCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ISharedWithMeCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseSharedWithMeRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISharedWithMeCollectionPage get() throws ClientException {
        BaseSharedWithMeCollectionResponse response = (BaseSharedWithMeCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public ISharedWithMeRequest select(String value) {
        this.addQueryOption(new QueryOption("select", value));
        return (SharedWithMeRequest)this;
    }

    @Override
    public ISharedWithMeRequest top(int value) {
        this.addQueryOption(new QueryOption("top", value + ""));
        return (SharedWithMeRequest)this;
    }

    @Override
    public ISharedWithMeRequest expand(String value) {
        this.addQueryOption(new QueryOption("expand", value));
        return (SharedWithMeRequest)this;
    }

    public ISharedWithMeCollectionPage buildFromResponse(BaseSharedWithMeCollectionResponse response) {
        SharedWithMeRequestBuilder builder = response.nextLink != null ? new SharedWithMeRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SharedWithMeCollectionPage page = new SharedWithMeCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

