/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.http;

import com.onedrive.sdk.http.IConnection;
import com.onedrive.sdk.http.IHttpRequest;
import com.onedrive.sdk.options.HeaderOption;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.Map;

public class UrlConnection
implements IConnection {
    private final HttpURLConnection mConnection;
    private HashMap<String, String> mHeaders;

    public UrlConnection(IHttpRequest request) throws IOException {
        this.mConnection = (HttpURLConnection)request.getRequestUrl().openConnection();
        for (HeaderOption header : request.getHeaders()) {
            this.mConnection.addRequestProperty(header.getName(), header.getValue());
        }
        this.mConnection.setRequestMethod(request.getHttpMethod().toString());
    }

    @Override
    public void setFollowRedirects(boolean followRedirects) {
        this.mConnection.setInstanceFollowRedirects(followRedirects);
    }

    @Override
    public void addRequestHeader(String headerName, String headerValue) {
        this.mConnection.addRequestProperty(headerName, headerValue);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        int defaultBufferSize = 4096;
        this.mConnection.setDoOutput(true);
        this.mConnection.setChunkedStreamingMode(4096);
        return this.mConnection.getOutputStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        int httpClientErrorResponseCode = 400;
        if (this.mConnection.getResponseCode() >= 400) {
            return this.mConnection.getErrorStream();
        }
        return this.mConnection.getInputStream();
    }

    @Override
    public int getResponseCode() throws IOException {
        return this.mConnection.getResponseCode();
    }

    @Override
    public String getResponseMessage() throws IOException {
        return this.mConnection.getResponseMessage();
    }

    @Override
    public void close() {
        this.mConnection.disconnect();
    }

    @Override
    public Map<String, String> getHeaders() {
        if (this.mHeaders == null) {
            this.mHeaders = UrlConnection.getResponseHeaders(this.mConnection);
        }
        return this.mHeaders;
    }

    @Override
    public String getRequestMethod() {
        return this.mConnection.getRequestMethod();
    }

    private static HashMap<String, String> getResponseHeaders(HttpURLConnection connection) {
        HashMap<String, String> headers = new HashMap<String, String>();
        int index = 0;
        while (true) {
            String headerName = connection.getHeaderFieldKey(index);
            String headerValue = connection.getHeaderField(index);
            if (headerName == null && headerValue == null) break;
            headers.put(headerName, headerValue);
            ++index;
        }
        return headers;
    }
}

