/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.generated;

import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.concurrency.IExecutors;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.extensions.IRecentCollectionPage;
import com.onedrive.sdk.extensions.IRecentRequest;
import com.onedrive.sdk.extensions.RecentCollectionPage;
import com.onedrive.sdk.extensions.RecentRequest;
import com.onedrive.sdk.extensions.RecentRequestBuilder;
import com.onedrive.sdk.generated.BaseRecentCollectionResponse;
import com.onedrive.sdk.generated.IBaseRecentRequest;
import com.onedrive.sdk.http.BaseCollectionRequest;
import com.onedrive.sdk.options.Option;
import com.onedrive.sdk.options.QueryOption;
import java.util.List;

public class BaseRecentRequest
extends BaseCollectionRequest<BaseRecentCollectionResponse, IRecentCollectionPage>
implements IBaseRecentRequest {
    public BaseRecentRequest(String requestUrl, IOneDriveClient client, List<Option> options) {
        super(requestUrl, client, options, BaseRecentCollectionResponse.class, IRecentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IRecentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseRecentRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IRecentCollectionPage get() throws ClientException {
        BaseRecentCollectionResponse response = (BaseRecentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public IRecentRequest select(String value) {
        this.addQueryOption(new QueryOption("select", value));
        return (RecentRequest)this;
    }

    @Override
    public IRecentRequest top(int value) {
        this.addQueryOption(new QueryOption("top", value + ""));
        return (RecentRequest)this;
    }

    @Override
    public IRecentRequest expand(String value) {
        this.addQueryOption(new QueryOption("expand", value));
        return (RecentRequest)this;
    }

    public IRecentCollectionPage buildFromResponse(BaseRecentCollectionResponse response) {
        RecentRequestBuilder builder = response.nextLink != null ? new RecentRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        RecentCollectionPage page = new RecentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

