/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.generated;

import com.onedrive.sdk.concurrency.ICallback;
import com.onedrive.sdk.core.ClientException;
import com.onedrive.sdk.extensions.Drive;
import com.onedrive.sdk.extensions.DriveRequest;
import com.onedrive.sdk.extensions.IDriveRequest;
import com.onedrive.sdk.extensions.IOneDriveClient;
import com.onedrive.sdk.generated.IBaseDriveRequest;
import com.onedrive.sdk.http.BaseRequest;
import com.onedrive.sdk.http.HttpMethod;
import com.onedrive.sdk.options.Option;
import com.onedrive.sdk.options.QueryOption;
import java.util.List;

public class BaseDriveRequest
extends BaseRequest
implements IBaseDriveRequest {
    public BaseDriveRequest(String requestUrl, IOneDriveClient client, List<Option> options) {
        super(requestUrl, client, options, Drive.class);
    }

    @Override
    public void get(ICallback<Drive> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Drive get() throws ClientException {
        return (Drive)this.send(HttpMethod.GET, null);
    }

    @Override
    public void update(Drive sourceDrive, ICallback<Drive> callback) {
        this.send(HttpMethod.PATCH, callback, sourceDrive);
    }

    @Override
    public Drive update(Drive sourceDrive) throws ClientException {
        return (Drive)this.send(HttpMethod.PATCH, sourceDrive);
    }

    @Override
    public void delete(ICallback<Void> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void create(Drive newDrive, ICallback<Drive> callback) {
        this.send(HttpMethod.POST, callback, newDrive);
    }

    @Override
    public Drive create(Drive newDrive) throws ClientException {
        return (Drive)this.send(HttpMethod.POST, newDrive);
    }

    @Override
    public IDriveRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("select", value));
        return (DriveRequest)this;
    }

    @Override
    public IDriveRequest top(int value) {
        this.getQueryOptions().add(new QueryOption("top", value + ""));
        return (DriveRequest)this;
    }

    @Override
    public IDriveRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("expand", value));
        return (DriveRequest)this;
    }
}

