/*
 * Decompiled with CFR 0.152.
 */
package com.onedrive.sdk.authentication;

import com.microsoft.services.msa.LiveConnectSession;
import com.onedrive.sdk.authentication.AccountType;
import com.onedrive.sdk.authentication.IAccountInfo;
import com.onedrive.sdk.authentication.MSAAuthenticator;
import com.onedrive.sdk.logger.ILogger;

public class MSAAccountInfo
implements IAccountInfo {
    public static final String ONE_DRIVE_PERSONAL_SERVICE_ROOT = "https://api.onedrive.com/v1.0";
    private final MSAAuthenticator mAuthenticator;
    private LiveConnectSession mSession;
    private final ILogger mLogger;

    public MSAAccountInfo(MSAAuthenticator authenticator, LiveConnectSession liveConnectSession, ILogger logger) {
        this.mAuthenticator = authenticator;
        this.mSession = liveConnectSession;
        this.mLogger = logger;
    }

    @Override
    public AccountType getAccountType() {
        return AccountType.MicrosoftAccount;
    }

    @Override
    public String getAccessToken() {
        return this.mSession.getAccessToken();
    }

    @Override
    public String getServiceRoot() {
        return ONE_DRIVE_PERSONAL_SERVICE_ROOT;
    }

    @Override
    public boolean isExpired() {
        return this.mSession.isExpired();
    }

    @Override
    public void refresh() {
        this.mLogger.logDebug("Refreshing access token...");
        MSAAccountInfo newInfo = (MSAAccountInfo)this.mAuthenticator.loginSilent();
        this.mSession = newInfo.mSession;
    }
}

