/*
 * Decompiled with CFR 0.152.
 */
package com.olekdia.androidcollection;

import com.olekdia.androidcollection.ArrayHelper;

public class LongKeySparseArray<E>
implements Cloneable {
    private static final Object DELETED = new Object();
    private boolean mGarbage = false;
    private long[] mKeys;
    private Object[] mValues;
    private int mSize;

    public LongKeySparseArray() {
        this(10);
    }

    public LongKeySparseArray(int initialCapacity) {
        if (initialCapacity == 0) {
            this.mKeys = ArrayHelper.EMPTY_LONGS;
            this.mValues = ArrayHelper.EMPTY_OBJECTS;
        } else {
            initialCapacity = ArrayHelper.idealIntArraySize(initialCapacity);
            this.mKeys = new long[initialCapacity];
            this.mValues = new Object[initialCapacity];
        }
        this.mSize = 0;
    }

    public LongKeySparseArray<E> clone() {
        LongKeySparseArray clone = null;
        try {
            clone = (LongKeySparseArray)super.clone();
            clone.mKeys = (long[])this.mKeys.clone();
            clone.mValues = (Object[])this.mValues.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public final E get(long key) {
        return this.get(key, null);
    }

    public final E get(long key, E valueIfKeyNotFound) {
        int i = ArrayHelper.binarySearch(this.mKeys, this.mSize, key);
        if (i < 0 || this.mValues[i] == DELETED) {
            return valueIfKeyNotFound;
        }
        return (E)this.mValues[i];
    }

    public final boolean delete(long key) {
        int i = ArrayHelper.binarySearch(this.mKeys, this.mSize, key);
        if (i >= 0 && this.mValues[i] != DELETED) {
            this.mValues[i] = DELETED;
            this.mGarbage = true;
            return true;
        }
        return false;
    }

    public final void remove(long key) {
        this.delete(key);
    }

    public final void removeAt(int index) {
        if (this.mValues[index] != DELETED) {
            this.mValues[index] = DELETED;
            this.mGarbage = true;
        }
    }

    public final void removeAtRange(int index, int size) {
        int end = Math.min(this.mSize, index + size);
        for (int i = index; i < end; ++i) {
            this.removeAt(i);
        }
    }

    private void gc() {
        int n = this.mSize;
        int o = 0;
        long[] keys = this.mKeys;
        Object[] values = this.mValues;
        for (int i = 0; i < n; ++i) {
            Object val = values[i];
            if (val == DELETED) continue;
            if (i != o) {
                keys[o] = keys[i];
                values[o] = val;
                values[i] = null;
            }
            ++o;
        }
        this.mGarbage = false;
        this.mSize = o;
    }

    public final void put(long key, E value) {
        int i = ArrayHelper.binarySearch(this.mKeys, this.mSize, key);
        if (i >= 0) {
            this.mValues[i] = value;
        } else {
            if ((i ^= 0xFFFFFFFF) < this.mSize && this.mValues[i] == DELETED) {
                this.mKeys[i] = key;
                this.mValues[i] = value;
                return;
            }
            if (this.mGarbage && this.mSize >= this.mKeys.length) {
                this.gc();
                i = ~ArrayHelper.binarySearch(this.mKeys, this.mSize, key);
            }
            if (this.mSize >= this.mKeys.length) {
                this.expandToCapacity(ArrayHelper.idealIntArraySize(this.mSize + 1));
            }
            if (this.mSize - i != 0) {
                System.arraycopy(this.mKeys, i, this.mKeys, i + 1, this.mSize - i);
                System.arraycopy(this.mValues, i, this.mValues, i + 1, this.mSize - i);
            }
            this.mKeys[i] = key;
            this.mValues[i] = value;
            ++this.mSize;
        }
    }

    public final int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public final long keyAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[index];
    }

    public final E valueAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[index];
    }

    public final void setValueAt(int index, E value) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[index] = value;
    }

    public final int indexOfKey(long key) {
        if (this.mGarbage) {
            this.gc();
        }
        return ArrayHelper.binarySearch(this.mKeys, this.mSize, key);
    }

    public final int indexOfValue(E value) {
        if (this.mGarbage) {
            this.gc();
        }
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i] != value) continue;
            return i;
        }
        return -1;
    }

    public final int indexOfEqualValue(E value) {
        if (this.mGarbage) {
            this.gc();
        }
        if (value == null) {
            for (int i = 0; i < this.mSize; ++i) {
                if (this.mValues[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.mSize; ++i) {
                if (!value.equals(this.mValues[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public final void clear() {
        int n = this.mSize;
        Object[] values = this.mValues;
        for (int i = 0; i < n; ++i) {
            values[i] = null;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    public final void append(long key, E value) {
        int pos;
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, value);
            return;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        if ((pos = this.mSize) >= this.mKeys.length) {
            this.expandToCapacity(ArrayHelper.idealIntArraySize(pos + 1));
        }
        this.mKeys[pos] = key;
        this.mValues[pos] = value;
        this.mSize = pos + 1;
    }

    public final void ensureCapacity(int capacity) {
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        if (this.mKeys.length < capacity) {
            this.expandToCapacity(capacity);
        }
    }

    private void expandToCapacity(int capacity) {
        long[] nkeys = new long[capacity];
        Object[] nvalues = new Object[capacity];
        System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
        System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
        this.mKeys = nkeys;
        this.mValues = nvalues;
    }
}

