/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.oauth.env;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.http.ResponseEntity;

public class OIDCMetadata {
    private boolean isAuth0;
    private static final String clientAuthenticationMethod = "none";
    private static final String scope = "profile,email,openid";
    private final String jwkSetURI;
    private final String authorizationURI;
    private final String tokenURI;
    private final String userInfoURI;
    private final String introspectionURI;

    public boolean isAuth0() {
        return this.isAuth0;
    }

    public String getClientAuthenticationMethod() {
        return clientAuthenticationMethod;
    }

    public String getScope() {
        return scope;
    }

    public String getJwkSetURI() {
        return this.jwkSetURI;
    }

    public String getAuthorizationURI() {
        return this.authorizationURI;
    }

    public String getTokenURI() {
        return this.tokenURI;
    }

    public String getUserInfoURI() {
        return this.userInfoURI;
    }

    public String getIntrospectionURI() {
        return this.introspectionURI;
    }

    public OIDCMetadata(String issuerWithPathKey) {
        this.jwkSetURI = "${" + issuerWithPathKey + "}/v1/keys";
        this.authorizationURI = "${" + issuerWithPathKey + "}/v1/authorize";
        this.tokenURI = "${" + issuerWithPathKey + "}/v1/token";
        this.userInfoURI = "${" + issuerWithPathKey + "}/v1/userinfo";
        this.introspectionURI = "${" + issuerWithPathKey + "}/v1/introspect";
    }

    public OIDCMetadata(ResponseEntity<String> response) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode root = mapper.readTree((String)response.getBody());
        if (root.has("introspection_endpoint") && !root.path("introspection_endpoint").isNull()) {
            this.introspectionURI = root.path("introspection_endpoint").asText();
        } else {
            this.introspectionURI = null;
            this.isAuth0 = true;
        }
        this.jwkSetURI = root.path("jwks_uri").asText();
        this.authorizationURI = root.path("authorization_endpoint").asText();
        this.tokenURI = root.path("token_endpoint").asText();
        this.userInfoURI = root.path("userinfo_endpoint").asText();
    }
}

