/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.oauth;

import com.okta.spring.boot.oauth.AuthoritiesProvider;
import com.okta.spring.boot.oauth.UserUtil;
import com.okta.spring.boot.oauth.http.UserAgentRequestInterceptor;
import java.util.Collection;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.client.userinfo.DefaultOAuth2UserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

final class OktaOAuth2UserService
extends DefaultOAuth2UserService {
    private final Collection<AuthoritiesProvider> authoritiesProviders;

    OktaOAuth2UserService(Collection<AuthoritiesProvider> authoritiesProviders) {
        this.authoritiesProviders = authoritiesProviders;
        this.setRestOperations(this.restOperations());
    }

    private RestOperations restOperations() {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler());
        restTemplate.getInterceptors().add(new UserAgentRequestInterceptor());
        return restTemplate;
    }

    public OAuth2User loadUser(OAuth2UserRequest userRequest) {
        OAuth2User user = super.loadUser(userRequest);
        return UserUtil.decorateUser(user, userRequest, this.authoritiesProviders);
    }
}

