/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.oauth;

import com.okta.spring.boot.oauth.UserUtil;
import com.okta.spring.boot.oauth.WebClientUtil;
import org.springframework.security.oauth2.client.userinfo.DefaultReactiveOAuth2UserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.core.user.OAuth2User;
import reactor.core.publisher.Mono;

final class ReactiveOktaOAuth2UserService
extends DefaultReactiveOAuth2UserService {
    private final String groupClaim;

    ReactiveOktaOAuth2UserService(String groupClaim) {
        this.groupClaim = groupClaim;
        this.setWebClient(WebClientUtil.createWebClient());
    }

    public Mono<OAuth2User> loadUser(OAuth2UserRequest userRequest) {
        return super.loadUser(userRequest).map(user -> UserUtil.decorateUser(user, userRequest, this.groupClaim));
    }
}

