/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.oauth;

import com.okta.spring.boot.oauth.ConditionalOnOktaClientProperties;
import com.okta.spring.boot.oauth.config.OktaOAuth2Properties;
import java.net.URI;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.oauth2.client.oidc.web.logout.OidcClientInitiatedLogoutSuccessHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;

@Configuration
@ConditionalOnOktaClientProperties
@EnableConfigurationProperties(value={OktaOAuth2Properties.class})
@ConditionalOnClass(value={EnableWebSecurity.class, ClientRegistration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
class OktaOAuth2AutoConfig {
    OktaOAuth2AutoConfig() {
    }

    @Bean
    @ConditionalOnProperty(name={"okta.oauth2.postLogoutRedirectUri"})
    OidcClientInitiatedLogoutSuccessHandler oidcLogoutSuccessHandler(OktaOAuth2Properties oktaOAuth2Properties, ClientRegistrationRepository clientRegistrationRepository) {
        OidcClientInitiatedLogoutSuccessHandler successHandler = new OidcClientInitiatedLogoutSuccessHandler(clientRegistrationRepository);
        successHandler.setPostLogoutRedirectUri(URI.create(oktaOAuth2Properties.getPostLogoutRedirectUri()));
        return successHandler;
    }
}

