/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.sdk.env;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

final class OktaSdkPropertiesEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    OktaSdkPropertiesEnvironmentPostProcessor() {
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        environment.getPropertySources().addLast(this.loadYaml((Resource)new FileSystemResource(new File(System.getProperty("user.home"), ".okta/okta.yml")), false));
        environment.getPropertySources().addLast(this.loadYaml((Resource)new FileSystemResource(new File(System.getProperty("user.home"), ".okta/okta.yaml")), false));
    }

    private PropertySource<?> loadYaml(Resource resource, boolean required) {
        YamlPropertySourceLoader loader = new YamlPropertySourceLoader();
        if (!resource.exists() && required) {
            throw new IllegalArgumentException("Resource " + resource + " does not exist");
        }
        if (resource.exists()) {
            try {
                List list = loader.load(resource.getFilename(), resource);
                return (PropertySource)list.get(0);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Failed to load yaml configuration from " + resource, ex);
            }
        }
        return new MapPropertySource("Missing " + resource.getFilename(), Collections.emptyMap());
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

