/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.builder;

import com.okta.sdk.client.Client;
import com.okta.sdk.impl.resource.builder.DefaultIdentityProviderBuilder;
import com.okta.sdk.resource.IdentityProvider;
import com.okta.sdk.resource.IdentityProviderCredentials;
import com.okta.sdk.resource.IdentityProviderCredentialsClient;
import com.okta.sdk.resource.IdentityProviderPolicy;
import com.okta.sdk.resource.IssuerMode;
import com.okta.sdk.resource.PolicyAccountLink;
import com.okta.sdk.resource.PolicyAccountLinkAction;
import com.okta.sdk.resource.PolicySubject;
import com.okta.sdk.resource.PolicySubjectMatchType;
import com.okta.sdk.resource.PolicyUserNameTemplate;
import com.okta.sdk.resource.Protocol;
import com.okta.sdk.resource.ProtocolAlgorithmType;
import com.okta.sdk.resource.ProtocolAlgorithmTypeSignature;
import com.okta.sdk.resource.ProtocolAlgorithmTypeSignatureScope;
import com.okta.sdk.resource.ProtocolAlgorithms;
import com.okta.sdk.resource.ProtocolEndpoint;
import com.okta.sdk.resource.ProtocolEndpointBinding;
import com.okta.sdk.resource.ProtocolEndpointType;
import com.okta.sdk.resource.ProtocolEndpoints;
import com.okta.sdk.resource.ProtocolType;
import com.okta.sdk.resource.Provisioning;
import com.okta.sdk.resource.ProvisioningAction;
import com.okta.sdk.resource.ProvisioningConditions;
import com.okta.sdk.resource.ProvisioningDeprovisionedAction;
import com.okta.sdk.resource.ProvisioningDeprovisionedCondition;
import com.okta.sdk.resource.ProvisioningGroups;
import com.okta.sdk.resource.ProvisioningGroupsAction;
import com.okta.sdk.resource.ProvisioningSuspendedAction;
import com.okta.sdk.resource.ProvisioningSuspendedCondition;
import com.okta.sdk.resource.builder.OIDCIdentityProviderBuilder;

public class OidcIdentityProviderBuilder
extends DefaultIdentityProviderBuilder<OIDCIdentityProviderBuilder>
implements OIDCIdentityProviderBuilder {
    private IssuerMode issuerMode;
    private String requestSignatureAlgorithm;
    private ProtocolAlgorithmTypeSignatureScope requestSignatureScope;
    private String responseSignatureAlgorithm;
    private ProtocolAlgorithmTypeSignatureScope responseSignatureScope;
    private ProtocolEndpointBinding acsEndpointBinding;
    private ProtocolEndpointType acsEndpointType;
    private ProtocolEndpointBinding authorizationEndpointBinding;
    private String authorizationEndpointUrl;
    private ProtocolEndpointBinding tokenEndpointBinding;
    private String tokenEndpointUrl;
    private ProtocolEndpointBinding userInfoEndpointBinding;
    private String userInfoEndpointUrl;
    private ProtocolEndpointBinding jwksEndpointBinding;
    private String jwksEndpointUrl;
    private String issuerUrl;
    private String userName;
    private PolicySubjectMatchType matchType;

    public OidcIdentityProviderBuilder setIssuerMode(IssuerMode issuerMode) {
        this.issuerMode = issuerMode;
        return this;
    }

    public OidcIdentityProviderBuilder setRequestSignatureAlgorithm(String requestSignatureAlgorithm) {
        this.requestSignatureAlgorithm = requestSignatureAlgorithm;
        return this;
    }

    public OidcIdentityProviderBuilder setRequestSignatureScope(ProtocolAlgorithmTypeSignatureScope requestSignatureScope) {
        this.requestSignatureScope = requestSignatureScope;
        return this;
    }

    public OidcIdentityProviderBuilder setResponseSignatureAlgorithm(String responseSignatureAlgorithm) {
        this.responseSignatureAlgorithm = responseSignatureAlgorithm;
        return this;
    }

    public OidcIdentityProviderBuilder setResponseSignatureScope(ProtocolAlgorithmTypeSignatureScope responseSignatureScope) {
        this.responseSignatureScope = responseSignatureScope;
        return this;
    }

    public OidcIdentityProviderBuilder setAcsEndpointBinding(ProtocolEndpointBinding acsEndpointBinding) {
        this.acsEndpointBinding = acsEndpointBinding;
        return this;
    }

    public OidcIdentityProviderBuilder setAcsEndpointType(ProtocolEndpointType acsEndpointType) {
        this.acsEndpointType = acsEndpointType;
        return this;
    }

    public OidcIdentityProviderBuilder setAuthorizationEndpointBinding(ProtocolEndpointBinding authorizationEndpointBinding) {
        this.authorizationEndpointBinding = authorizationEndpointBinding;
        return this;
    }

    public OidcIdentityProviderBuilder setAuthorizationEndpointUrl(String authorizationEndpointUrl) {
        this.authorizationEndpointUrl = authorizationEndpointUrl;
        return this;
    }

    public OidcIdentityProviderBuilder setTokenEndpointBinding(ProtocolEndpointBinding tokenEndpointBinding) {
        this.tokenEndpointBinding = tokenEndpointBinding;
        return this;
    }

    public OidcIdentityProviderBuilder setTokenEndpointUrl(String tokenEndpointUrl) {
        this.tokenEndpointUrl = tokenEndpointUrl;
        return this;
    }

    public OidcIdentityProviderBuilder setUserInfoEndpointBinding(ProtocolEndpointBinding userInfoEndpointBinding) {
        this.userInfoEndpointBinding = userInfoEndpointBinding;
        return this;
    }

    public OidcIdentityProviderBuilder setUserInfoEndpointUrl(String userInfoEndpointUrl) {
        this.userInfoEndpointUrl = userInfoEndpointUrl;
        return this;
    }

    public OidcIdentityProviderBuilder setJwksEndpointBinding(ProtocolEndpointBinding jwksEndpointBinding) {
        this.jwksEndpointBinding = jwksEndpointBinding;
        return this;
    }

    public OidcIdentityProviderBuilder setJwksEndpointUrl(String jwksEndpointUrl) {
        this.jwksEndpointUrl = jwksEndpointUrl;
        return this;
    }

    public OidcIdentityProviderBuilder setIssuerUrl(String issuerUrl) {
        this.issuerUrl = issuerUrl;
        return this;
    }

    @Override
    public OidcIdentityProviderBuilder setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    @Override
    public OidcIdentityProviderBuilder setMatchType(PolicySubjectMatchType matchType) {
        this.matchType = matchType;
        return this;
    }

    @Override
    public IdentityProvider buildAndCreate(Client client) {
        return client.createIdentityProvider(((IdentityProvider)client.instantiate(IdentityProvider.class)).setType("OIDC").setName(this.name).setIssuerMode(this.issuerMode).setProtocol(((Protocol)client.instantiate(Protocol.class)).setAlgorithms(((ProtocolAlgorithms)client.instantiate(ProtocolAlgorithms.class)).setRequest(((ProtocolAlgorithmType)client.instantiate(ProtocolAlgorithmType.class)).setSignature(((ProtocolAlgorithmTypeSignature)client.instantiate(ProtocolAlgorithmTypeSignature.class)).setAlgorithm(this.requestSignatureAlgorithm).setScope(this.requestSignatureScope))).setResponse(((ProtocolAlgorithmType)client.instantiate(ProtocolAlgorithmType.class)).setSignature(((ProtocolAlgorithmTypeSignature)client.instantiate(ProtocolAlgorithmTypeSignature.class)).setAlgorithm(this.responseSignatureAlgorithm).setScope(this.responseSignatureScope)))).setEndpoints(((ProtocolEndpoints)client.instantiate(ProtocolEndpoints.class)).setAcs(((ProtocolEndpoint)client.instantiate(ProtocolEndpoint.class)).setBinding(this.acsEndpointBinding).setType(this.acsEndpointType)).setAuthorization(((ProtocolEndpoint)client.instantiate(ProtocolEndpoint.class)).setBinding(this.authorizationEndpointBinding).setUrl(this.authorizationEndpointUrl)).setToken(((ProtocolEndpoint)client.instantiate(ProtocolEndpoint.class)).setBinding(this.tokenEndpointBinding).setUrl(this.tokenEndpointUrl)).setUserInfo(((ProtocolEndpoint)client.instantiate(ProtocolEndpoint.class)).setBinding(this.userInfoEndpointBinding).setUrl(this.userInfoEndpointUrl)).setJwks(((ProtocolEndpoint)client.instantiate(ProtocolEndpoint.class)).setBinding(this.jwksEndpointBinding).setUrl(this.jwksEndpointUrl))).setScopes(this.scopes).setType(ProtocolType.OIDC).setCredentials(((IdentityProviderCredentials)client.instantiate(IdentityProviderCredentials.class)).setClient(((IdentityProviderCredentialsClient)client.instantiate(IdentityProviderCredentialsClient.class)).setClientId(this.clientId).setClientSecret(this.clientSecret))).setIssuer(((ProtocolEndpoint)client.instantiate(ProtocolEndpoint.class)).setUrl(this.issuerUrl))).setPolicy(((IdentityProviderPolicy)client.instantiate(IdentityProviderPolicy.class)).setAccountLink(((PolicyAccountLink)client.instantiate(PolicyAccountLink.class)).setAction(PolicyAccountLinkAction.AUTO).setFilter(null)).setProvisioning(((Provisioning)client.instantiate(Provisioning.class)).setAction(ProvisioningAction.AUTO).setConditions(((ProvisioningConditions)client.instantiate(ProvisioningConditions.class)).setDeprovisioned(((ProvisioningDeprovisionedCondition)client.instantiate(ProvisioningDeprovisionedCondition.class)).setAction(ProvisioningDeprovisionedAction.NONE)).setSuspended(((ProvisioningSuspendedCondition)client.instantiate(ProvisioningSuspendedCondition.class)).setAction(ProvisioningSuspendedAction.NONE))).setGroups(((ProvisioningGroups)client.instantiate(ProvisioningGroups.class)).setAction(ProvisioningGroupsAction.NONE))).setMaxClockSkew(this.maxClockSkew).setSubject(((PolicySubject)client.instantiate(PolicySubject.class)).setUserNameTemplate(((PolicyUserNameTemplate)client.instantiate(PolicyUserNameTemplate.class)).setTemplate(this.userName)).setMatchType(this.matchType))));
    }
}

