/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.builder;

import com.okta.sdk.client.Client;
import com.okta.sdk.resource.LifecycleStatus;
import com.okta.sdk.resource.Policy;
import com.okta.sdk.resource.PolicyRule;
import com.okta.sdk.resource.PolicyRuleType;
import com.okta.sdk.resource.builder.PolicyRuleBuilder;
import java.util.Objects;

public class DefaultPolicyRuleBuilder<T extends PolicyRuleBuilder>
implements PolicyRuleBuilder<T> {
    protected Integer priority;
    protected PolicyRuleType type = PolicyRuleType.SIGN_ON;
    protected LifecycleStatus status;

    DefaultPolicyRuleBuilder() {
    }

    public T setPriority(Integer priority) {
        this.priority = priority;
        return this.self();
    }

    public T setStatus(LifecycleStatus status) {
        this.status = status;
        return this.self();
    }

    public T setType(PolicyRuleType type) {
        this.type = type;
        return this.self();
    }

    public PolicyRule buildAndCreate(Client client, Policy policy) {
        return client.createPolicyRule(this.build(client), policy.getId());
    }

    protected T self() {
        return (T)this;
    }

    private PolicyRule build(Client client) {
        PolicyRule policyRule = (PolicyRule)client.instantiate(PolicyRule.class);
        if (Objects.nonNull(this.priority)) {
            policyRule.setPriority(this.priority);
        }
        if (Objects.nonNull(this.status)) {
            policyRule.setStatus(this.status);
        }
        if (Objects.nonNull(this.type)) {
            policyRule.setType(this.type);
        }
        return policyRule;
    }
}

