/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.builder;

import com.okta.commons.lang.Collections;
import com.okta.commons.lang.Strings;
import com.okta.sdk.client.Client;
import com.okta.sdk.impl.resource.builder.DefaultPolicyBuilder;
import com.okta.sdk.resource.GroupCondition;
import com.okta.sdk.resource.OktaSignOnPolicy;
import com.okta.sdk.resource.OktaSignOnPolicyConditions;
import com.okta.sdk.resource.Policy;
import com.okta.sdk.resource.PolicyPeopleCondition;
import com.okta.sdk.resource.PolicyType;
import com.okta.sdk.resource.UserCondition;
import com.okta.sdk.resource.builder.OktaSignOnPolicyBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DefaultOktaSignOnPolicyBuilder
extends DefaultPolicyBuilder<OktaSignOnPolicyBuilder>
implements OktaSignOnPolicyBuilder {
    private List<String> groupIds = new ArrayList<String>();
    private List<String> userIds = new ArrayList<String>();

    public OktaSignOnPolicyBuilder setGroups(List<String> groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    public OktaSignOnPolicyBuilder addGroup(String groupId) {
        this.groupIds.add(groupId);
        return this;
    }

    public OktaSignOnPolicyBuilder setUsers(List<String> userIds) {
        this.userIds = userIds;
        return this;
    }

    public OktaSignOnPolicyBuilder addUser(String userId) {
        this.userIds.add(userId);
        return this;
    }

    public OktaSignOnPolicy buildAndCreate(Client client) {
        return (OktaSignOnPolicy)client.createPolicy((Policy)this.build(client), this.isActive);
    }

    private OktaSignOnPolicy build(Client client) {
        OktaSignOnPolicy policy = (OktaSignOnPolicy)client.instantiate(OktaSignOnPolicy.class);
        if (Strings.hasText((String)this.name)) {
            policy.setName(this.name);
        }
        if (Strings.hasText((String)this.description)) {
            policy.setDescription(this.description);
        }
        if (this.priority != null) {
            policy.setPriority(this.priority);
        }
        if (!PolicyType.OKTA_SIGN_ON.equals((Object)this.policyType)) {
            throw new IllegalArgumentException("PolicyType should be 'OKTA_SIGN_ON', please use PolicyBuilder for other policy types.");
        }
        policy.setType(this.policyType);
        if (Objects.nonNull(this.status)) {
            policy.setStatus(this.status);
        }
        policy.setConditions((OktaSignOnPolicyConditions)client.instantiate(OktaSignOnPolicyConditions.class));
        OktaSignOnPolicyConditions oktaSignOnPolicyConditions = policy.getConditions();
        if (!Collections.isEmpty(this.groupIds)) {
            oktaSignOnPolicyConditions.setPeople(((PolicyPeopleCondition)client.instantiate(PolicyPeopleCondition.class)).setGroups(((GroupCondition)client.instantiate(GroupCondition.class)).setInclude(this.groupIds)));
        }
        if (!Collections.isEmpty(this.userIds)) {
            oktaSignOnPolicyConditions.setPeople(((PolicyPeopleCondition)client.instantiate(PolicyPeopleCondition.class)).setUsers(((UserCondition)client.instantiate(UserCondition.class)).setInclude(this.userIds)));
        }
        return policy;
    }
}

