/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.builder;

import com.okta.commons.lang.Collections;
import com.okta.commons.lang.Strings;
import com.okta.sdk.client.Client;
import com.okta.sdk.resource.GroupRule;
import com.okta.sdk.resource.GroupRuleAction;
import com.okta.sdk.resource.GroupRuleConditions;
import com.okta.sdk.resource.GroupRuleExpression;
import com.okta.sdk.resource.GroupRuleGroupAssignment;
import com.okta.sdk.resource.GroupRuleGroupCondition;
import com.okta.sdk.resource.GroupRulePeopleCondition;
import com.okta.sdk.resource.GroupRuleUserCondition;
import com.okta.sdk.resource.builder.GroupRuleBuilder;
import java.util.ArrayList;
import java.util.List;

public class DefaultGroupRuleBuilder
implements GroupRuleBuilder {
    private String name;
    private String type;
    private List<String> assignUserToGroups = new ArrayList<String>();
    private List<String> groupIds = new ArrayList<String>();
    private List<String> userIds = new ArrayList<String>();
    private String groupRuleExpressionType;
    private String groupRuleExpressionValue;

    public GroupRuleBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public GroupRuleBuilder setType(String type) {
        this.type = type;
        return this;
    }

    public GroupRuleBuilder setAssignUserToGroups(List<String> assignUserToGroups) {
        this.assignUserToGroups = assignUserToGroups;
        return this;
    }

    public GroupRuleBuilder setGroups(List<String> groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    public GroupRuleBuilder addGroup(String groupId) {
        this.groupIds.add(groupId);
        return this;
    }

    public GroupRuleBuilder setUsers(List<String> userIds) {
        this.userIds = userIds;
        return this;
    }

    public GroupRuleBuilder addUser(String userId) {
        this.userIds.add(userId);
        return this;
    }

    public GroupRuleBuilder setGroupRuleExpressionType(String groupRuleExpressionType) {
        this.groupRuleExpressionType = groupRuleExpressionType;
        return this;
    }

    public GroupRuleBuilder setGroupRuleExpressionValue(String groupRuleExpressionValue) {
        this.groupRuleExpressionValue = groupRuleExpressionValue;
        return this;
    }

    public GroupRule buildAndCreate(Client client) {
        return client.createGroupRule(this.build(client));
    }

    private GroupRule build(Client client) {
        GroupRule groupRule = (GroupRule)client.instantiate(GroupRule.class);
        if (Strings.hasText((String)this.name)) {
            groupRule.setName(this.name);
        }
        if (Strings.hasText((String)this.type)) {
            groupRule.setType(this.type);
        }
        groupRule.setActions((GroupRuleAction)client.instantiate(GroupRuleAction.class));
        GroupRuleAction groupRuleActions = groupRule.getActions();
        if (!Collections.isEmpty(this.assignUserToGroups)) {
            groupRuleActions.setAssignUserToGroups(((GroupRuleGroupAssignment)client.instantiate(GroupRuleGroupAssignment.class)).setGroupIds(this.assignUserToGroups));
        }
        groupRule.setConditions((GroupRuleConditions)client.instantiate(GroupRuleConditions.class));
        GroupRuleConditions groupRuleConditions = groupRule.getConditions();
        GroupRulePeopleCondition groupRulePeopleCondition = (GroupRulePeopleCondition)client.instantiate(GroupRulePeopleCondition.class);
        if (!Collections.isEmpty(this.groupIds)) {
            groupRuleConditions.setPeople(groupRulePeopleCondition.setGroups(((GroupRuleGroupCondition)client.instantiate(GroupRuleGroupCondition.class)).setInclude(this.groupIds)));
        }
        if (!Collections.isEmpty(this.userIds)) {
            groupRuleConditions.setPeople(groupRulePeopleCondition.setUsers(((GroupRuleUserCondition)client.instantiate(GroupRuleUserCondition.class)).setInclude(this.userIds)));
        }
        GroupRuleExpression groupRuleExpression = (GroupRuleExpression)client.instantiate(GroupRuleExpression.class);
        if (Strings.hasText((String)this.groupRuleExpressionType)) {
            groupRuleConditions.setExpression(groupRuleExpression.setType(this.groupRuleExpressionType));
        }
        if (Strings.hasText((String)this.groupRuleExpressionValue)) {
            groupRuleConditions.setExpression(groupRuleExpression.setValue(this.groupRuleExpressionValue));
        }
        return groupRule;
    }
}

