/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.builder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.okta.sdk.client.Client;
import com.okta.sdk.resource.EventHook;
import com.okta.sdk.resource.EventHookChannel;
import com.okta.sdk.resource.EventHookChannelConfig;
import com.okta.sdk.resource.EventHookChannelConfigAuthScheme;
import com.okta.sdk.resource.EventHookChannelConfigAuthSchemeType;
import com.okta.sdk.resource.EventHookChannelConfigHeader;
import com.okta.sdk.resource.EventHookChannelType;
import com.okta.sdk.resource.EventSubscriptionType;
import com.okta.sdk.resource.EventSubscriptions;
import com.okta.sdk.resource.builder.EventHookBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class DefaultEventHookBuilder
implements EventHookBuilder {
    private static final String LIFECYCLE_EVENT_CREATE = "user.lifecycle.create";
    private static final String LIFECYCLE_EVENT_ACTIVATE = "user.lifecycle.activate";
    private static final String VERSION = "1.0.0";
    private String name;
    private String url;
    private String authorizationHeaderValue;
    private Map<String, String> headerMap = Maps.newHashMap();

    public EventHookBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public EventHookBuilder setUrl(String url) {
        this.url = url;
        return this;
    }

    public EventHookBuilder setAuthorizationHeaderValue(String authorizationHeaderValue) {
        this.authorizationHeaderValue = authorizationHeaderValue;
        return this;
    }

    public EventHookBuilder addHeader(String name, String value) {
        this.headerMap.put(name, value);
        return this;
    }

    public EventHook buildAndCreate(Client client) {
        EventSubscriptions eventSubscriptions = ((EventSubscriptions)client.instantiate(EventSubscriptions.class)).setType(EventSubscriptionType.EVENT_TYPE).setItems(Arrays.asList(LIFECYCLE_EVENT_CREATE, LIFECYCLE_EVENT_ACTIVATE));
        EventHookChannelConfigAuthScheme eventHookChannelConfigAuthScheme = ((EventHookChannelConfigAuthScheme)client.instantiate(EventHookChannelConfigAuthScheme.class)).setType(EventHookChannelConfigAuthSchemeType.HEADER).setKey("Authorization").setValue(this.authorizationHeaderValue);
        ArrayList headers = Lists.newArrayList();
        for (Map.Entry<String, String> entry : this.headerMap.entrySet()) {
            headers.add(((EventHookChannelConfigHeader)client.instantiate(EventHookChannelConfigHeader.class)).setKey(entry.getKey()).setValue(entry.getValue()));
        }
        EventHookChannelConfig eventHookChannelConfig = ((EventHookChannelConfig)client.instantiate(EventHookChannelConfig.class)).setUri(this.url).setHeaders((List)headers).setAuthScheme(eventHookChannelConfigAuthScheme);
        EventHookChannel eventHookChannel = ((EventHookChannel)client.instantiate(EventHookChannel.class)).setType(EventHookChannelType.HTTP).setVersion(VERSION).setConfig(eventHookChannelConfig);
        EventHook createdEventHook = client.createEventHook(((EventHook)client.instantiate(EventHook.class)).setName(this.name).setEvents(eventSubscriptions).setChannel(eventHookChannel));
        return createdEventHook;
    }
}

