/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.client;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.http.RequestExecutor;
import com.okta.commons.lang.Assert;
import com.okta.sdk.cache.CacheManager;
import com.okta.sdk.client.Client;
import com.okta.sdk.impl.client.BaseClient;
import com.okta.sdk.impl.config.ClientConfiguration;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.DefaultInputStreamResource;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.resource.ActivateFactorRequest;
import com.okta.sdk.resource.AppLinkList;
import com.okta.sdk.resource.AppUser;
import com.okta.sdk.resource.AppUserList;
import com.okta.sdk.resource.Application;
import com.okta.sdk.resource.ApplicationFeature;
import com.okta.sdk.resource.ApplicationFeatureList;
import com.okta.sdk.resource.ApplicationGroupAssignment;
import com.okta.sdk.resource.ApplicationGroupAssignmentList;
import com.okta.sdk.resource.ApplicationList;
import com.okta.sdk.resource.AssignRoleRequest;
import com.okta.sdk.resource.Authenticator;
import com.okta.sdk.resource.AuthenticatorList;
import com.okta.sdk.resource.AuthorizationServer;
import com.okta.sdk.resource.AuthorizationServerList;
import com.okta.sdk.resource.AuthorizationServerPolicy;
import com.okta.sdk.resource.AuthorizationServerPolicyList;
import com.okta.sdk.resource.AuthorizationServerPolicyRule;
import com.okta.sdk.resource.AuthorizationServerPolicyRuleList;
import com.okta.sdk.resource.BouncesRemoveListObj;
import com.okta.sdk.resource.BouncesRemoveListResult;
import com.okta.sdk.resource.Brand;
import com.okta.sdk.resource.BrandList;
import com.okta.sdk.resource.CAPTCHAInstance;
import com.okta.sdk.resource.CAPTCHAInstanceList;
import com.okta.sdk.resource.CapabilitiesObject;
import com.okta.sdk.resource.CatalogApplicationList;
import com.okta.sdk.resource.ChangePasswordRequest;
import com.okta.sdk.resource.CreateSessionRequest;
import com.okta.sdk.resource.CreateUserRequest;
import com.okta.sdk.resource.Csr;
import com.okta.sdk.resource.CsrList;
import com.okta.sdk.resource.CsrMetadata;
import com.okta.sdk.resource.Domain;
import com.okta.sdk.resource.DomainCertificate;
import com.okta.sdk.resource.DomainListResponse;
import com.okta.sdk.resource.DomainResponse;
import com.okta.sdk.resource.EventHook;
import com.okta.sdk.resource.EventHookList;
import com.okta.sdk.resource.Feature;
import com.okta.sdk.resource.FeatureList;
import com.okta.sdk.resource.ForgotPasswordResponse;
import com.okta.sdk.resource.Group;
import com.okta.sdk.resource.GroupList;
import com.okta.sdk.resource.GroupRule;
import com.okta.sdk.resource.GroupRuleList;
import com.okta.sdk.resource.GroupSchema;
import com.okta.sdk.resource.IdentityProvider;
import com.okta.sdk.resource.IdentityProviderApplicationUser;
import com.okta.sdk.resource.IdentityProviderApplicationUserList;
import com.okta.sdk.resource.IdentityProviderList;
import com.okta.sdk.resource.ImageUploadResponse;
import com.okta.sdk.resource.InlineHook;
import com.okta.sdk.resource.InlineHookList;
import com.okta.sdk.resource.InlineHookPayload;
import com.okta.sdk.resource.InlineHookResponse;
import com.okta.sdk.resource.JsonWebKey;
import com.okta.sdk.resource.JsonWebKeyList;
import com.okta.sdk.resource.JwkUse;
import com.okta.sdk.resource.LinkedObject;
import com.okta.sdk.resource.LinkedObjectList;
import com.okta.sdk.resource.LogEventList;
import com.okta.sdk.resource.NetworkZone;
import com.okta.sdk.resource.NetworkZoneList;
import com.okta.sdk.resource.OAuth2Claim;
import com.okta.sdk.resource.OAuth2ClaimList;
import com.okta.sdk.resource.OAuth2ClientList;
import com.okta.sdk.resource.OAuth2RefreshToken;
import com.okta.sdk.resource.OAuth2RefreshTokenList;
import com.okta.sdk.resource.OAuth2Scope;
import com.okta.sdk.resource.OAuth2ScopeConsentGrant;
import com.okta.sdk.resource.OAuth2ScopeConsentGrantList;
import com.okta.sdk.resource.OAuth2ScopeList;
import com.okta.sdk.resource.OAuth2Token;
import com.okta.sdk.resource.OAuth2TokenList;
import com.okta.sdk.resource.OrgContactTypeObjList;
import com.okta.sdk.resource.OrgContactUser;
import com.okta.sdk.resource.OrgOktaCommunicationSetting;
import com.okta.sdk.resource.OrgOktaSupportSettingsObj;
import com.okta.sdk.resource.OrgPreferences;
import com.okta.sdk.resource.OrgSetting;
import com.okta.sdk.resource.Policy;
import com.okta.sdk.resource.PolicyList;
import com.okta.sdk.resource.PolicyRule;
import com.okta.sdk.resource.PolicyRuleList;
import com.okta.sdk.resource.ProfileMapping;
import com.okta.sdk.resource.ProfileMappingList;
import com.okta.sdk.resource.ProvisioningConnection;
import com.okta.sdk.resource.ProvisioningConnectionRequest;
import com.okta.sdk.resource.ResetPasswordToken;
import com.okta.sdk.resource.ResponseLinksList;
import com.okta.sdk.resource.Role;
import com.okta.sdk.resource.RoleList;
import com.okta.sdk.resource.SecurityQuestionList;
import com.okta.sdk.resource.Session;
import com.okta.sdk.resource.SmsTemplate;
import com.okta.sdk.resource.SmsTemplateList;
import com.okta.sdk.resource.SmsTemplateType;
import com.okta.sdk.resource.SocialAuthTokenList;
import com.okta.sdk.resource.Subscription;
import com.okta.sdk.resource.SubscriptionList;
import com.okta.sdk.resource.TempPassword;
import com.okta.sdk.resource.Theme;
import com.okta.sdk.resource.ThemeResponse;
import com.okta.sdk.resource.ThemeResponseList;
import com.okta.sdk.resource.ThreatInsightConfiguration;
import com.okta.sdk.resource.TrustedOrigin;
import com.okta.sdk.resource.TrustedOriginList;
import com.okta.sdk.resource.User;
import com.okta.sdk.resource.UserActivationToken;
import com.okta.sdk.resource.UserCredentials;
import com.okta.sdk.resource.UserFactor;
import com.okta.sdk.resource.UserFactorList;
import com.okta.sdk.resource.UserIdentityProviderLinkRequest;
import com.okta.sdk.resource.UserList;
import com.okta.sdk.resource.UserNextLogin;
import com.okta.sdk.resource.UserSchema;
import com.okta.sdk.resource.UserType;
import com.okta.sdk.resource.UserTypeList;
import com.okta.sdk.resource.VerifyFactorRequest;
import com.okta.sdk.resource.VerifyUserFactorResponse;
import com.okta.sdk.resource.VoidResource;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultClient
extends BaseClient
implements Client {
    public DefaultClient(ClientConfiguration clientConfiguration, CacheManager cacheManager) {
        super(clientConfiguration, cacheManager);
    }

    public DefaultClient(ClientConfiguration clientConfiguration, CacheManager cacheManager, RequestExecutor requestExecutor) {
        super(clientConfiguration, cacheManager, requestExecutor);
    }

    public ApplicationList listApplications(String q, String filter, String expand, Boolean includeNonDeleted) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        if (includeNonDeleted != null) {
            queryArgs.put("includeNonDeleted", includeNonDeleted);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps", ApplicationList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ApplicationList listApplications() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps", ApplicationList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Application createApplication(Application application, Boolean activate, String oktaAccessGatewayAgent) {
        Assert.notNull((Object)application, (String)"'application' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (activate != null) {
            queryArgs.put("activate", activate);
        }
        HttpHeaders headers = new HttpHeaders();
        if (oktaAccessGatewayAgent != null) {
            headers.add("OktaAccessGateway-Agent", oktaAccessGatewayAgent);
        }
        this.getDataStore().create("/api/v1/apps", application, null, Application.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return application;
    }

    public Application createApplication(Application application) {
        Assert.notNull((Object)application, (String)"'application' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/apps", application, null, Application.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return application;
    }

    public void deleteApplication(String appId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/apps/" + appId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public Application getApplication(String appId, String expand) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "", Application.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Application getApplication(String appId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "", Application.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Application updateApplication(Application application, String appId) {
        Assert.notNull((Object)application, (String)"'application' is required and cannot be null.");
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/apps/" + appId + "";
        this.getDataStore().save(href, application, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return application;
    }

    public ProvisioningConnection getDefaultProvisioningConnectionForApplication(String appId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/connections/default", ProvisioningConnection.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ProvisioningConnection setDefaultProvisioningConnectionForApplication(ProvisioningConnectionRequest body, String appId, Boolean activate) {
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (activate != null) {
            queryArgs.put("activate", activate);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/apps/" + appId + "/connections/default", body, null, ProvisioningConnection.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public ProvisioningConnection setDefaultProvisioningConnectionForApplication(ProvisioningConnectionRequest body, String appId) {
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/apps/" + appId + "/connections/default", body, null, ProvisioningConnection.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public void activateDefaultProvisioningConnectionForApplication(String appId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/apps/" + appId + "/connections/default/lifecycle/activate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deactivateDefaultProvisioningConnectionForApplication(String appId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/apps/" + appId + "/connections/default/lifecycle/deactivate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public CsrList listCsrsForApplication(String appId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/credentials/csrs", CsrList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Csr generateCsrForApplication(CsrMetadata metadata, String appId) {
        Assert.notNull((Object)metadata, (String)"'metadata' is required and cannot be null.");
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/apps/" + appId + "/credentials/csrs", metadata, null, Csr.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public void revokeCsrFromApplication(String appId, String csrId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)csrId, (String)"'csrId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/apps/" + appId + "/credentials/csrs/" + csrId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public Csr getCsrForApplication(String appId, String csrId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)csrId, (String)"'csrId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/credentials/csrs/" + csrId + "", Csr.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKey publishCsrFromApplication(InputStream body, String appId, String csrId) {
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)csrId, (String)"'csrId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/apps/" + appId + "/credentials/csrs/" + csrId + "/lifecycle/publish", new DefaultInputStreamResource((InternalDataStore)this.getDataStore(), body), null, JsonWebKey.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKeyList listApplicationKeys(String appId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/credentials/keys", JsonWebKeyList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKey generateApplicationKey(String appId, Integer validityYears) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (validityYears != null) {
            queryArgs.put("validityYears", validityYears);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/apps/" + appId + "/credentials/keys/generate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, JsonWebKey.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKey generateApplicationKey(String appId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/apps/" + appId + "/credentials/keys/generate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, JsonWebKey.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKey getApplicationKey(String appId, String keyId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)keyId, (String)"'keyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/credentials/keys/" + keyId + "", JsonWebKey.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKey cloneApplicationKey(String appId, String keyId, String targetAid) {
        Assert.notNull((Object)targetAid, (String)"'targetAid' is required and cannot be null.");
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)keyId, (String)"'keyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (targetAid != null) {
            queryArgs.put("targetAid", targetAid);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/apps/" + appId + "/credentials/keys/" + keyId + "/clone", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, JsonWebKey.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ApplicationFeatureList listFeaturesForApplication(String appId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/features", ApplicationFeatureList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ApplicationFeature getFeatureForApplication(String appId, String name) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)name, (String)"'name' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/features/" + name + "", ApplicationFeature.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ApplicationFeature updateFeatureForApplication(CapabilitiesObject body, String appId, String name) {
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)name, (String)"'name' is required and cannot be null or empty.");
        HashMap queryArgs = new HashMap();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/apps/" + appId + "/features/" + name + "";
        return this.getDataStore().save(href, body, ApplicationFeature.class, false);
    }

    public OAuth2ScopeConsentGrantList listScopeConsentGrants(String appId, String expand) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/grants", OAuth2ScopeConsentGrantList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ScopeConsentGrantList listScopeConsentGrants(String appId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/grants", OAuth2ScopeConsentGrantList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ScopeConsentGrant grantConsentToScope(OAuth2ScopeConsentGrant oAuth2ScopeConsentGrant, String appId) {
        Assert.notNull((Object)oAuth2ScopeConsentGrant, (String)"'oAuth2ScopeConsentGrant' is required and cannot be null.");
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/apps/" + appId + "/grants", oAuth2ScopeConsentGrant, null, OAuth2ScopeConsentGrant.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return oAuth2ScopeConsentGrant;
    }

    public void revokeScopeConsentGrant(String appId, String grantId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)grantId, (String)"'grantId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/apps/" + appId + "/grants/" + grantId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ScopeConsentGrant getScopeConsentGrant(String appId, String grantId, String expand) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)grantId, (String)"'grantId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/grants/" + grantId + "", OAuth2ScopeConsentGrant.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ScopeConsentGrant getScopeConsentGrant(String appId, String grantId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)grantId, (String)"'grantId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/grants/" + grantId + "", OAuth2ScopeConsentGrant.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ApplicationGroupAssignmentList listApplicationGroupAssignments(String appId, String q, String expand) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/groups", ApplicationGroupAssignmentList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ApplicationGroupAssignmentList listApplicationGroupAssignments(String appId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/groups", ApplicationGroupAssignmentList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deleteApplicationGroupAssignment(String appId, String groupId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/apps/" + appId + "/groups/" + groupId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public ApplicationGroupAssignment getApplicationGroupAssignment(String appId, String groupId, String expand) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/groups/" + groupId + "", ApplicationGroupAssignment.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ApplicationGroupAssignment getApplicationGroupAssignment(String appId, String groupId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/groups/" + groupId + "", ApplicationGroupAssignment.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ApplicationGroupAssignment createApplicationGroupAssignment(ApplicationGroupAssignment applicationGroupAssignment, String appId, String groupId) {
        Assert.notNull((Object)applicationGroupAssignment, (String)"'applicationGroupAssignment' is required and cannot be null.");
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/apps/" + appId + "/groups/" + groupId + "";
        this.getDataStore().save(href, applicationGroupAssignment, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return applicationGroupAssignment;
    }

    public void activateApplication(String appId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/apps/" + appId + "/lifecycle/activate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deactivateApplication(String appId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/apps/" + appId + "/lifecycle/deactivate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void revokeOAuth2TokensForApplication(String appId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/apps/" + appId + "/tokens", queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2TokenList listOAuth2TokensForApplication(String appId, String expand) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/tokens", OAuth2TokenList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2TokenList listOAuth2TokensForApplication(String appId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/tokens", OAuth2TokenList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void revokeOAuth2TokenForApplication(String appId, String tokenId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)tokenId, (String)"'tokenId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/apps/" + appId + "/tokens/" + tokenId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2Token getOAuth2TokenForApplication(String appId, String tokenId, String expand) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)tokenId, (String)"'tokenId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/tokens/" + tokenId + "", OAuth2Token.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2Token getOAuth2TokenForApplication(String appId, String tokenId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)tokenId, (String)"'tokenId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/tokens/" + tokenId + "", OAuth2Token.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public AppUserList listApplicationUsers(String appId, String q, String queryScope, String filter, String expand) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (queryScope != null) {
            queryArgs.put("query_scope", queryScope);
        }
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/users", AppUserList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public AppUserList listApplicationUsers(String appId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/users", AppUserList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public AppUser assignUserToApplication(AppUser appUser, String appId) {
        Assert.notNull((Object)appUser, (String)"'appUser' is required and cannot be null.");
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/apps/" + appId + "/users", appUser, null, AppUser.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return appUser;
    }

    public void deleteApplicationUser(String appId, String userId, Boolean sendEmail) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (sendEmail != null) {
            queryArgs.put("sendEmail", sendEmail);
        }
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/apps/" + appId + "/users/" + userId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public void deleteApplicationUser(String appId, String userId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/apps/" + appId + "/users/" + userId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public AppUser getApplicationUser(String appId, String userId, String expand) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/users/" + userId + "", AppUser.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public AppUser getApplicationUser(String appId, String userId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/users/" + userId + "", AppUser.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public AppUser updateApplicationUser(AppUser appUser, String appId, String userId) {
        Assert.notNull((Object)appUser, (String)"'appUser' is required and cannot be null.");
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/apps/" + appId + "/users/" + userId + "", appUser, null, AppUser.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return appUser;
    }

    public AuthenticatorList listAuthenticators() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authenticators", AuthenticatorList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Authenticator getAuthenticator(String authenticatorId) {
        Assert.hasText((String)authenticatorId, (String)"'authenticatorId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authenticators/" + authenticatorId + "", Authenticator.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Authenticator updateAuthenticator(Authenticator authenticator, String authenticatorId) {
        Assert.notNull((Object)authenticator, (String)"'authenticator' is required and cannot be null.");
        Assert.hasText((String)authenticatorId, (String)"'authenticatorId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/authenticators/" + authenticatorId + "";
        this.getDataStore().save(href, authenticator, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return authenticator;
    }

    public Authenticator activateAuthenticator(String authenticatorId) {
        Assert.hasText((String)authenticatorId, (String)"'authenticatorId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/authenticators/" + authenticatorId + "/lifecycle/activate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, Authenticator.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Authenticator deactivateAuthenticator(String authenticatorId) {
        Assert.hasText((String)authenticatorId, (String)"'authenticatorId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/authenticators/" + authenticatorId + "/lifecycle/deactivate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, Authenticator.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public AuthorizationServerList listAuthorizationServers(String q) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (q != null) {
            queryArgs.put("q", q);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers", AuthorizationServerList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public AuthorizationServerList listAuthorizationServers() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers", AuthorizationServerList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public AuthorizationServer createAuthorizationServer(AuthorizationServer authorizationServer) {
        Assert.notNull((Object)authorizationServer, (String)"'authorizationServer' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/authorizationServers", authorizationServer, null, AuthorizationServer.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return authorizationServer;
    }

    public void deleteAuthorizationServer(String authServerId) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/authorizationServers/" + authServerId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public AuthorizationServer getAuthorizationServer(String authServerId) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "", AuthorizationServer.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public AuthorizationServer updateAuthorizationServer(AuthorizationServer authorizationServer, String authServerId) {
        Assert.notNull((Object)authorizationServer, (String)"'authorizationServer' is required and cannot be null.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/authorizationServers/" + authServerId + "";
        this.getDataStore().save(href, authorizationServer, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return authorizationServer;
    }

    public OAuth2ClaimList listOAuth2Claims(String authServerId) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/claims", OAuth2ClaimList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2Claim createOAuth2Claim(OAuth2Claim oAuth2Claim, String authServerId) {
        Assert.notNull((Object)oAuth2Claim, (String)"'oAuth2Claim' is required and cannot be null.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/authorizationServers/" + authServerId + "/claims", oAuth2Claim, null, OAuth2Claim.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return oAuth2Claim;
    }

    public void deleteOAuth2Claim(String authServerId, String claimId) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)claimId, (String)"'claimId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/authorizationServers/" + authServerId + "/claims/" + claimId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2Claim getOAuth2Claim(String authServerId, String claimId) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)claimId, (String)"'claimId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/claims/" + claimId + "", OAuth2Claim.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2Claim updateOAuth2Claim(OAuth2Claim oAuth2Claim, String authServerId, String claimId) {
        Assert.notNull((Object)oAuth2Claim, (String)"'oAuth2Claim' is required and cannot be null.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)claimId, (String)"'claimId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/authorizationServers/" + authServerId + "/claims/" + claimId + "";
        this.getDataStore().save(href, oAuth2Claim, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return oAuth2Claim;
    }

    public OAuth2ClientList listOAuth2ClientsForAuthorizationServer(String authServerId) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/clients", OAuth2ClientList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void revokeRefreshTokensForAuthorizationServerAndClient(String authServerId, String clientId) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/authorizationServers/" + authServerId + "/clients/" + clientId + "/tokens", queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2RefreshTokenList listRefreshTokensForAuthorizationServerAndClient(String authServerId, String clientId, String expand) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/clients/" + clientId + "/tokens", OAuth2RefreshTokenList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2RefreshTokenList listRefreshTokensForAuthorizationServerAndClient(String authServerId, String clientId) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/clients/" + clientId + "/tokens", OAuth2RefreshTokenList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void revokeRefreshTokenForAuthorizationServerAndClient(String authServerId, String clientId, String tokenId) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        Assert.hasText((String)tokenId, (String)"'tokenId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/authorizationServers/" + authServerId + "/clients/" + clientId + "/tokens/" + tokenId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2RefreshToken getRefreshTokenForAuthorizationServerAndClient(String authServerId, String clientId, String tokenId, String expand) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        Assert.hasText((String)tokenId, (String)"'tokenId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/clients/" + clientId + "/tokens/" + tokenId + "", OAuth2RefreshToken.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2RefreshToken getRefreshTokenForAuthorizationServerAndClient(String authServerId, String clientId, String tokenId) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        Assert.hasText((String)tokenId, (String)"'tokenId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/clients/" + clientId + "/tokens/" + tokenId + "", OAuth2RefreshToken.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKeyList listAuthorizationServerKeys(String authServerId) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/credentials/keys", JsonWebKeyList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKeyList rotateAuthorizationServerKeys(JwkUse use, String authServerId) {
        Assert.notNull((Object)use, (String)"'use' is required and cannot be null.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/authorizationServers/" + authServerId + "/credentials/lifecycle/keyRotate", use, null, JsonWebKeyList.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public void activateAuthorizationServer(String authServerId) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/authorizationServers/" + authServerId + "/lifecycle/activate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deactivateAuthorizationServer(String authServerId) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/authorizationServers/" + authServerId + "/lifecycle/deactivate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public AuthorizationServerPolicyList listAuthorizationServerPolicies(String authServerId) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/policies", AuthorizationServerPolicyList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public AuthorizationServerPolicy createAuthorizationServerPolicy(AuthorizationServerPolicy policy, String authServerId) {
        Assert.notNull((Object)policy, (String)"'policy' is required and cannot be null.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/authorizationServers/" + authServerId + "/policies", policy, null, AuthorizationServerPolicy.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return policy;
    }

    public void deleteAuthorizationServerPolicy(String authServerId, String policyId) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public AuthorizationServerPolicy getAuthorizationServerPolicy(String authServerId, String policyId) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "", AuthorizationServerPolicy.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public AuthorizationServerPolicy updateAuthorizationServerPolicy(AuthorizationServerPolicy policy, String authServerId, String policyId) {
        Assert.notNull((Object)policy, (String)"'policy' is required and cannot be null.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "";
        this.getDataStore().save(href, policy, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return policy;
    }

    public void activateAuthorizationServerPolicy(String authServerId, String policyId) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "/lifecycle/activate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deactivateAuthorizationServerPolicy(String authServerId, String policyId) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "/lifecycle/deactivate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public AuthorizationServerPolicyRuleList listAuthorizationServerPolicyRules(String policyId, String authServerId) {
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "/rules", AuthorizationServerPolicyRuleList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public AuthorizationServerPolicyRule createAuthorizationServerPolicyRule(AuthorizationServerPolicyRule policyRule, String policyId, String authServerId) {
        Assert.notNull((Object)policyRule, (String)"'policyRule' is required and cannot be null.");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "/rules", policyRule, null, AuthorizationServerPolicyRule.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return policyRule;
    }

    public void deleteAuthorizationServerPolicyRule(String policyId, String authServerId, String ruleId) {
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "/rules/" + ruleId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public AuthorizationServerPolicyRule getAuthorizationServerPolicyRule(String policyId, String authServerId, String ruleId) {
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "/rules/" + ruleId + "", AuthorizationServerPolicyRule.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public AuthorizationServerPolicyRule updateAuthorizationServerPolicyRule(AuthorizationServerPolicyRule policyRule, String policyId, String authServerId, String ruleId) {
        Assert.notNull((Object)policyRule, (String)"'policyRule' is required and cannot be null.");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "/rules/" + ruleId + "";
        this.getDataStore().save(href, policyRule, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return policyRule;
    }

    public void activateAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "/rules/" + ruleId + "/lifecycle/activate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deactivateAuthorizationServerPolicyRule(String authServerId, String policyId, String ruleId) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "/rules/" + ruleId + "/lifecycle/deactivate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ScopeList listOAuth2Scopes(String authServerId, String q, String filter, String cursor) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        if (cursor != null) {
            queryArgs.put("cursor", cursor);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/scopes", OAuth2ScopeList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ScopeList listOAuth2Scopes(String authServerId) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/scopes", OAuth2ScopeList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2Scope createOAuth2Scope(OAuth2Scope oAuth2Scope, String authServerId) {
        Assert.notNull((Object)oAuth2Scope, (String)"'oAuth2Scope' is required and cannot be null.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/authorizationServers/" + authServerId + "/scopes", oAuth2Scope, null, OAuth2Scope.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return oAuth2Scope;
    }

    public void deleteOAuth2Scope(String authServerId, String scopeId) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)scopeId, (String)"'scopeId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/authorizationServers/" + authServerId + "/scopes/" + scopeId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2Scope getOAuth2Scope(String authServerId, String scopeId) {
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)scopeId, (String)"'scopeId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/authorizationServers/" + authServerId + "/scopes/" + scopeId + "", OAuth2Scope.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2Scope updateOAuth2Scope(OAuth2Scope oAuth2Scope, String authServerId, String scopeId) {
        Assert.notNull((Object)oAuth2Scope, (String)"'oAuth2Scope' is required and cannot be null.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)scopeId, (String)"'scopeId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/authorizationServers/" + authServerId + "/scopes/" + scopeId + "";
        this.getDataStore().save(href, oAuth2Scope, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return oAuth2Scope;
    }

    public BrandList listBrands() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/brands", BrandList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Brand getBrand(String brandId) {
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/brands/" + brandId + "", Brand.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Brand updateBrand(Brand brand, String brandId) {
        Assert.notNull((Object)brand, (String)"'brand' is required and cannot be null.");
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/brands/" + brandId + "";
        this.getDataStore().save(href, brand, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return brand;
    }

    public ThemeResponseList listBrandThemes(String brandId) {
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/brands/" + brandId + "/themes", ThemeResponseList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ThemeResponse getBrandTheme(String brandId, String themeId) {
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)themeId, (String)"'themeId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/brands/" + brandId + "/themes/" + themeId + "", ThemeResponse.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ThemeResponse updateBrandTheme(Theme theme, String brandId, String themeId) {
        Assert.notNull((Object)theme, (String)"'theme' is required and cannot be null.");
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)themeId, (String)"'themeId' is required and cannot be null or empty.");
        HashMap queryArgs = new HashMap();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/brands/" + brandId + "/themes/" + themeId + "";
        return this.getDataStore().save(href, theme, ThemeResponse.class, false);
    }

    public void deleteBrandThemeBackgroundImage(String brandId, String themeId) {
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)themeId, (String)"'themeId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/brands/" + brandId + "/themes/" + themeId + "/background-image", queryArgs, (Map<String, List<String>>)headers);
    }

    public ImageUploadResponse uploadBrandThemeBackgroundImage(String brandId, String themeId) {
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)themeId, (String)"'themeId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/brands/" + brandId + "/themes/" + themeId + "/background-image", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, ImageUploadResponse.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deleteBrandThemeFavicon(String brandId, String themeId) {
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)themeId, (String)"'themeId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/brands/" + brandId + "/themes/" + themeId + "/favicon", queryArgs, (Map<String, List<String>>)headers);
    }

    public ImageUploadResponse uploadBrandThemeFavicon(String brandId, String themeId) {
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)themeId, (String)"'themeId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/brands/" + brandId + "/themes/" + themeId + "/favicon", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, ImageUploadResponse.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deleteBrandThemeLogo(String brandId, String themeId) {
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)themeId, (String)"'themeId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/brands/" + brandId + "/themes/" + themeId + "/logo", queryArgs, (Map<String, List<String>>)headers);
    }

    public ImageUploadResponse uploadBrandThemeLogo(String brandId, String themeId) {
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)themeId, (String)"'themeId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/brands/" + brandId + "/themes/" + themeId + "/logo", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, ImageUploadResponse.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public CAPTCHAInstanceList listCaptchaInstances() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/captchas", CAPTCHAInstanceList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public CAPTCHAInstance createCaptchaInstance(CAPTCHAInstance instance) {
        Assert.notNull((Object)instance, (String)"'instance' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/captchas", instance, null, CAPTCHAInstance.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return instance;
    }

    public void deleteCaptchaInstance(String captchaId) {
        Assert.hasText((String)captchaId, (String)"'captchaId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/captchas/" + captchaId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public CAPTCHAInstance getCaptchaInstance(String captchaId) {
        Assert.hasText((String)captchaId, (String)"'captchaId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/captchas/" + captchaId + "", CAPTCHAInstance.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public CAPTCHAInstance partialUpdateCaptchaInstance(CAPTCHAInstance instance, String captchaId) {
        Assert.notNull((Object)instance, (String)"'instance' is required and cannot be null.");
        Assert.hasText((String)captchaId, (String)"'captchaId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/captchas/" + captchaId + "", instance, null, CAPTCHAInstance.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return instance;
    }

    public CAPTCHAInstance updateCaptchaInstance(CAPTCHAInstance instance, String captchaId) {
        Assert.notNull((Object)instance, (String)"'instance' is required and cannot be null.");
        Assert.hasText((String)captchaId, (String)"'captchaId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/captchas/" + captchaId + "";
        this.getDataStore().save(href, instance, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return instance;
    }

    public DomainListResponse listDomains() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/domains", DomainListResponse.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public DomainResponse createDomain(Domain domain) {
        Assert.notNull((Object)domain, (String)"'domain' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/domains", domain, null, DomainResponse.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public void deleteDomain(String domainId) {
        Assert.hasText((String)domainId, (String)"'domainId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/domains/" + domainId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public DomainResponse getDomain(String domainId) {
        Assert.hasText((String)domainId, (String)"'domainId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/domains/" + domainId + "", DomainResponse.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void createCertificate(DomainCertificate certificate, String domainId) {
        Assert.notNull((Object)certificate, (String)"'certificate' is required and cannot be null.");
        Assert.hasText((String)domainId, (String)"'domainId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/domains/" + domainId + "/certificate";
        this.getDataStore().save(href, certificate, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public DomainResponse verifyDomain(String domainId) {
        Assert.hasText((String)domainId, (String)"'domainId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/domains/" + domainId + "/verify", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, DomainResponse.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public EventHookList listEventHooks() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/eventHooks", EventHookList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public EventHook createEventHook(EventHook eventHook) {
        Assert.notNull((Object)eventHook, (String)"'eventHook' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/eventHooks", eventHook, null, EventHook.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return eventHook;
    }

    public void deleteEventHook(String eventHookId) {
        Assert.hasText((String)eventHookId, (String)"'eventHookId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/eventHooks/" + eventHookId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public EventHook getEventHook(String eventHookId) {
        Assert.hasText((String)eventHookId, (String)"'eventHookId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/eventHooks/" + eventHookId + "", EventHook.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public EventHook updateEventHook(EventHook eventHook, String eventHookId) {
        Assert.notNull((Object)eventHook, (String)"'eventHook' is required and cannot be null.");
        Assert.hasText((String)eventHookId, (String)"'eventHookId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/eventHooks/" + eventHookId + "";
        this.getDataStore().save(href, eventHook, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return eventHook;
    }

    public EventHook activateEventHook(String eventHookId) {
        Assert.hasText((String)eventHookId, (String)"'eventHookId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/eventHooks/" + eventHookId + "/lifecycle/activate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, EventHook.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public EventHook deactivateEventHook(String eventHookId) {
        Assert.hasText((String)eventHookId, (String)"'eventHookId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/eventHooks/" + eventHookId + "/lifecycle/deactivate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, EventHook.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public EventHook verifyEventHook(String eventHookId) {
        Assert.hasText((String)eventHookId, (String)"'eventHookId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/eventHooks/" + eventHookId + "/lifecycle/verify", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, EventHook.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public FeatureList listFeatures() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/features", FeatureList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Feature getFeature(String featureId) {
        Assert.hasText((String)featureId, (String)"'featureId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/features/" + featureId + "", Feature.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public FeatureList listFeatureDependencies(String featureId) {
        Assert.hasText((String)featureId, (String)"'featureId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/features/" + featureId + "/dependencies", FeatureList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public FeatureList listFeatureDependents(String featureId) {
        Assert.hasText((String)featureId, (String)"'featureId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/features/" + featureId + "/dependents", FeatureList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Feature updateFeatureLifecycle(String featureId, String lifecycle, String mode) {
        Assert.hasText((String)featureId, (String)"'featureId' is required and cannot be null or empty.");
        Assert.hasText((String)lifecycle, (String)"'lifecycle' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (mode != null) {
            queryArgs.put("mode", mode);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/features/" + featureId + "/" + lifecycle + "", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, Feature.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Feature updateFeatureLifecycle(String featureId, String lifecycle) {
        Assert.hasText((String)featureId, (String)"'featureId' is required and cannot be null or empty.");
        Assert.hasText((String)lifecycle, (String)"'lifecycle' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/features/" + featureId + "/" + lifecycle + "", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, Feature.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupList listGroups(String q, String search, String expand) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (search != null) {
            queryArgs.put("search", search);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups", GroupList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupList listGroups() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups", GroupList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Group createGroup(Group group) {
        Assert.notNull((Object)group, (String)"'group' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/groups", group, null, Group.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return group;
    }

    public GroupRuleList listGroupRules(String search, String expand) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (search != null) {
            queryArgs.put("search", search);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/rules", GroupRuleList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupRuleList listGroupRules() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/rules", GroupRuleList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupRule createGroupRule(GroupRule groupRule) {
        Assert.notNull((Object)groupRule, (String)"'groupRule' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/groups/rules", groupRule, null, GroupRule.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return groupRule;
    }

    public void deleteGroupRule(String ruleId, Boolean removeUsers) {
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (removeUsers != null) {
            queryArgs.put("removeUsers", removeUsers);
        }
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/groups/rules/" + ruleId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public void deleteGroupRule(String ruleId) {
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/groups/rules/" + ruleId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupRule getGroupRule(String ruleId, String expand) {
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/rules/" + ruleId + "", GroupRule.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupRule getGroupRule(String ruleId) {
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/rules/" + ruleId + "", GroupRule.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupRule updateGroupRule(GroupRule groupRule, String ruleId) {
        Assert.notNull((Object)groupRule, (String)"'groupRule' is required and cannot be null.");
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/groups/rules/" + ruleId + "";
        this.getDataStore().save(href, groupRule, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return groupRule;
    }

    public void activateGroupRule(String ruleId) {
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/groups/rules/" + ruleId + "/lifecycle/activate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deactivateGroupRule(String ruleId) {
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/groups/rules/" + ruleId + "/lifecycle/deactivate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deleteGroup(String groupId) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/groups/" + groupId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public Group getGroup(String groupId) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/" + groupId + "", Group.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Group updateGroup(Group group, String groupId) {
        Assert.notNull((Object)group, (String)"'group' is required and cannot be null.");
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/groups/" + groupId + "";
        this.getDataStore().save(href, group, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return group;
    }

    public ApplicationList listAssignedApplicationsForGroup(String groupId) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/" + groupId + "/apps", ApplicationList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public RoleList listGroupAssignedRoles(String groupId, String expand) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/" + groupId + "/roles", RoleList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public RoleList listGroupAssignedRoles(String groupId) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/" + groupId + "/roles", RoleList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Role assignRoleToGroup(AssignRoleRequest assignRoleRequest, String groupId, Boolean disableNotifications) {
        Assert.notNull((Object)assignRoleRequest, (String)"'assignRoleRequest' is required and cannot be null.");
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (disableNotifications != null) {
            queryArgs.put("disableNotifications", disableNotifications);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/groups/" + groupId + "/roles", assignRoleRequest, null, Role.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public Role assignRoleToGroup(AssignRoleRequest assignRoleRequest, String groupId) {
        Assert.notNull((Object)assignRoleRequest, (String)"'assignRoleRequest' is required and cannot be null.");
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/groups/" + groupId + "/roles", assignRoleRequest, null, Role.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public void removeRoleFromGroup(String groupId, String roleId) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/groups/" + groupId + "/roles/" + roleId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public Role getRole(String groupId, String roleId) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/" + groupId + "/roles/" + roleId + "", Role.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public CatalogApplicationList listApplicationTargetsForApplicationAdministratorRoleForGroup(String groupId, String roleId) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/" + groupId + "/roles/" + roleId + "/targets/catalog/apps", CatalogApplicationList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void removeApplicationTargetFromApplicationAdministratorRoleGivenToGroup(String groupId, String roleId, String appName) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)appName, (String)"'appName' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/groups/" + groupId + "/roles/" + roleId + "/targets/catalog/apps/" + appName + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public void addApplicationTargetToAdminRoleGivenToGroup(String groupId, String roleId, String appName) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)appName, (String)"'appName' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/groups/" + groupId + "/roles/" + roleId + "/targets/catalog/apps/" + appName + "";
        this.getDataStore().save(href, new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, queryArgs, (Map<String, List<String>>)headers);
    }

    public void removeApplicationTargetFromAdministratorRoleGivenToGroup(String groupId, String roleId, String appName, String applicationId) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)appName, (String)"'appName' is required and cannot be null or empty.");
        Assert.hasText((String)applicationId, (String)"'applicationId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/groups/" + groupId + "/roles/" + roleId + "/targets/catalog/apps/" + appName + "/" + applicationId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public void addApplicationInstanceTargetToAppAdminRoleGivenToGroup(String groupId, String roleId, String appName, String applicationId) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)appName, (String)"'appName' is required and cannot be null or empty.");
        Assert.hasText((String)applicationId, (String)"'applicationId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/groups/" + groupId + "/roles/" + roleId + "/targets/catalog/apps/" + appName + "/" + applicationId + "";
        this.getDataStore().save(href, new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupList listGroupTargetsForGroupRole(String groupId, String roleId) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/" + groupId + "/roles/" + roleId + "/targets/groups", GroupList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void removeGroupTargetFromGroupAdministratorRoleGivenToGroup(String groupId, String roleId, String targetGroupId) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)targetGroupId, (String)"'targetGroupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/groups/" + groupId + "/roles/" + roleId + "/targets/groups/" + targetGroupId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public void addGroupTargetToGroupAdministratorRoleForGroup(String groupId, String roleId, String targetGroupId) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)targetGroupId, (String)"'targetGroupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/groups/" + groupId + "/roles/" + roleId + "/targets/groups/" + targetGroupId + "";
        this.getDataStore().save(href, new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserList listGroupUsers(String groupId) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/groups/" + groupId + "/users", UserList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void removeUserFromGroup(String groupId, String userId) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/groups/" + groupId + "/users/" + userId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public void addUserToGroup(String groupId, String userId) {
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/groups/" + groupId + "/users/" + userId + "";
        this.getDataStore().save(href, new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, queryArgs, (Map<String, List<String>>)headers);
    }

    public IdentityProviderList listIdentityProviders(String q, String type) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (type != null) {
            queryArgs.put("type", type);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/idps", IdentityProviderList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public IdentityProviderList listIdentityProviders() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/idps", IdentityProviderList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public IdentityProvider createIdentityProvider(IdentityProvider identityProvider) {
        Assert.notNull((Object)identityProvider, (String)"'identityProvider' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/idps", identityProvider, null, IdentityProvider.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return identityProvider;
    }

    public JsonWebKeyList listIdentityProviderKeys() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/idps/credentials/keys", JsonWebKeyList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKey createIdentityProviderKey(JsonWebKey jsonWebKey) {
        Assert.notNull((Object)jsonWebKey, (String)"'jsonWebKey' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/idps/credentials/keys", jsonWebKey, null, JsonWebKey.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return jsonWebKey;
    }

    public void deleteIdentityProviderKey(String keyId) {
        Assert.hasText((String)keyId, (String)"'keyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/idps/credentials/keys/" + keyId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKey getIdentityProviderKey(String keyId) {
        Assert.hasText((String)keyId, (String)"'keyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/idps/credentials/keys/" + keyId + "", JsonWebKey.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deleteIdentityProvider(String idpId) {
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/idps/" + idpId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public IdentityProvider getIdentityProvider(String idpId) {
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/idps/" + idpId + "", IdentityProvider.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public IdentityProvider updateIdentityProvider(IdentityProvider identityProvider, String idpId) {
        Assert.notNull((Object)identityProvider, (String)"'identityProvider' is required and cannot be null.");
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/idps/" + idpId + "";
        this.getDataStore().save(href, identityProvider, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return identityProvider;
    }

    public CsrList listCsrsForIdentityProvider(String idpId) {
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/idps/" + idpId + "/credentials/csrs", CsrList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Csr generateCsrForIdentityProvider(CsrMetadata metadata, String idpId) {
        Assert.notNull((Object)metadata, (String)"'metadata' is required and cannot be null.");
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/idps/" + idpId + "/credentials/csrs", metadata, null, Csr.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public void revokeCsrForIdentityProvider(String idpId, String csrId) {
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        Assert.hasText((String)csrId, (String)"'csrId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/idps/" + idpId + "/credentials/csrs/" + csrId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public Csr getCsrForIdentityProvider(String idpId, String csrId) {
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        Assert.hasText((String)csrId, (String)"'csrId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/idps/" + idpId + "/credentials/csrs/" + csrId + "", Csr.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKey publishCsrForIdentityProvider(InputStream body, String idpId, String csrId) {
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        Assert.hasText((String)csrId, (String)"'csrId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/idps/" + idpId + "/credentials/csrs/" + csrId + "/lifecycle/publish", new DefaultInputStreamResource((InternalDataStore)this.getDataStore(), body), null, JsonWebKey.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKeyList listIdentityProviderSigningKeys(String idpId) {
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/idps/" + idpId + "/credentials/keys", JsonWebKeyList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKey generateIdentityProviderSigningKey(String idpId, Integer validityYears) {
        Assert.notNull((Object)validityYears, (String)"'validityYears' is required and cannot be null.");
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (validityYears != null) {
            queryArgs.put("validityYears", validityYears);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/idps/" + idpId + "/credentials/keys/generate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, JsonWebKey.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKey getIdentityProviderSigningKey(String idpId, String keyId) {
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        Assert.hasText((String)keyId, (String)"'keyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/idps/" + idpId + "/credentials/keys/" + keyId + "", JsonWebKey.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public JsonWebKey cloneIdentityProviderKey(String idpId, String keyId, String targetIdpId) {
        Assert.notNull((Object)targetIdpId, (String)"'targetIdpId' is required and cannot be null.");
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        Assert.hasText((String)keyId, (String)"'keyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (targetIdpId != null) {
            queryArgs.put("targetIdpId", targetIdpId);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/idps/" + idpId + "/credentials/keys/" + keyId + "/clone", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, JsonWebKey.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public IdentityProvider activateIdentityProvider(String idpId) {
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/idps/" + idpId + "/lifecycle/activate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, IdentityProvider.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public IdentityProvider deactivateIdentityProvider(String idpId) {
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/idps/" + idpId + "/lifecycle/deactivate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, IdentityProvider.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public IdentityProviderApplicationUserList listIdentityProviderApplicationUsers(String idpId) {
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/idps/" + idpId + "/users", IdentityProviderApplicationUserList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void unlinkUserFromIdentityProvider(String idpId, String userId) {
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/idps/" + idpId + "/users/" + userId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public IdentityProviderApplicationUser getIdentityProviderApplicationUser(String idpId, String userId) {
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/idps/" + idpId + "/users/" + userId + "", IdentityProviderApplicationUser.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public IdentityProviderApplicationUser linkUserToIdentityProvider(UserIdentityProviderLinkRequest userIdentityProviderLinkRequest, String idpId, String userId) {
        Assert.notNull((Object)userIdentityProviderLinkRequest, (String)"'userIdentityProviderLinkRequest' is required and cannot be null.");
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/idps/" + idpId + "/users/" + userId + "", userIdentityProviderLinkRequest, null, IdentityProviderApplicationUser.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public SocialAuthTokenList listSocialAuthTokens(String idpId, String userId) {
        Assert.hasText((String)idpId, (String)"'idpId' is required and cannot be null or empty.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/idps/" + idpId + "/users/" + userId + "/credentials/tokens", SocialAuthTokenList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public InlineHookList listInlineHooks(String type) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (type != null) {
            queryArgs.put("type", type);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/inlineHooks", InlineHookList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public InlineHookList listInlineHooks() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/inlineHooks", InlineHookList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public InlineHook createInlineHook(InlineHook inlineHook) {
        Assert.notNull((Object)inlineHook, (String)"'inlineHook' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/inlineHooks", inlineHook, null, InlineHook.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return inlineHook;
    }

    public void deleteInlineHook(String inlineHookId) {
        Assert.hasText((String)inlineHookId, (String)"'inlineHookId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/inlineHooks/" + inlineHookId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public InlineHook getInlineHook(String inlineHookId) {
        Assert.hasText((String)inlineHookId, (String)"'inlineHookId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/inlineHooks/" + inlineHookId + "", InlineHook.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public InlineHook updateInlineHook(InlineHook inlineHook, String inlineHookId) {
        Assert.notNull((Object)inlineHook, (String)"'inlineHook' is required and cannot be null.");
        Assert.hasText((String)inlineHookId, (String)"'inlineHookId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/inlineHooks/" + inlineHookId + "";
        this.getDataStore().save(href, inlineHook, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return inlineHook;
    }

    public InlineHookResponse executeInlineHook(InlineHookPayload payloadData, String inlineHookId) {
        Assert.notNull((Object)payloadData, (String)"'payloadData' is required and cannot be null.");
        Assert.hasText((String)inlineHookId, (String)"'inlineHookId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/inlineHooks/" + inlineHookId + "/execute", payloadData, null, InlineHookResponse.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public InlineHook activateInlineHook(String inlineHookId) {
        Assert.hasText((String)inlineHookId, (String)"'inlineHookId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/inlineHooks/" + inlineHookId + "/lifecycle/activate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, InlineHook.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public InlineHook deactivateInlineHook(String inlineHookId) {
        Assert.hasText((String)inlineHookId, (String)"'inlineHookId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/inlineHooks/" + inlineHookId + "/lifecycle/deactivate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, InlineHook.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public LogEventList getLogs(Date since, Date until, String filter, String q, String sortOrder) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (since != null) {
            queryArgs.put("since", since);
        }
        if (until != null) {
            queryArgs.put("until", until);
        }
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (sortOrder != null) {
            queryArgs.put("sortOrder", sortOrder);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/logs", LogEventList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public LogEventList getLogs() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/logs", LogEventList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ProfileMappingList listProfileMappings(String sourceId, String targetId) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (sourceId != null) {
            queryArgs.put("sourceId", sourceId);
        }
        if (targetId != null) {
            queryArgs.put("targetId", targetId);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/mappings", ProfileMappingList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ProfileMappingList listProfileMappings() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/mappings", ProfileMappingList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ProfileMapping getProfileMapping(String mappingId) {
        Assert.hasText((String)mappingId, (String)"'mappingId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/mappings/" + mappingId + "", ProfileMapping.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ProfileMapping updateProfileMapping(ProfileMapping profileMapping, String mappingId) {
        Assert.notNull((Object)profileMapping, (String)"'profileMapping' is required and cannot be null.");
        Assert.hasText((String)mappingId, (String)"'mappingId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/mappings/" + mappingId + "", profileMapping, null, ProfileMapping.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return profileMapping;
    }

    public UserSchema getApplicationUserSchema(String appInstanceId) {
        Assert.hasText((String)appInstanceId, (String)"'appInstanceId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/meta/schemas/apps/" + appInstanceId + "/default", UserSchema.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserSchema updateApplicationUserProfile(String appInstanceId, UserSchema body) {
        Assert.hasText((String)appInstanceId, (String)"'appInstanceId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/meta/schemas/apps/" + appInstanceId + "/default", body, null, UserSchema.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return body;
    }

    public UserSchema updateApplicationUserProfile(String appInstanceId) {
        Assert.hasText((String)appInstanceId, (String)"'appInstanceId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/meta/schemas/apps/" + appInstanceId + "/default", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, UserSchema.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupSchema getGroupSchema() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/meta/schemas/group/default", GroupSchema.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupSchema updateGroupSchema(GroupSchema body) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/meta/schemas/group/default", body, null, GroupSchema.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return body;
    }

    public GroupSchema updateGroupSchema() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/meta/schemas/group/default", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, GroupSchema.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public LinkedObjectList listLinkedObjectDefinitions() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/meta/schemas/user/linkedObjects", LinkedObjectList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public LinkedObject addLinkedObjectDefinition(LinkedObject linkedObject) {
        Assert.notNull((Object)linkedObject, (String)"'linkedObject' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/meta/schemas/user/linkedObjects", linkedObject, null, LinkedObject.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return linkedObject;
    }

    public void deleteLinkedObjectDefinition(String linkedObjectName) {
        Assert.hasText((String)linkedObjectName, (String)"'linkedObjectName' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/meta/schemas/user/linkedObjects/" + linkedObjectName + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public LinkedObject getLinkedObjectDefinition(String linkedObjectName) {
        Assert.hasText((String)linkedObjectName, (String)"'linkedObjectName' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/meta/schemas/user/linkedObjects/" + linkedObjectName + "", LinkedObject.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserSchema getUserSchema(String schemaId) {
        Assert.hasText((String)schemaId, (String)"'schemaId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/meta/schemas/user/" + schemaId + "", UserSchema.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserSchema updateUserProfile(UserSchema userSchema, String schemaId) {
        Assert.notNull((Object)userSchema, (String)"'userSchema' is required and cannot be null.");
        Assert.hasText((String)schemaId, (String)"'schemaId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/meta/schemas/user/" + schemaId + "", userSchema, null, UserSchema.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return userSchema;
    }

    public UserTypeList listUserTypes() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/meta/types/user", UserTypeList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserType createUserType(UserType userType) {
        Assert.notNull((Object)userType, (String)"'userType' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/meta/types/user", userType, null, UserType.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return userType;
    }

    public void deleteUserType(String typeId) {
        Assert.hasText((String)typeId, (String)"'typeId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/meta/types/user/" + typeId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public UserType getUserType(String typeId) {
        Assert.hasText((String)typeId, (String)"'typeId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/meta/types/user/" + typeId + "", UserType.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserType updateUserType(UserType userType, String typeId) {
        Assert.notNull((Object)userType, (String)"'userType' is required and cannot be null.");
        Assert.hasText((String)typeId, (String)"'typeId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/meta/types/user/" + typeId + "", userType, null, UserType.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return userType;
    }

    public UserType replaceUserType(UserType userType, String typeId) {
        Assert.notNull((Object)userType, (String)"'userType' is required and cannot be null.");
        Assert.hasText((String)typeId, (String)"'typeId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/meta/types/user/" + typeId + "";
        this.getDataStore().save(href, userType, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return userType;
    }

    public OrgSetting getOrgSettings() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/org", OrgSetting.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OrgSetting partialUpdateOrgSetting(OrgSetting body) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/org", body, null, OrgSetting.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return body;
    }

    public OrgSetting partialUpdateOrgSetting() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/org", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, OrgSetting.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OrgSetting updateOrgSetting(OrgSetting orgSetting) {
        Assert.notNull((Object)orgSetting, (String)"'orgSetting' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/org";
        this.getDataStore().save(href, orgSetting, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return orgSetting;
    }

    public OrgContactTypeObjList getOrgContactTypes() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/org/contacts", OrgContactTypeObjList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OrgContactUser getOrgContactUser(String contactType) {
        Assert.hasText((String)contactType, (String)"'contactType' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/org/contacts/" + contactType + "", OrgContactUser.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OrgContactUser updateOrgContactUser(OrgContactUser orgContactUser, String contactType) {
        Assert.notNull((Object)orgContactUser, (String)"'orgContactUser' is required and cannot be null.");
        Assert.hasText((String)contactType, (String)"'contactType' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/org/contacts/" + contactType + "";
        this.getDataStore().save(href, orgContactUser, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return orgContactUser;
    }

    public BouncesRemoveListResult bulkRemoveEmailAddressBounces(BouncesRemoveListObj body) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/org/email/bounces/remove-list", body, null, BouncesRemoveListResult.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public BouncesRemoveListResult bulkRemoveEmailAddressBounces() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/org/email/bounces/remove-list", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, BouncesRemoveListResult.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void updateOrgLogo() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/org/logo", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OrgPreferences getOrgPreferences() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/org/preferences", OrgPreferences.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OrgPreferences hideOktaUIFooter() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/org/preferences/hideEndUserFooter", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, OrgPreferences.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OrgPreferences showOktaUIFooter() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/org/preferences/showEndUserFooter", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, OrgPreferences.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OrgOktaCommunicationSetting getOktaCommunicationSettings() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/org/privacy/oktaCommunication", OrgOktaCommunicationSetting.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OrgOktaCommunicationSetting optInUsersToOktaCommunicationEmails() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/org/privacy/oktaCommunication/optIn", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, OrgOktaCommunicationSetting.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OrgOktaCommunicationSetting optOutUsersFromOktaCommunicationEmails() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/org/privacy/oktaCommunication/optOut", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, OrgOktaCommunicationSetting.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OrgOktaSupportSettingsObj getOrgOktaSupportSettings() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/org/privacy/oktaSupport", OrgOktaSupportSettingsObj.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OrgOktaSupportSettingsObj extendOktaSupport() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/org/privacy/oktaSupport/extend", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, OrgOktaSupportSettingsObj.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OrgOktaSupportSettingsObj grantOktaSupport() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/org/privacy/oktaSupport/grant", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, OrgOktaSupportSettingsObj.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OrgOktaSupportSettingsObj revokeOktaSupport() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/org/privacy/oktaSupport/revoke", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, OrgOktaSupportSettingsObj.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public PolicyList listPolicies(String type, String status, String expand) {
        Assert.notNull((Object)type, (String)"'type' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (type != null) {
            queryArgs.put("type", type);
        }
        if (status != null) {
            queryArgs.put("status", status);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/policies", PolicyList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public PolicyList listPolicies(String type) {
        Assert.notNull((Object)type, (String)"'type' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        queryArgs.put("type", type);
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/policies", PolicyList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Policy createPolicy(Policy policy, Boolean activate) {
        Assert.notNull((Object)policy, (String)"'policy' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (activate != null) {
            queryArgs.put("activate", activate);
        }
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/policies", policy, null, Policy.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return policy;
    }

    public Policy createPolicy(Policy policy) {
        Assert.notNull((Object)policy, (String)"'policy' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/policies", policy, null, Policy.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return policy;
    }

    public void deletePolicy(String policyId) {
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/policies/" + policyId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public Policy getPolicy(String policyId, String expand) {
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/policies/" + policyId + "", Policy.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Policy getPolicy(String policyId) {
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/policies/" + policyId + "", Policy.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Policy updatePolicy(Policy policy, String policyId) {
        Assert.notNull((Object)policy, (String)"'policy' is required and cannot be null.");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/policies/" + policyId + "";
        this.getDataStore().save(href, policy, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return policy;
    }

    public void activatePolicy(String policyId) {
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/policies/" + policyId + "/lifecycle/activate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deactivatePolicy(String policyId) {
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/policies/" + policyId + "/lifecycle/deactivate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public PolicyRuleList listPolicyRules(String policyId) {
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/policies/" + policyId + "/rules", PolicyRuleList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public PolicyRule createPolicyRule(PolicyRule policyRule, String policyId) {
        Assert.notNull((Object)policyRule, (String)"'policyRule' is required and cannot be null.");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/policies/" + policyId + "/rules", policyRule, null, PolicyRule.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return policyRule;
    }

    public void deletePolicyRule(String policyId, String ruleId) {
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/policies/" + policyId + "/rules/" + ruleId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public PolicyRule getPolicyRule(String policyId, String ruleId) {
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/policies/" + policyId + "/rules/" + ruleId + "", PolicyRule.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public PolicyRule updatePolicyRule(PolicyRule policyRule, String policyId, String ruleId) {
        Assert.notNull((Object)policyRule, (String)"'policyRule' is required and cannot be null.");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/policies/" + policyId + "/rules/" + ruleId + "";
        this.getDataStore().save(href, policyRule, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return policyRule;
    }

    public void activatePolicyRule(String policyId, String ruleId) {
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/policies/" + policyId + "/rules/" + ruleId + "/lifecycle/activate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deactivatePolicyRule(String policyId, String ruleId) {
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/policies/" + policyId + "/rules/" + ruleId + "/lifecycle/deactivate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public SubscriptionList listRoleSubscriptions(String roleTypeOrRoleId) {
        Assert.hasText((String)roleTypeOrRoleId, (String)"'roleTypeOrRoleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/roles/" + roleTypeOrRoleId + "/subscriptions", SubscriptionList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Subscription getRoleSubscriptionByNotificationType(String roleTypeOrRoleId, String notificationType) {
        Assert.hasText((String)roleTypeOrRoleId, (String)"'roleTypeOrRoleId' is required and cannot be null or empty.");
        Assert.hasText((String)notificationType, (String)"'notificationType' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/roles/" + roleTypeOrRoleId + "/subscriptions/" + notificationType + "", Subscription.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void subscribeRoleSubscriptionByNotificationType(String roleTypeOrRoleId, String notificationType) {
        Assert.hasText((String)roleTypeOrRoleId, (String)"'roleTypeOrRoleId' is required and cannot be null or empty.");
        Assert.hasText((String)notificationType, (String)"'notificationType' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/roles/" + roleTypeOrRoleId + "/subscriptions/" + notificationType + "/subscribe", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void unsubscribeRoleSubscriptionByNotificationType(String roleTypeOrRoleId, String notificationType) {
        Assert.hasText((String)roleTypeOrRoleId, (String)"'roleTypeOrRoleId' is required and cannot be null or empty.");
        Assert.hasText((String)notificationType, (String)"'notificationType' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/roles/" + roleTypeOrRoleId + "/subscriptions/" + notificationType + "/unsubscribe", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Session createSession(CreateSessionRequest createSessionRequest) {
        Assert.notNull((Object)createSessionRequest, (String)"'createSessionRequest' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/sessions", createSessionRequest, null, Session.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public void endSession(String sessionId) {
        Assert.hasText((String)sessionId, (String)"'sessionId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/sessions/" + sessionId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public Session getSession(String sessionId) {
        Assert.hasText((String)sessionId, (String)"'sessionId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/sessions/" + sessionId + "", Session.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Session refreshSession(String sessionId) {
        Assert.hasText((String)sessionId, (String)"'sessionId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/sessions/" + sessionId + "/lifecycle/refresh", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, Session.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public SmsTemplateList listSmsTemplates(SmsTemplateType templateType) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (templateType != null) {
            queryArgs.put("templateType", templateType);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/templates/sms", SmsTemplateList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public SmsTemplateList listSmsTemplates() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/templates/sms", SmsTemplateList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public SmsTemplate createSmsTemplate(SmsTemplate smsTemplate) {
        Assert.notNull((Object)smsTemplate, (String)"'smsTemplate' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/templates/sms", smsTemplate, null, SmsTemplate.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return smsTemplate;
    }

    public void deleteSmsTemplate(String templateId) {
        Assert.hasText((String)templateId, (String)"'templateId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/templates/sms/" + templateId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public SmsTemplate getSmsTemplate(String templateId) {
        Assert.hasText((String)templateId, (String)"'templateId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/templates/sms/" + templateId + "", SmsTemplate.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public SmsTemplate partialUpdateSmsTemplate(SmsTemplate smsTemplate, String templateId) {
        Assert.notNull((Object)smsTemplate, (String)"'smsTemplate' is required and cannot be null.");
        Assert.hasText((String)templateId, (String)"'templateId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/templates/sms/" + templateId + "", smsTemplate, null, SmsTemplate.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return smsTemplate;
    }

    public SmsTemplate updateSmsTemplate(SmsTemplate smsTemplate, String templateId) {
        Assert.notNull((Object)smsTemplate, (String)"'smsTemplate' is required and cannot be null.");
        Assert.hasText((String)templateId, (String)"'templateId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/templates/sms/" + templateId + "";
        this.getDataStore().save(href, smsTemplate, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return smsTemplate;
    }

    public ThreatInsightConfiguration getCurrentConfiguration() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/threats/configuration", ThreatInsightConfiguration.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ThreatInsightConfiguration updateConfiguration(ThreatInsightConfiguration threatInsightConfiguration) {
        Assert.notNull((Object)threatInsightConfiguration, (String)"'threatInsightConfiguration' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/threats/configuration", threatInsightConfiguration, null, ThreatInsightConfiguration.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return threatInsightConfiguration;
    }

    public TrustedOriginList listOrigins(String q, String filter) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/trustedOrigins", TrustedOriginList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public TrustedOriginList listOrigins() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/trustedOrigins", TrustedOriginList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public TrustedOrigin createOrigin(TrustedOrigin trustedOrigin) {
        Assert.notNull((Object)trustedOrigin, (String)"'trustedOrigin' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/trustedOrigins", trustedOrigin, null, TrustedOrigin.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return trustedOrigin;
    }

    public void deleteOrigin(String trustedOriginId) {
        Assert.hasText((String)trustedOriginId, (String)"'trustedOriginId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/trustedOrigins/" + trustedOriginId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public TrustedOrigin getOrigin(String trustedOriginId) {
        Assert.hasText((String)trustedOriginId, (String)"'trustedOriginId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/trustedOrigins/" + trustedOriginId + "", TrustedOrigin.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public TrustedOrigin updateOrigin(TrustedOrigin trustedOrigin, String trustedOriginId) {
        Assert.notNull((Object)trustedOrigin, (String)"'trustedOrigin' is required and cannot be null.");
        Assert.hasText((String)trustedOriginId, (String)"'trustedOriginId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/trustedOrigins/" + trustedOriginId + "";
        this.getDataStore().save(href, trustedOrigin, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return trustedOrigin;
    }

    public TrustedOrigin activateOrigin(String trustedOriginId) {
        Assert.hasText((String)trustedOriginId, (String)"'trustedOriginId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/trustedOrigins/" + trustedOriginId + "/lifecycle/activate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, TrustedOrigin.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public TrustedOrigin deactivateOrigin(String trustedOriginId) {
        Assert.hasText((String)trustedOriginId, (String)"'trustedOriginId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/trustedOrigins/" + trustedOriginId + "/lifecycle/deactivate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, TrustedOrigin.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserList listUsers(String q, String filter, String search, String sortBy, String sortOrder) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (q != null) {
            queryArgs.put("q", q);
        }
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        if (search != null) {
            queryArgs.put("search", search);
        }
        if (sortBy != null) {
            queryArgs.put("sortBy", sortBy);
        }
        if (sortOrder != null) {
            queryArgs.put("sortOrder", sortOrder);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users", UserList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserList listUsers() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users", UserList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public User createUser(CreateUserRequest body, Boolean activate, Boolean provider, UserNextLogin nextLogin) {
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (activate != null) {
            queryArgs.put("activate", activate);
        }
        if (provider != null) {
            queryArgs.put("provider", provider);
        }
        if (nextLogin != null) {
            queryArgs.put("nextLogin", nextLogin);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users", body, null, User.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public User createUser(CreateUserRequest body) {
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users", body, null, User.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public void setLinkedObjectForUser(String associatedUserId, String primaryRelationshipName, String primaryUserId) {
        Assert.hasText((String)associatedUserId, (String)"'associatedUserId' is required and cannot be null or empty.");
        Assert.hasText((String)primaryRelationshipName, (String)"'primaryRelationshipName' is required and cannot be null or empty.");
        Assert.hasText((String)primaryUserId, (String)"'primaryUserId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/users/" + associatedUserId + "/linkedObjects/" + primaryRelationshipName + "/" + primaryUserId + "";
        this.getDataStore().save(href, new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deactivateOrDeleteUser(String userId, Boolean sendEmail) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (sendEmail != null) {
            queryArgs.put("sendEmail", sendEmail);
        }
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public void deactivateOrDeleteUser(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public User getUser(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "", User.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public User partialUpdateUser(User user, String userId, Boolean strict) {
        Assert.notNull((Object)user, (String)"'user' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (strict != null) {
            queryArgs.put("strict", strict);
        }
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "", user, null, User.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return user;
    }

    public User partialUpdateUser(User user, String userId) {
        Assert.notNull((Object)user, (String)"'user' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "", user, null, User.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return user;
    }

    public User updateUser(User user, String userId, Boolean strict) {
        Assert.notNull((Object)user, (String)"'user' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (strict != null) {
            queryArgs.put("strict", strict);
        }
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/users/" + userId + "";
        this.getDataStore().save(href, user, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return user;
    }

    public User updateUser(User user, String userId) {
        Assert.notNull((Object)user, (String)"'user' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/users/" + userId + "";
        this.getDataStore().save(href, user, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return user;
    }

    public AppLinkList listAppLinks(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/appLinks", AppLinkList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ClientList listUserClients(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/clients", OAuth2ClientList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void revokeGrantsForUserAndClient(String userId, String clientId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/clients/" + clientId + "/grants", queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ScopeConsentGrantList listGrantsForUserAndClient(String userId, String clientId, String expand) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/clients/" + clientId + "/grants", OAuth2ScopeConsentGrantList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ScopeConsentGrantList listGrantsForUserAndClient(String userId, String clientId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/clients/" + clientId + "/grants", OAuth2ScopeConsentGrantList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void revokeTokensForUserAndClient(String userId, String clientId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/clients/" + clientId + "/tokens", queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2RefreshTokenList listRefreshTokensForUserAndClient(String userId, String clientId, String expand) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/clients/" + clientId + "/tokens", OAuth2RefreshTokenList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2RefreshTokenList listRefreshTokensForUserAndClient(String userId, String clientId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/clients/" + clientId + "/tokens", OAuth2RefreshTokenList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void revokeTokenForUserAndClient(String userId, String clientId, String tokenId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        Assert.hasText((String)tokenId, (String)"'tokenId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/clients/" + clientId + "/tokens/" + tokenId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2RefreshToken getRefreshTokenForUserAndClient(String userId, String clientId, String tokenId, String expand) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        Assert.hasText((String)tokenId, (String)"'tokenId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/clients/" + clientId + "/tokens/" + tokenId + "", OAuth2RefreshToken.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2RefreshToken getRefreshTokenForUserAndClient(String userId, String clientId, String tokenId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)clientId, (String)"'clientId' is required and cannot be null or empty.");
        Assert.hasText((String)tokenId, (String)"'tokenId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/clients/" + clientId + "/tokens/" + tokenId + "", OAuth2RefreshToken.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserCredentials changePassword(ChangePasswordRequest changePasswordRequest, String userId, Boolean strict) {
        Assert.notNull((Object)changePasswordRequest, (String)"'changePasswordRequest' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (strict != null) {
            queryArgs.put("strict", strict);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/credentials/change_password", changePasswordRequest, null, UserCredentials.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public UserCredentials changePassword(ChangePasswordRequest changePasswordRequest, String userId) {
        Assert.notNull((Object)changePasswordRequest, (String)"'changePasswordRequest' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/credentials/change_password", changePasswordRequest, null, UserCredentials.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public UserCredentials changeRecoveryQuestion(UserCredentials userCredentials, String userId) {
        Assert.notNull((Object)userCredentials, (String)"'userCredentials' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/credentials/change_recovery_question", userCredentials, null, UserCredentials.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return userCredentials;
    }

    public ForgotPasswordResponse forgotPassword(String userId, Boolean sendEmail) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (sendEmail != null) {
            queryArgs.put("sendEmail", sendEmail);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/credentials/forgot_password", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, ForgotPasswordResponse.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ForgotPasswordResponse forgotPassword(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/credentials/forgot_password", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, ForgotPasswordResponse.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserCredentials forgotPasswordSetNewPassword(UserCredentials userCredentials, String userId, Boolean sendEmail) {
        Assert.notNull((Object)userCredentials, (String)"'userCredentials' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (sendEmail != null) {
            queryArgs.put("sendEmail", sendEmail);
        }
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/credentials/forgot_password_recovery_question", userCredentials, null, UserCredentials.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return userCredentials;
    }

    public UserCredentials forgotPasswordSetNewPassword(UserCredentials userCredentials, String userId) {
        Assert.notNull((Object)userCredentials, (String)"'userCredentials' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/credentials/forgot_password_recovery_question", userCredentials, null, UserCredentials.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return userCredentials;
    }

    public UserFactorList listFactors(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/factors", UserFactorList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserFactor enrollFactor(UserFactor body, String userId, Boolean updatePhone, String templateId, Integer tokenLifetimeSeconds, Boolean activate) {
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (updatePhone != null) {
            queryArgs.put("updatePhone", updatePhone);
        }
        if (templateId != null) {
            queryArgs.put("templateId", templateId);
        }
        if (tokenLifetimeSeconds != null) {
            queryArgs.put("tokenLifetimeSeconds", tokenLifetimeSeconds);
        }
        if (activate != null) {
            queryArgs.put("activate", activate);
        }
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/factors", body, null, UserFactor.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return body;
    }

    public UserFactor enrollFactor(UserFactor body, String userId) {
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/factors", body, null, UserFactor.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return body;
    }

    public UserFactorList listSupportedFactors(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/factors/catalog", UserFactorList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public SecurityQuestionList listSupportedSecurityQuestions(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/factors/questions", SecurityQuestionList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deleteFactor(String userId, String factorId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)factorId, (String)"'factorId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/factors/" + factorId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public UserFactor getFactor(String userId, String factorId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)factorId, (String)"'factorId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/factors/" + factorId + "", UserFactor.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserFactor activateFactor(String userId, String factorId, ActivateFactorRequest body) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)factorId, (String)"'factorId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/factors/" + factorId + "/lifecycle/activate", body, null, UserFactor.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public UserFactor activateFactor(String userId, String factorId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)factorId, (String)"'factorId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/factors/" + factorId + "/lifecycle/activate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, UserFactor.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public VerifyUserFactorResponse getFactorTransactionStatus(String userId, String factorId, String transactionId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)factorId, (String)"'factorId' is required and cannot be null or empty.");
        Assert.hasText((String)transactionId, (String)"'transactionId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/factors/" + factorId + "/transactions/" + transactionId + "", VerifyUserFactorResponse.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public VerifyUserFactorResponse verifyFactor(String userId, String factorId, VerifyFactorRequest body, String templateId, Integer tokenLifetimeSeconds, String xForwardedFor, String userAgent, String acceptLanguage) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)factorId, (String)"'factorId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (templateId != null) {
            queryArgs.put("templateId", templateId);
        }
        if (tokenLifetimeSeconds != null) {
            queryArgs.put("tokenLifetimeSeconds", tokenLifetimeSeconds);
        }
        HttpHeaders headers = new HttpHeaders();
        if (xForwardedFor != null) {
            headers.add("X-Forwarded-For", xForwardedFor);
        }
        if (userAgent != null) {
            headers.add("User-Agent", userAgent);
        }
        if (acceptLanguage != null) {
            headers.add("Accept-Language", acceptLanguage);
        }
        return this.getDataStore().create("/api/v1/users/" + userId + "/factors/" + factorId + "/verify", body, null, VerifyUserFactorResponse.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public VerifyUserFactorResponse verifyFactor(String userId, String factorId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)factorId, (String)"'factorId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/factors/" + factorId + "/verify", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VerifyUserFactorResponse.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void revokeUserGrants(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/grants", queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ScopeConsentGrantList listUserGrants(String userId, String scopeId, String expand) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (scopeId != null) {
            queryArgs.put("scopeId", scopeId);
        }
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/grants", OAuth2ScopeConsentGrantList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ScopeConsentGrantList listUserGrants(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/grants", OAuth2ScopeConsentGrantList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void revokeUserGrant(String userId, String grantId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)grantId, (String)"'grantId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/grants/" + grantId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ScopeConsentGrant getUserGrant(String userId, String grantId, String expand) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)grantId, (String)"'grantId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/grants/" + grantId + "", OAuth2ScopeConsentGrant.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public OAuth2ScopeConsentGrant getUserGrant(String userId, String grantId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)grantId, (String)"'grantId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/grants/" + grantId + "", OAuth2ScopeConsentGrant.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupList listUserGroups(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/groups", GroupList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public IdentityProviderList listUserIdentityProviders(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/idps", IdentityProviderList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserActivationToken activateUser(String userId, Boolean sendEmail) {
        Assert.notNull((Object)sendEmail, (String)"'sendEmail' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (sendEmail != null) {
            queryArgs.put("sendEmail", sendEmail);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/activate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, UserActivationToken.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deactivateUser(String userId, Boolean sendEmail) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (sendEmail != null) {
            queryArgs.put("sendEmail", sendEmail);
        }
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/deactivate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deactivateUser(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/deactivate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public User expirePassword(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/expire_password", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, User.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public TempPassword expirePasswordAndGetTemporaryPassword(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/expire_password_with_temp_password", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, TempPassword.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserActivationToken reactivateUser(String userId, Boolean sendEmail) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (sendEmail != null) {
            queryArgs.put("sendEmail", sendEmail);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/reactivate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, UserActivationToken.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public UserActivationToken reactivateUser(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/reactivate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, UserActivationToken.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void resetFactors(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/reset_factors", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ResetPasswordToken resetPassword(String userId, Boolean sendEmail) {
        Assert.notNull((Object)sendEmail, (String)"'sendEmail' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (sendEmail != null) {
            queryArgs.put("sendEmail", sendEmail);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/reset_password", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, ResetPasswordToken.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void suspendUser(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/suspend", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void unlockUser(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/unlock", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void unsuspendUser(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/lifecycle/unsuspend", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void removeLinkedObjectForUser(String userId, String relationshipName) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)relationshipName, (String)"'relationshipName' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/linkedObjects/" + relationshipName + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public ResponseLinksList getLinkedObjectsForUser(String userId, String relationshipName) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)relationshipName, (String)"'relationshipName' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/linkedObjects/" + relationshipName + "", ResponseLinksList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public RoleList listAssignedRolesForUser(String userId, String expand) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/roles", RoleList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public RoleList listAssignedRolesForUser(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/roles", RoleList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Role assignRoleToUser(AssignRoleRequest assignRoleRequest, String userId, Boolean disableNotifications) {
        Assert.notNull((Object)assignRoleRequest, (String)"'assignRoleRequest' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (disableNotifications != null) {
            queryArgs.put("disableNotifications", disableNotifications);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/roles", assignRoleRequest, null, Role.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public Role assignRoleToUser(AssignRoleRequest assignRoleRequest, String userId) {
        Assert.notNull((Object)assignRoleRequest, (String)"'assignRoleRequest' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/roles", assignRoleRequest, null, Role.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public void removeRoleFromUser(String userId, String roleId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/roles/" + roleId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public Role getUserRole(String userId, String roleId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/roles/" + roleId + "", Role.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public CatalogApplicationList listApplicationTargetsForApplicationAdministratorRoleForUser(String userId, String roleId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/roles/" + roleId + "/targets/catalog/apps", CatalogApplicationList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void addAllAppsAsTargetToRole(String userId, String roleId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/catalog/apps";
        this.getDataStore().save(href, new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, queryArgs, (Map<String, List<String>>)headers);
    }

    public void removeApplicationTargetFromApplicationAdministratorRoleForUser(String userId, String roleId, String appName) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)appName, (String)"'appName' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/roles/" + roleId + "/targets/catalog/apps/" + appName + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public void addApplicationTargetToAdminRoleForUser(String userId, String roleId, String appName) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)appName, (String)"'appName' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/catalog/apps/" + appName + "";
        this.getDataStore().save(href, new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, queryArgs, (Map<String, List<String>>)headers);
    }

    public void removeApplicationTargetFromAdministratorRoleForUser(String userId, String roleId, String appName, String applicationId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)appName, (String)"'appName' is required and cannot be null or empty.");
        Assert.hasText((String)applicationId, (String)"'applicationId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/roles/" + roleId + "/targets/catalog/apps/" + appName + "/" + applicationId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public void addApplicationTargetToAppAdminRoleForUser(String userId, String roleId, String appName, String applicationId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)appName, (String)"'appName' is required and cannot be null or empty.");
        Assert.hasText((String)applicationId, (String)"'applicationId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/catalog/apps/" + appName + "/" + applicationId + "";
        this.getDataStore().save(href, new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, queryArgs, (Map<String, List<String>>)headers);
    }

    public GroupList listGroupTargetsForRole(String userId, String roleId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/roles/" + roleId + "/targets/groups", GroupList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void removeGroupTargetFromRole(String userId, String roleId, String groupId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/roles/" + roleId + "/targets/groups/" + groupId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public void addGroupTargetToRole(String userId, String roleId, String groupId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/groups/" + groupId + "";
        this.getDataStore().save(href, new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, queryArgs, (Map<String, List<String>>)headers);
    }

    public void clearUserSessions(String userId, Boolean oAuthTokens) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (oAuthTokens != null) {
            queryArgs.put("oauthTokens", oAuthTokens);
        }
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/sessions", queryArgs, (Map<String, List<String>>)headers);
    }

    public void clearUserSessions(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/sessions", queryArgs, (Map<String, List<String>>)headers);
    }

    public SubscriptionList listUserSubscriptions(String userId) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/subscriptions", SubscriptionList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Subscription getUserSubscriptionByNotificationType(String userId, String notificationType) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)notificationType, (String)"'notificationType' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/users/" + userId + "/subscriptions/" + notificationType + "", Subscription.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void subscribeUserSubscriptionByNotificationType(String userId, String notificationType) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)notificationType, (String)"'notificationType' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/subscriptions/" + notificationType + "/subscribe", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void unsubscribeUserSubscriptionByNotificationType(String userId, String notificationType) {
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)notificationType, (String)"'notificationType' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/users/" + userId + "/subscriptions/" + notificationType + "/unsubscribe", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public NetworkZoneList listNetworkZones(String filter) {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (filter != null) {
            queryArgs.put("filter", filter);
        }
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/zones", NetworkZoneList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public NetworkZoneList listNetworkZones() {
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/zones", NetworkZoneList.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public NetworkZone createNetworkZone(NetworkZone zone) {
        Assert.notNull((Object)zone, (String)"'zone' is required and cannot be null.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/zones", zone, null, NetworkZone.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return zone;
    }

    public void deleteNetworkZone(String zoneId) {
        Assert.hasText((String)zoneId, (String)"'zoneId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/zones/" + zoneId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public NetworkZone getNetworkZone(String zoneId) {
        Assert.hasText((String)zoneId, (String)"'zoneId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/zones/" + zoneId + "", NetworkZone.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public NetworkZone updateNetworkZone(NetworkZone zone, String zoneId) {
        Assert.notNull((Object)zone, (String)"'zone' is required and cannot be null.");
        Assert.hasText((String)zoneId, (String)"'zoneId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/zones/" + zoneId + "";
        this.getDataStore().save(href, zone, null, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
        return zone;
    }

    public NetworkZone activateNetworkZone(String zoneId) {
        Assert.hasText((String)zoneId, (String)"'zoneId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/zones/" + zoneId + "/lifecycle/activate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, NetworkZone.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public NetworkZone deactivateNetworkZone(String zoneId) {
        Assert.hasText((String)zoneId, (String)"'zoneId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/zones/" + zoneId + "/lifecycle/deactivate", new DefaultVoidResource((InternalDataStore)this.getDataStore()), null, NetworkZone.class, queryArgs, (Map<String, List<String>>)headers);
    }
}

